/**
 * Copyright ohisama ( http://wonderfl.net/user/ohisama )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pqek
 */

package
{
    import flash.events.Event;
    import flash.events.KeyboardEvent;
    import flash.ui.Keyboard;
    import flash.utils.Dictionary;
    import org.papervision3d.view.*;
    import org.papervision3d.objects.*;
    import Box2D.Dynamics.*;
    import Box2D.Collision.*;
    import Box2D.Common.Math.*;
    import org.papervision3d.lights.PointLight3D;
    import Box2D.Collision.Shapes.b2PolygonDef;
    import org.papervision3d.materials.shadematerials.FlatShadeMaterial;
    import org.papervision3d.materials.utils.MaterialsList;
    import org.papervision3d.objects.primitives.Cube;
    import org.papervision3d.objects.parsers.DAE;
    import org.papervision3d.view.BasicView;
    [SWF(backgroundColor="#000000", width="475", height="475")]
    public class Main extends BasicView
    {
        private var ii : Number;
        private var worldWidth : Number;
        private var worldHeight : Number;
        private var m_iterations : int;
        private var m_wallWidth : Number;
        private var m_wallHeight : Number;
        private var m_timeStep : Number;
        private var m_physScale : Number;
        private var m_world : b2World;
        private var cubeSize : int;
        private var pv3d_height : Number;
        private var dae : DAE;
        public function Main()
        {
            camera.x = 3;
            camera.y = 1;
            camera.z = -3;
            cubeSize = 1;
            pv3d_height = 80;
            var light : PointLight3D = new PointLight3D(true);
            light.z = -200;
            light.y = 300;
            worldWidth = stage.stageWidth;
            worldHeight = stage.stageHeight;
            m_iterations = 30;
            m_timeStep = 1 / 20;
            m_physScale = 30;
            var worldAABB : b2AABB = new b2AABB;
            worldAABB.lowerBound.Set(-100.0, -100.0);
            worldAABB.upperBound.Set(100.0, 100.0);
            var gravity : b2Vec2 = new b2Vec2(0.0, -9.8);
            m_world = new b2World(worldAABB, gravity, true);
            var wallShapeDef : b2PolygonDef = new b2PolygonDef();
            var wallBodyDef : b2BodyDef = new b2BodyDef();
            var wall : b2Body;
            m_wallWidth = 500;
            m_wallHeight = 300;
            wallShapeDef.SetAsBox(10 / m_physScale, m_wallHeight / 2 / m_physScale);
            wallBodyDef.position.Set(0, m_wallHeight / 2 / m_physScale);
            wall = m_world.CreateBody(wallBodyDef);
            wall.CreateShape(wallShapeDef);
            wallBodyDef.position.Set(m_wallWidth / m_physScale, m_wallHeight/2/m_physScale);
            wall = m_world.CreateBody(wallBodyDef);
            wall.CreateShape(wallShapeDef);
            wallShapeDef.SetAsBox(m_wallWidth / 2 / m_physScale, 10 / m_physScale);
            wallBodyDef.position.Set(m_wallWidth / 2 / m_physScale, 0);
            wall = m_world.CreateBody(wallBodyDef);
            wall.CreateShape(wallShapeDef);
            wallBodyDef.position.Set(m_wallWidth / 2 / m_physScale, m_wallHeight/m_physScale);
            wall = m_world.CreateBody(wallBodyDef);
            wall.CreateShape(wallShapeDef);
            wall.SetMassFromShapes();
            var colorArray : Array = [0xff0000, 0x00ff00, 0x0000ff, 0xffff00, 0xffffff];
            for (var i : int = 0; i < 5; i++)
            {
                var mat : FlatShadeMaterial = new FlatShadeMaterial(light, colorArray[i] as uint);
                mat.interactive = true;
                var matList : MaterialsList = new MaterialsList({all:mat});
                var cube : Cube = new Cube(matList, cubeSize, cubeSize, cubeSize);
                //cube.extra = {width : cubeSize / 2, height : cubeSize / 2, arrayPos : i};
                cube.x = (i * 2) - 3;
                cube.y = 0;
                scene.addChild(cube);
                var boxShape : b2PolygonDef = new b2PolygonDef();
                boxShape.SetAsBox(cubeSize / 2 / m_physScale, cubeSize / 2 / m_physScale);
                boxShape.density = 8;
                boxShape.friction = 8;
                boxShape.restitution = 0.5;
                var bodyDef : b2BodyDef = new b2BodyDef();
                bodyDef.position.Set((cube.x + worldWidth / 2) / m_physScale, (cube.y + worldHeight/2)/m_physScale);
                var body : b2Body = m_world.CreateBody(bodyDef);
                body.CreateShape(boxShape);
                body.SetUserData(cube);
                body.SetMassFromShapes();
            }
            dae = new DAE(true, null, true);
            dae.load("http://yumekikaku.dip.jp/obj/miku_run.dae");
            dae.y = -1;
            dae.z = 20;       
            scene.addChild(dae);
            ii = 0;
            startRendering();
            dae.play();
        } 
        override protected function onRenderTick(event : Event = null) : void
        {
            m_world.Step(m_timeStep, m_iterations);
            dae.z -= 0.1;
            if (dae.z < -20) dae.z = 20;
            super.onRenderTick(event);
        }
    }
}

