/**
 * Copyright miyaoka ( http://wonderfl.net/user/miyaoka )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ppoM
 */

// forked from miyaoka's moyou


package 
{
	import flash.display.Sprite;
	import flash.events.MouseEvent;
	import caurina.transitions.Tweener;
	
	public class Main extends Sprite 
	{
		private var bgColors:Array = [0xFFFFFF, 0x000000];
		private var bgColorIdx:uint = 0;
		public var tweenMouseX:Number = mouseX;
		public var tweenMouseY:Number = mouseY;
		
		public function Main():void 
		{
			setShapes();
			stage.addEventListener(MouseEvent.MOUSE_DOWN, mouseClickHandler);
			stage.addEventListener(MouseEvent.MOUSE_MOVE, mouseMoveHandler);
		}
		private function mouseClickHandler(evt:MouseEvent):void 
		{
			setShapes();
		}
		private function mouseMoveHandler(evt:MouseEvent):void 
		{
			Tweener.removeAllTweens();
			Tweener.addTween(this, {
				tweenMouseX: mouseX,
				tweenMouseY: mouseY,
				time:0.5,
				transition:"easeOutCubic", 
				onUpdate:mouseTweenUpdateHandler
			 });
			 
		}
		private function mouseTweenUpdateHandler():void 
		{
			var evt:MouseTweenEvent = new MouseTweenEvent(MouseTweenEvent.UPDATE);
			evt.mouseX = tweenMouseX;
			evt.mouseY = tweenMouseY;
			dispatchEvent(evt);
		}

		private function setShapes():void 
		{
			graphics.clear();
			graphics.beginFill(bgColors[bgColorIdx]);
			graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
			graphics.endFill();
			bgColorIdx = ++bgColorIdx % bgColors.length;
			
			while(0 < numChildren) removeChildAt(0);
			
			var c:uint;
			var r:uint;
			var rot:uint;

			var size:Number = 25 * (Math.random() + 0.5);
			var filterStrength:Number = Math.random() * 5 + 1;
			var center:Number = (Math.random() * 2 - 1) * size * 0.5;
			
			var col:uint = Math.ceil(stage.stageWidth / size) + 1;
			var row:uint = Math.ceil(stage.stageHeight / size * 0.5) + 1;
			
			for (c = 0; c < col; c++)
			{
				for (r = 0; r < row; r++)
				{
					var spX:Number = size * c;
					var spY:Number = size * 2 * (r + c % 2 * 0.5);
					for (rot = 0; rot < 4; rot++)
					{
						var sp:Shape = new Shape(this, size, center,center, filterStrength);
						sp.rotation = 90 * rot;
						sp.x = spX;
						sp.y = spY;
					}
				}
			}
		}
	}	
}

import flash.display.DisplayObjectContainer;
import flash.display.Sprite
//import flash.events.MouseEvent;
import flash.geom.Point;
import flash.filters.GlowFilter;
import flash.filters.BitmapFilterQuality;

class Shape
extends Sprite
{
	private var size:Number;
	public function Shape(parent_:DisplayObjectContainer, size_:Number = 25, centerX:Number = 0, centerY:Number = 0, filterStrength:Number = 1 ):void 
	{
		parent_.addChild(this);
//		stage.addEventListener(MouseEvent.MOUSE_MOVE, mouseMoveHandler, false, 0, true);
		parent_.addEventListener(MouseTweenEvent.UPDATE, mouseTweenHandler, false, 0, true);
		
		size = size_;

        var color:Number = Math.random() * 0xFFFFFF;
		//var alpha:Number = 1;
		//var blurX:Number = size * 0.5;
		//var blurY:Number = size * 0.5;
		//var strength:Number = filterStrength;
		//var inner:Boolean = false;
		//var knockout:Boolean = false;
		//var quality:Number = BitmapFilterQuality.LOW;
//
		//filters = new Array(new GlowFilter(color,
							  //alpha,
							  //blurX,
							  //blurY,
							  //strength,
							  //quality,
							  //inner,
							  //knockout));

        graphics.beginFill(color);
		graphics.moveTo(size / 2 - centerX, 0 - centerY);
		graphics.curveTo(size - centerX, 0 - centerY, size/2 - centerX, size/2 - centerY);
		graphics.curveTo(0 - centerX, size - centerY, 0 - centerX, size/2 - centerY);
		graphics.curveTo(0 - centerX, 0 - centerY, size/2 - centerX, 0 - centerY);	
        graphics.endFill();
	}
	//private function mouseMoveHandler(evt:MouseEvent):void 
	//{
	//
	//}
	private function mouseTweenHandler(evt:MouseTweenEvent):void 
	{
		scaleUpdate(evt.mouseX -x, evt.mouseY - y);
	}
	private function scaleUpdate(mouseX_:Number, mouseY_:Number):void 
	{
		 scaleX = scaleY = Math.min(5, Math.sqrt(size / Point.distance(new Point(), new Point(mouseX_, mouseY_)))* 2);
	}
	
}

import flash.events.Event
class MouseTweenEvent
extends Event
{
	public static const UPDATE:String = "update";
	public var mouseX:Number;
	public var mouseY:Number;
		public function MouseTweenEvent(type:String, bubbles:Boolean=false, cancelable:Boolean=false) 
		{ 
			super(type, bubbles, cancelable);
		} 
}
