/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pojc
 */

// forked from flashmafia's Barbapapa
// forked from mwelsh's flash on 2012-9-21
package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Rectangle;
    import flash.utils.getTimer;

    [SWF(width='512', height='512', backgroundColor='0x0', frameRate='32')]
    public class Barbapapa extends Sprite {
        private var _bitmapData : BitmapData;
        private var _rect : Rectangle;
        private var _t : Number;

        public function Barbapapa() {
            addChild(new Bitmap(_bitmapData = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0x0)));

            _rect = new Rectangle();

            _t = 0.0;

            addEventListener(Event.ENTER_FRAME, oef);
        }

        private function oef(event : Event) : void {
            _bitmapData.fillRect(_bitmapData.rect, 0x7C003E);
            
            _rect.height = 1;

            var now : Number = Math.sin(getTimer() / 1000);
            var t : Number = (_t += 0.016);
            var t2 : Number = 0.00165 - 0.0033 * Math.sin(now);
            var cx : int = stage.stageWidth >> 1;
            var lum : uint;

            var i : uint = stage.stageHeight;
            while (i-- != 0) {
                t += now * t2;

                var cos : Number = Math.cos(t);
                var sin : Number = Math.sin(t);

                var x0 : Number = (0.5 * cos + 1) * cx;
                var x1 : Number = (0.5 * sin + 1) * cx;
                var x2 : Number = (-0.5 * cos + 1) * cx;
                var x3 : Number = (-0.5 * sin + 1) * cx;

                _rect.y = i;

                if (x0 < x1) {
                    _rect.x = x0;
                    _rect.width = x1 - x0;

                    lum = uint((0.5 + 0.5 * cos) * 0x88 + 0x55);
                    _bitmapData.fillRect(_rect, (lum << 16) | 0 | (lum >> 1));
                }

                if (x1 < x2) {
                    _rect.x = x1;
                    _rect.width = x2 - x1;

                    lum = uint((0.5 + 0.5 * sin) * 0x88 + 0x55);
                    _bitmapData.fillRect(_rect, (lum << 16) | 0 | (lum >> 1));
                }

                if (x2 < x3) {
                    _rect.x = x2;
                    _rect.width = x3 - x2;

                    lum = uint((0.5 - 0.5 * cos) * 0x88 + 0x55);
                    _bitmapData.fillRect(_rect, (lum << 16) | 0 | (lum >> 1));
                }

                if (x3 < x0) {
                    _rect.x = x3;
                    _rect.width = x0 - x3;

                    lum = uint((0.5 + 0.5 * sin) * 0x88 + 0x55);
                    _bitmapData.fillRect(_rect, (lum << 16) | 0 | (lum >> 1));
                }
            }
        }
    }
}