/**
 * Copyright kotobuki ( http://wonderfl.net/user/kotobuki )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/poFa
 */

// Change the color of a BlinkM periodically 
// 
// Preparation:
// * upload Firmata/I2CFirmata (Arduino 0017 or later)
// 
// Reference:
// http://thingm.com/products/blinkm
// 
// Where to buy:
// http://www.sparkfun.com/commerce/product_info.php?products_id=8579
// http://www.switch-science.com/products/detail.php?product_id=32

package {
    import flash.display.Sprite;
    import flash.events.TimerEvent;
    import flash.utils.Timer;

    import funnel.*;
    import funnel.i2c.*;

    public class ArduinoI2CBlinkM extends Sprite {
        private var pulseGenerator:Timer;
        private var arduino:Arduino;
        private var blinkM:BlinkM;

        public function ArduinoI2CBlinkM() {
            var config:Configuration = Arduino.FIRMATA;
            config.enablePowerPins();
            
            arduino = new Arduino(config);
            arduino.addEventListener(FunnelEvent.READY, onReady);
        }

        private function onReady(event:FunnelEvent):void {
            blinkM = new BlinkM(arduino);

            pulseGenerator = new Timer(1000);
            pulseGenerator.addEventListener(TimerEvent.TIMER, onPulse);
            pulseGenerator.start();

            blinkM.stopScript();
            blinkM.goToRGBColorNow([0, 0, 0]);
        }

        private function onPulse(e:TimerEvent):void {
            blinkM.fadeToRandomRGBColor([255, 255, 255], 10);
        }
    }
}