/**
 * Copyright fukt ( http://wonderfl.net/user/fukt )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pnJY
 */

// forked from cpu_t's DisplacementMapFilter
package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Loader;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.filters.DisplacementMapFilter;
    import flash.geom.Point;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;
    import flash.text.StyleSheet;
    
    import net.hires.debug.Stats;
    public class FlashTest extends Sprite
    {
        private var mapFilter:DisplacementMapFilter;
        private var filterData:BitmapData;
        private var isLoadComp:Boolean = false;
        private var bmpdata:BitmapData;
        private var view:BitmapData;
        
        public function FlashTest()
        {
            stage.addChild(new Stats());
            
            var seed:int = int(Math.random() * 0xFFFFFF);
            var offsets:Array = new Array();
            offsets[0] = new Point(0, 0);
            offsets[1] = new Point(0, 0);
            filterData = new BitmapData(stage.stageWidth, stage.stageHeight);
            filterData.perlinNoise(stage.stageWidth / 2, stage.stageHeight / 2, 2, seed, false, false, 3, false, offsets);
            
            mapFilter = new DisplacementMapFilter(filterData, filterData.rect.topLeft, 1, 2);
            
            loadAndSet();
            addChild(new Bitmap(view));
            
            var count:Number = 0;
            addEventListener(Event.ENTER_FRAME, function(e:Event):void
            {
                if (!isLoadComp) return;
                view.applyFilter(bmpdata, bmpdata.rect, bmpdata.rect.topLeft, mapFilter);
                
                count++;
                offsets[1].x = (offsets[0].x += (Math.cos(count*Math.PI/180)-1) * 3) * .5;
                offsets[1].y = (offsets[0].y += (Math.cos(Math.PI+count*Math.PI/180)-1) * 3) * .5;
                filterData.perlinNoise(stage.stageWidth / 2, stage.stageHeight / 2, 2, seed, false, false, 3, false, offsets);
            });
        }
        
        private function loadAndSet():void
        {
            var loader:Loader = new Loader();
            var req:URLRequest = new URLRequest("http://wonderfl.net/static/tmp/related_images/8eb64931e696097e3df29d12e4a817c87a49fafdm");
            loader.load(req, new LoaderContext(true));
            loader.contentLoaderInfo.addEventListener(Event.INIT, function(e:Event):void
            {
                var l:Loader = new Loader();
                l.loadBytes(loader.contentLoaderInfo.bytes);
                l.contentLoaderInfo.addEventListener(Event.COMPLETE, function(e:Event):void
                {
                    bmpdata = new BitmapData(l.width, l.height);
                    view = new BitmapData(l.width, l.height);
                    bmpdata.draw(l);
                    addChild(new Bitmap(view)).x=70;
                    mapFilter.scaleX = l.width / 2;
                    mapFilter.scaleY = l.height / 2;
                    isLoadComp = true;
                });
            });
        }
    }
}