/**
 * Copyright gaina ( http://wonderfl.net/user/gaina )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pnEF
 */

package  
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Point;
    import flash.media.Sound;
    import flash.media.SoundChannel;
    import flash.media.SoundLoaderContext;
    import flash.media.SoundMixer;
    import flash.net.URLRequest;
    import flash.utils.ByteArray;
    
    public class Main extends Sprite
    {
        private var snd:Sound;
        private var point_array:Array;
        
        function Main() 
        {
            point_array = points();
            playSound("http://www.takasumi-nagai.com/soundfiles/sound001.mp3");
        }
        
        private function playSound(sndUrl:String):void
        {
            snd = new Sound();
            var context:SoundLoaderContext = new SoundLoaderContext(10,true);
            var req:URLRequest = new URLRequest(sndUrl);
            snd.load(req, context);
            snd.addEventListener(Event.COMPLETE, SoundLoaded);
        }
        
        private function SoundLoaded(e:Event):void 
        {
            var sndChannel:SoundChannel=new SoundChannel();
            sndChannel = snd.play(0, 5);
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        private function onEnterFrame(event:Event):void {
            var bytes:ByteArray = new ByteArray();
            SoundMixer.computeSpectrum(bytes, false, 0);
            
            Drawing(bytes, 512);
        }
                
        private function Drawing(_bytes:ByteArray = null, num:int = 512, count:int = 2):void
        {
            graphics.clear();
            graphics.beginFill(0)
            graphics.drawRect(0,0,465,465);
            graphics.endFill();
            
            graphics.lineStyle(1, 0xFFFFFF);
            var n:uint;
            var i:uint;
            for (n = 0; n < count; n++) {
                for (i = 0; i < num / count; i++) {
                    var p:PointPlus = point_array[n][i] as PointPlus;
                    var data:Number = _bytes.readFloat();
                    if (n == 0) {
                        p.vx = p.x * data ;
                        p.vy = p.y * data ;
                    }else {
                        p.vx = p.x * data * 2 ;
                        p.vy = -(p.y * data) ;
                    }
                    if (i == 0) {
                        graphics.moveTo(p.x, p.y);
                        
                    }else {
                        graphics.curveTo(point_array[n][i-1].x, point_array[n][i-1].y, p.x + p.vx, p.y + p.vy);
                    }
                }
            }
            graphics.endFill();
        }
        
        private function points():Array
        {
            var container_array:Array = [];
            var i:int;
            var j:int;
            for (i = 0; i < 2; i++) {
                var _array:Array = [];
                for (j = 0; j < 256; j++) {
                    var p:PointPlus = new PointPlus();
                    p.x = stage.stageWidth / 2;
                    p.y = j * stage.stageHeight / 256;
                    _array.push(p);
                }
                container_array.push(_array);
            }
            return container_array;
        }
        
    }

}

class PointPlus
{
    public var x:int;
    public var y:int;
    public var vx:int;
    public var vy:int;
    
    public function PointPlus() {}
}