/**
 * Copyright asou_jp ( http://wonderfl.net/user/asou_jp )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pmvM
 */

// forked from kinihon's forked from: flash on 2012-6-18
// forked from honekingu's flash on 2012-6-18
package
{
    import flash.display.BlendMode;
    import flash.display.Sprite;
    
    public class Ball extends Sprite
    {
        private var ball:Sprite;
        
        public function Ball()
        {
             graphics.beginFill(0);
             graphics.drawRect(0,0,465,465);
             graphics.endFill();
            
            for(var i:int=0;i<50;i++){
                var aBall:ABall = new ABall(this.stage); 
                aBall.blendMode = BlendMode.SCREEN;
                addChild(aBall);
            }
            
        }
    }
}
import flash.display.Shape;
import flash.display.Sprite;
import flash.display.Stage;
import flash.events.Event;
import flash.events.MouseEvent;

class ABall extends Sprite
{
    private var ball:Sprite;
    private var _stage:Stage;
    public function ABall(_stage:Stage)
    {
        this._stage=_stage;
        
        ball=createBall(Math.random()*40+10,Math.random()*0xffffff);
        this.addEventListener(Event.ENTER_FRAME,move);
        ball.addEventListener(MouseEvent.MOUSE_DOWN,dragStart);
        this._stage.addEventListener(MouseEvent.MOUSE_MOVE,draging);
        this._stage.addEventListener(MouseEvent.MOUSE_UP,dragEnd);
        ball.x=Math.random()*_stage.stageWidth;
        ball.y=-200;
        addChild(ball);
    }
    
    private function createBall(radius:Number,color:Number):Sprite{
        var ball:Sprite=new Sprite();
        ball.graphics.beginFill(color,0.9);
        ball.graphics.drawCircle(0,0,radius);
        ball.graphics.endFill();
        return ball;
    }
    
    private var vx:Number=Math.random()*20+10;
    private var vy:Number=Math.random()*20+10;
    private function move(event:Event):void{
        if(!drag){
            if(ball.x-ball.width/2<0){
                ball.x=ball.width/2;
                vx=-vx;
            }
            if(ball.x+ball.width/2>stage.stageWidth){
                ball.x=stage.stageWidth-ball.width/2;
                vx=-vx;
            }
            if(ball.y+ball.height/2>stage.stageHeight){
                ball.y=stage.stageHeight-ball.height/2;
                vy=-(vy*0.6);
            }
            vy+=0.98;
            vx=vx*0.98;
            ball.x+=vx;
            ball.y+=vy;
        }
        if(Math.round(vy)==0&&Math.round(ball.y+ball.height/2-stage.stageHeight)==0){
            vx=Math.random()*40-20;
            vy=Math.random()*50+10;
        }
    }
    private var drag:Boolean;
    private var pmx:Number;
    private var pmy:Number;
    private function dragStart(event:MouseEvent):void{
        pmx=ball.x=mouseX;
        pmy=ball.y=mouseY;
        drag=true;
    }
    private function draging(event:MouseEvent):void{
        if(drag){
            ball.x=mouseX;
            ball.y=mouseY;
            vx=mouseX-pmx;
            vy=mouseY-pmy;
            pmx=mouseX;
            pmy=mouseY;
        }
    }
    private function dragEnd(event:MouseEvent):void{
        drag=false;
    }
}