/**
 * Copyright clockmaker ( http://wonderfl.net/user/clockmaker )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pmsW
 */

// forked from ProjectNya's ひよこちゃん増殖の巻
////////////////////////////////////////////////////////////////////////////////
// ひよこちゃん増殖の巻
// http://www.project-nya.jp/modules/weblog/details.php?blog_id=1203
////////////////////////////////////////////////////////////////////////////////

package {

    import flash.display.Sprite;
    import flash.display.MovieClip;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.system.Security;
    import flash.utils.Timer;
    import flash.events.TimerEvent;
    import flash.geom.Rectangle;
    import frocessing.color.ColorHSV;

    [SWF(backgroundColor="#000000", width="465", height="465", frameRate="30")]

    public class Main extends Sprite {
        private var id:uint = 0;
        private static var chickPath:String = "http://www.project-nya.jp/images/flash/chick.swf";
        private var wavelet:Wavelet;

        public function Main() {
            Wonderfl.capture_delay(30);
            init();
        }

        private function init():void {
            var rect:Rectangle = new Rectangle(0, 0, 465, 465);
            wavelet = new Wavelet(rect);
            addChild(wavelet);
            var color:ColorHSV = new ColorHSV();
            color.hsv(70, 1, 0.6);
            var color1:uint = color.value;
            color.hsv(60, 1, 0.4);
            var color2:uint = color.value;
            wavelet.color(color1, color2);
            var timer:Timer = new Timer(125, 64);
            timer.addEventListener(TimerEvent.TIMER, create, false, 0, true);
            timer.addEventListener(TimerEvent.TIMER_COMPLETE, finish, false, 0, true);
            timer.start();
        }
        private function create(evt:TimerEvent):void {
            load(evt.target.currentCount - 1);
        }
        private function finish(evt:TimerEvent):void {
            evt.target.removeEventListener(TimerEvent.TIMER, create);
            evt.target.removeEventListener(TimerEvent.TIMER_COMPLETE, finish);
        }
        private function load(id:uint):void {
            var loader:ChickLoader = new ChickLoader(id);
            loader.addEventListener(ChickLoader.COMPLETE, complete, false, 0, false);
            var time:Number = new Date().time;
            loader.load(chickPath + "?time=" + time);
        }
        private function complete(evt:Event):void {
            var loader:ChickLoader = ChickLoader(evt.target);
            loader.removeEventListener(ChickLoader.COMPLETE, complete);
            var chick:MovieClip = loader.content;
            addChild(chick);
            chick.x = 55 + 50*(loader.id%8);
            chick.y = 80 + 50*Math.floor(loader.id/8);
            //chick.scaleX = chick.scaleY = 2;
            //loader = null;
        }

    }

}




import flash.display.Sprite;
import flash.display.MovieClip;
import flash.display.Loader;
import flash.display.LoaderInfo;
import flash.net.URLRequest;
import flash.events.Event;
import flash.events.IOErrorEvent;
import flash.events.HTTPStatusEvent;
import flash.events.SecurityErrorEvent;
import flash.system.Security;

class ChickLoader extends Sprite {
    public var id:uint;
    private var loader:Loader;
    private var info:LoaderInfo;
    public var content:MovieClip;
    public static const IO_ERROR:String = IOErrorEvent.IO_ERROR;
    public static const HTTP_STATUS:String = HTTPStatusEvent.HTTP_STATUS;
    public static const SECURITY_ERROR:String = SecurityErrorEvent.SECURITY_ERROR;
    public static const INIT:String = Event.INIT;
    public static const COMPLETE:String = Event.COMPLETE;

    public function ChickLoader(n:uint) {
        Security.allowDomain("www.project-nya.jp");
        id = n;
        loader = new Loader();
        info = loader.contentLoaderInfo;
    }

    public function load(file:String):void {
        info.addEventListener(IOErrorEvent.IO_ERROR, ioerror, false, 0, true);
        info.addEventListener(HTTPStatusEvent.HTTP_STATUS, httpstatus, false, 0, true);
        info.addEventListener(SecurityErrorEvent.SECURITY_ERROR, securityerror, false, 0, true);
        info.addEventListener(Event.INIT, initialize, false, 0, true);
        info.addEventListener(Event.COMPLETE, complete, false, 0, false);
        try {
            loader.load(new URLRequest(file));
        } catch (err:Error) {
            trace(err.message);
            //load(file);
        }
    }
    public function unload():void {
        loader.unload();
    }
    private function ioerror(evt:IOErrorEvent):void {
        loader.unload();
        dispatchEvent(new Event(ChickLoader.IO_ERROR));
    }
    private function httpstatus(evt:HTTPStatusEvent):void {
        dispatchEvent(new Event(ChickLoader.HTTP_STATUS));
    }
    private function securityerror(evt:SecurityErrorEvent):void {
        dispatchEvent(new Event(ChickLoader.SECURITY_ERROR));
    }
    private function initialize(evt:Event):void {
        content = MovieClip(info.content);
        dispatchEvent(new Event(ChickLoader.INIT));
    }
    private function complete(evt:Event):void {
        info.removeEventListener(IOErrorEvent.IO_ERROR, ioerror);
        info.removeEventListener(HTTPStatusEvent.HTTP_STATUS, httpstatus);
        info.removeEventListener(SecurityErrorEvent.SECURITY_ERROR, securityerror);
        info.removeEventListener(Event.INIT, initialize);
        info.removeEventListener(Event.COMPLETE, complete);
        //addChild(loader);
        dispatchEvent(new Event(ChickLoader.COMPLETE));
    }

}


import flash.display.Sprite;
import flash.display.Shape;
import flash.display.BitmapData;
import flash.display.Bitmap;
import flash.geom.Matrix;
import flash.display.GradientType;
import flash.display.SpreadMethod;
import flash.display.InterpolationMethod;
import flash.filters.BlurFilter;
import flash.geom.Rectangle;
import flash.geom.Point;
import flash.display.BlendMode;
import flash.filters.ColorMatrixFilter;
//import com.quasimondo.geom.ColorMatrix;

class Wavelet extends Sprite {
    private var rect:Rectangle;
    private var wavelet:BitmapData;
    private var noise:BitmapData;
    private var overlay:Shape;
    private static var scale:Number = 1.6;
    private var color1:uint;
    private var color2:uint;

    public function Wavelet(r:Rectangle) {
        rect = r;
    }

    public function color(c1:uint, c2:uint):void {
        color1 = c1;
        color2 = c2;
        draw();
    }
    private function draw():void {
        wavelet = new BitmapData(rect.width, rect.height, false);
        noise = new BitmapData(rect.width/scale, rect.height/scale, false);
        noise.noise(1, 0, 255, 7, true);
        var blur:BlurFilter = new BlurFilter(20, 0, 3);
        noise.applyFilter(noise, noise.rect, new Point(), blur);
        var matrix:Matrix = new Matrix();
        matrix.scale(scale, scale);
        var colorMatrixFilter:ColorMatrixFilter = new ColorMatrixFilter();
        //var colorMatrix:ColorMatrix = new ColorMatrix();
        //colorMatrix.adjustContrast(0.6);
        //colorMatrixFilter.matrix = colorMatrix.matrix;
        colorMatrixFilter.matrix = adjustContrast(0.6);
        noise.applyFilter(noise, noise.rect, new Point(), colorMatrixFilter);
        wavelet.draw(noise, matrix, null, BlendMode.DIFFERENCE);
        drawOverlay();
        addChild(new Bitmap(wavelet));
    }
    private function adjustContrast(s:Number):Array {
        var r:Number;
        var g:Number;
        var b:Number;
        r = g = b = s + 1;
        return [r, 0, 0, 0, (128 * (1 - r)), 0, g, 0, 0, (128 * (1 - g)), 0, 0, b, 0, (128 * (1 - b)), 0, 0, 0, 1, 0];
    }
    private function drawOverlay():void {
        overlay = new Shape();
        var colors:Array = [color1, color2]
        var alphas:Array = [1, 1];
        var ratios:Array = [0, 255];
        var matrix:Matrix = new Matrix();
        matrix.createGradientBox(rect.width, rect.height, 0.5*Math.PI, 0, 0);
        overlay.graphics.beginGradientFill(GradientType.LINEAR, colors, alphas, ratios, matrix, SpreadMethod.REFLECT, InterpolationMethod.RGB, 0);
        overlay.graphics.drawRect(0, 0, rect.width, rect.height);
        overlay.graphics.endFill();
        wavelet.draw(overlay, null, null, BlendMode.HARDLIGHT);
        wavelet.draw(overlay, null, null, BlendMode.OVERLAY);
    }

}
