/**
 * Copyright kotobuki ( http://wonderfl.net/user/kotobuki )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/plgR
 */

// forked from kotobuki's Gainer Basic Example: LED
// 準備
// ・aout 0：赤色LEDと抵抗器（330Ωなど）を接続する
// ・aout 1：緑色LEDと抵抗器（150Ωなど）を接続する
// ・aout 2：青色LEDと抵抗器（150Ωなど）を接続する
// 
// 操作
// ・画面上のボタンを押すとRGB LEDが赤色になります
// ・画面上のボタンを離すとRGB LEDが緑色になります
// 
// 基本的なセットアップについては以下のURLを参照してください
// http://funnel.cc/Main/GettingStarted

package {
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    
    import funnel.*;
    import funnel.gui.*;
    import funnel.ui.*;

    public class GainerBasic_LED extends Sprite {

        private var gio:Gainer;
        private var rgbLED:RGBLED;
        private var squareButton:Sprite;

        public function GainerBasic_LED() {
            gio = new Gainer();

            squareButton = new Sprite();
            squareButton.graphics.beginFill(0x808080);
            squareButton.graphics.drawRect(-25, -25, 50, 50);
            squareButton.graphics.endFill();
            squareButton.x = stage.stageWidth / 2;
            squareButton.y = stage.stageHeight / 2;
            squareButton.buttonMode = true;
            this.addChild(squareButton);

            var gui:GainerGUI = new GainerGUI();
            addChild(gui);
            gio.gui = gui;

            rgbLED = new RGBLED(gio.analogOutput(0), gio.analogOutput(1), gio.analogOutput(2), RGBLED.ANODE_COMMON);

            squareButton.addEventListener(MouseEvent.MOUSE_DOWN, mousePressed);
            squareButton.addEventListener(MouseEvent.MOUSE_UP, mouseReleased);

            rgbLED.fadeTo(0, 0, 0, 100);
        }

        private function mousePressed(e:MouseEvent):void {
            rgbLED.fadeTo(1, 0, 0, 100);
            squareButton.scaleX = 1.2;
            squareButton.scaleY = 1.2;
        }

        private function mouseReleased(e:MouseEvent):void {
            rgbLED.fadeTo(0, 1, 0, 100);
            squareButton.scaleX = 1.0;
            squareButton.scaleY = 1.0;
        }
    }
}
