/**
 * Copyright 7kamura ( http://wonderfl.net/user/7kamura )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pk90
 */

	// forked from 7kamura's 感化されて自分もひだまりの星つくってみる
/**
 * Copyright 7kamura ( http://wonderfl.net/user/7kamura )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/iOzz
 */

package {
	import flash.display.Sprite;
	
	[SWF(width=465, height=465, backgroundColor=0xFFFFFF, frameRate=30)]
	public class HoshiMittsu extends Sprite {
		public function HoshiMittsu() {
			var ht:HidamariTornado = new HidamariTornado();
			addChild(ht);
		}
	}
}

import flash.display.GradientType;
import flash.display.Graphics;
import flash.display.Sprite;
import flash.filters.*;
import flash.geom.Matrix;
class HidamariStar extends Sprite {
	private var _radius:Number;
	private var _cx:Number;
	private var _cy:Number;
	private var _insideRatio:Number;
	private var firstStar:Sprite;
	private var secondStar:Sprite;
	private var thirdStar:Sprite;
	private var forthStar:Sprite;
	private var secondStarFilter:BevelFilter;
	private var forthStarFilter:BevelFilter;
	private var g:Graphics;
	public function HidamariStar(radius:Number, cx:Number = 0, cy:Number = 0, insideRatio:Number = 0.5):void {
		_radius = radius;
		_cx = cx;
		_cy = cy;
		_insideRatio = insideRatio;
		
		addChild(firstStar = new Sprite());
		addChild(secondStar = new Sprite());
		addChild(thirdStar = new Sprite());
		addChild(forthStar = new Sprite());
		
		secondStarFilter = new BevelFilter(2, -45, 0x996666, 1, 0x000000, .3, 2, 2, 1, 2, BitmapFilterType.OUTER, false);
		forthStarFilter  = new BevelFilter(5, -120, 0x996666, 0, 0x000000, .5, 2, 2, 1, 2, BitmapFilterType.OUTER, false);
		
		secondStar.filters = [secondStarFilter];
		forthStar.filters = [forthStarFilter];
		
		draw();
	}
	
	private function draw():void {
		var matrix:Matrix = new Matrix();
		
		
		// 白い縁取りの星
		/*
		g = firstStar.graphics
		g.clear();
		g.beginFill(0xFFFFFF);
		g.lineStyle(10, 0xFFFFFF);
		drawStar(g, _radius);
		g.endFill();
		*/
		
		// 1番外側のグラデーション付きの星	
		g = secondStar.graphics
		g.clear();
		matrix.createGradientBox(_radius * 2, _radius * 2, -Math.PI / 4);
		g.lineStyle(10);
		g.lineGradientStyle(GradientType.LINEAR, [0xF4A890, 0x2C0901], [1, 1], [0, 255], matrix);
		g.beginGradientFill(GradientType.LINEAR, [0xF4A890, 0x2C0901], [1, 1], [0, 255], matrix);
		drawStar(g, _radius * 0.95);
		g.endFill();
		
		// 2番目のベタ塗りの赤茶色の星
		g = thirdStar.graphics
		g.clear();
		g.lineStyle(5, 0x981B01);
		g.beginFill(0x981B01);
		drawStar(g, _radius * 0.86);
		g.endFill();
		
		g = forthStar.graphics
		g.clear();
		matrix.createGradientBox(_radius * 2, _radius * 2, -Math.PI / 4);
		g.lineStyle(5);
		g.lineGradientStyle(GradientType.LINEAR, [0xfdf9fa, 0xfdae10], [1, 1], [0, 255], matrix);
		g.beginGradientFill(GradientType.LINEAR, [0xfdf9fa, 0xfdae10], [1, 1], [0, 255], matrix);
		drawStar(g, _radius * 0.72);
		g.endFill();
	}
	
	private function drawStar(g:Graphics, radius:Number):void {
		g.moveTo(_cx, _cy - radius);
		
		var diffAngle:Number =  Math.PI * 2 / 10;
		var angle:Number = - Math.PI / 2;
		var tmpRadius:Number = radius;
		
		for(var i:Number = 1; i<=10; i++) {
			angle += diffAngle;
			tmpRadius = (i%2) ? radius * _insideRatio : radius ;
			
			g.lineTo(Math.cos(angle) * tmpRadius + _cx, Math.sin(angle) * tmpRadius + _cy);
		}
	}
}

class HidamariStarEx extends HidamariStar {
	public var vx:Number;
	public var vy:Number;
	
	public function HidamariStarEx(radius:Number, cx:Number = 0, cy:Number = 0, insideRatio:Number = 0.5, vx:Number = 0, vy:Number = 0):void {
		this.vx = vx;
		this.vy = vy;
		super(radius, cx, cy, insideRatio);
	}
}

import flash.utils.Timer;
import flash.events.*;
import flash.display.Sprite;
import flash.display.Bitmap;

class HidamariTornado extends Sprite {
	private var timer:Timer;
	private var angle:Number = 0;
	private var diff:Number = 1;
	private var bmp:Bitmap;
	private static const STAR_NUM:Number = 700;
	private static const GRAVITY:Number = 0.02;
	public function HidamariTornado():void {
		
		this.addEventListener(Event.ENTER_FRAME, enterFrameHandler);
	}
	
	private function enterFrameHandler(e:Event):void {
		if(angle % 6 == 0) {
			var star:HidamariStarEx = new HidamariStarEx(Math.random() * 40 + 10);
			addChild(star);
			star.x = 465/2;
			star.y = 465;
			star.vx = Math.cos(angle) * 3;
			star.vy = -Math.abs(Math.sin(angle)) * 3;
		}

		if(Math.abs(angle) == 180) {
			diff *= -1;
		}

		angle += diff;
		
		
		var child_num:Number = this.numChildren;
		while(child_num--) {
			var s:HidamariStarEx = this.getChildAt(child_num) as HidamariStarEx;
			s.vy += GRAVITY;
			s.x += s.vx;
			s.y += s.vy;
			s.rotation += 1;
			if(s.x - s.width/2 > 465 || s.y - s.height > 500 || s.x + s.width/2 < -20 || s.y + s.height/2 < -20) {
				this.removeChild(s);
			}
		}
	}
}