/**
 * Copyright octech ( http://wonderfl.net/user/octech )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pjZh
 */

// forked from uwi's uint vs int
// muta244のツールキットを借り
package {

import flash.display.*;
import flash.geom.*;
import flash.events.*;
import flash.text.*;
import flash.utils.*;

public class Main extends Sprite
{
    private const _NUM_TIMES:int = 10000000;
    private const _NUM_TIMES_U:uint = 10000000;
    
    private function _init():void
    {
        _debug(
            "各テスト " + _NUM_TIMES + " 回処理させた計算結果 [単位 ： ミリ秒]\n" +
            "(誤差は多少生じます)\n"
        );
        
        
        _measure("--i, int", function ():void
        {
            for (var i:int = _NUM_TIMES - 1; i >= 0; --i) {
            }
        });
        
        _measure("i--, int", function ():void
        {
            for (var i:int = _NUM_TIMES - 1; i >= 0; i--) {
            }
        });
        
        _measure("--i, uint", function ():void
        {
            for (var i:uint = _NUM_TIMES_U - 1; i > 0; --i) {
            }
        });
        
        _measure("i--, uint", function ():void
        {
            for (var i:uint = _NUM_TIMES_U - 1; i > 0; i--) {
            }
        });
        
        _measure("++i, int", function ():void
        {
            for (var i:int = 0; i < _NUM_TIMES; ++i) {
            }
        });
        
        _measure("i++, int", function ():void
        {
            for (var i:int = 0; i < _NUM_TIMES; i++) {
            }
        });
        
        _measure("++i, uint", function ():void
        {
            for (var i:uint = 0; i < _NUM_TIMES_U; ++i) {
            }
        });
        
        _measure("i++, uint", function ():void
        {
            for (var i:uint = 0; i < _NUM_TIMES_U; i++) {
            }
        });
        
        _debug("\n--- octech追記 ---");
        _debug("元々のソースではintのiがuintの定数と比較されているのが問題。");
        _debug("同じ型の変数との比較に変更したらuintとintの差は無くなりました。");
        _debug("当たり前の結論だが、元コードは迷信を作ってしまっているよね。");
        _debug("あと、++の方が--より遅いわけではなく、比較対象が0か変数かの違いが大きいはず.");
        _debug("個人的には前置演算子と後置演算子で違いがほとんど無いことが分かったことが収穫.");
    }
    
    private var _field:TextField;
    private var _time:uint;
    
    public function Main():void
    {
        _setup();
        _init();
    }
    
    private function _measure(title:String, func:Function, ...params):void
    {
        _time = getTimer();
        func.apply(null, params);
        _time = getTimer() - _time;
        
        _debug("[ " + title + " ] --> " + _time + " ms");
    }
    
    private function _debug(log:String):void
    {
        _field.appendText(log + "\n");
    }
    
    private function _setup():void
    {
        _field = new TextField();
        _field.width = stage.stageWidth - 40;
        _field.height = stage.stageHeight - 60;
        _field.x = 20;
        _field.y = 60;
        _field.multiline = true;
        _field.wordWrap = true;
        
        var format:TextFormat = _field.defaultTextFormat;
        format.font = "_sans";
        _field.defaultTextFormat = format;
        
        addChild(_field);
        
        var button:Sprite = new Sprite();
        button.graphics.lineStyle(1, 0xBBBBBB);
        button.graphics.beginFill(0xEEEEEE);
        button.graphics.drawRoundRect(0, 0, 100, 20, 5, 5);
        button.graphics.endFill();
        
        addChild(button);
        
        button.x = 20;
        button.y = 20;
        button.mouseChildren = false;
        button.buttonMode = true;
        
        var field:TextField = new TextField();
        field.width = 100;
        field.height = 20;
        field.htmlText = "<p align='center'><font face='_sans'>再計算</span></p>";
        
        button.addChild(field);
        
        button.addEventListener(MouseEvent.CLICK, function ():void
        {
            _field.text = "";
            _init();
        });
    }
}

}
