/**
 * Copyright ohisama ( http://wonderfl.net/user/ohisama )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pjD7
 */

// forked from ohisama's forked from: flash on 2013-1-24
// forked from ohisama's flash on 2013-1-24
// Flash IDNA sankou
// てっく煮ブログ sankou
package
{
    import flash.display.Sprite;
    import flash.text.*;
    import flash.net.*;
    import flash.events.*;
    import flash.system.*;
    import com.bit101.components.CheckBox;
    import flash.utils.describeType;
    public class Main extends Sprite
    {
        Security.loadPolicyFile("http://wakuworks.appspot.com/crossdomain.xml");
        public static const DEFAULT_URL : String = "http://linkdata.org/api/1/rdf1s47i/%E9%83%BD%E9%81%93%E5%BA%9C%E7%9C%8C%E5%88%A5%E5%BE%93%E6%A5%AD%E8%80%85%E6%95%B0%EF%BC%88%E5%BE%93%E6%A5%AD%E8%80%85%E6%95%B010%E5%90%8D%E4%BB%A5%E4%B8%8A%EF%BC%89%E7%B7%AF%E5%BA%A6%E7%B5%8C%E5%BA%A6%E4%BB%98%E3%81%8D_rdf.xml";
        //public static const DEFAULT_URL : String = "http://search.twitter.com/search.atom?q=usb";
        public static const PADDING : uint = 10;
        public static const DIF : uint = 4;
        public static const PROXY_URL : String = "http://wakuworks.appspot.com/proxy/";
        private var _url_txt : TextField;
        private var _url_label_txt : TextField;
        private var _result_txt : TextField;
        private var _result_label_txt : TextField;
        private var _btn : Button;
        private var _checkBox : CheckBox;
        private var _textWidth : Number;
        private var _loader : URLLoader;
        public function Main()
        {
            _textWidth = stage.stageWidth - PADDING * 2;
            _loader = new URLLoader();
            _loader.addEventListener(Event.COMPLETE, _completeHandler);
            _loader.addEventListener(IOErrorEvent.IO_ERROR, _ioErrorHandler);
            _createURLText();
            _createConnectButton();
            _createCheckBox();
            _createResultText();
        }
        private function _createURLText() : void
        {
            _createURLLabel();
            var _txt : TextField = new TextField();
            _txt.text = DEFAULT_URL;
            _txt.type = TextFieldType.INPUT;
            _txt.border = true;
            _txt.borderColor = 0xCCCCCC;
            _txt.x = PADDING;
            _txt.y = PADDING + _url_label_txt.textHeight + DIF;
            _txt.width = _textWidth;
            _txt.height = _txt.textHeight + DIF;
            addChild(_txt);
            _url_txt = _txt;
        }
        private function _createURLLabel() : void
        {
            var _txt : TextField = new TextField();
            _txt.autoSize = TextFieldAutoSize.LEFT;
            _txt.selectable = false;
            _txt.text = "URL:";
            _txt.x = PADDING;
            _txt.y = PADDING;
            _txt.width = _textWidth;
            addChild(_txt);
            _url_label_txt = _txt;
        }
        private function _createCheckBox() : void
        {
            _checkBox = new CheckBox(this);
            _checkBox.label = "print_r";
            _checkBox.selected = true;
            _checkBox.x = _btn.x - 50;
            _checkBox.y = _btn.y + (_btn.height - _checkBox.height) / 2;
        }
        private function _createConnectButton() : void
        {
            _btn = addChild(new Button(80, 20, 3, "接続テスト", 12)) as Button;
            _btn.x = stage.stageWidth - _btn.width - PADDING + 1;
            _btn.y = _url_txt.y + _url_txt.height + DIF;
            _btn.addEventListener(MouseEvent.CLICK, _clickHandler);
        }
        private function _createResultText() : void
        {
            _createResultLabel();
            var _txt : TextField = new TextField();
            _txt.border = true;
            _txt.borderColor = 0xCCCCCC;
            _txt.x = PADDING;
            _txt.y = _result_label_txt.height + _result_label_txt.y + DIF;
            _txt.width = _textWidth;
            _txt.height = stage.stageHeight - _txt.y - PADDING;
            addChild(_txt);
            _result_txt = _txt;
        }
        private function _createResultLabel() : void
        {
            var _txt : TextField = new TextField();
            _txt.selectable = false;
            _txt.autoSize = TextFieldAutoSize.LEFT;
            _txt.text = "結果:（接続結果が下のテキストボックスに表示されます）";
            _txt.x = PADDING;
            _txt.y = _btn.height + _btn.y + DIF;
            _txt.width = _textWidth;
            _txt.height = _txt.textHeight + DIF;
            addChild(_txt);
            _result_label_txt = _txt;
        }
        private function _clickHandler(e : MouseEvent) : void
        {
            try
            {
                var _url : String = _url_txt.text;
                _loader.load(new URLRequest(PROXY_URL + _url));
            }
            catch (e : Error)
            {
                _result_txt.text = e.message;
            }
        }
        private function _completeHandler(e : Event) : void
        {
            var atom : XML = new XML(e.target.data);
            _result_txt.text = _checkBox.selected ? e.target.data　: print_r(atom, "");
            //_result_txt.text = e.target.data;
        }
        private function _ioErrorHandler(e : IOErrorEvent) : void
        {
            _result_txt.text = e.text;
        }
        public static function print_r(o : *, name : String = "", recur : int = 0) : String 
        {
            var result : String = "";
            var type : String = typeof(o);
            var desc : XML = describeType(o);
            if (recur == 0)
            {
                result += "---\n";
            }
            else
            {
                for (var i : int = 0; i < recur; ++i)
                {
                    result += "  ";
                }
            }
            if (name)
            {
                result += '[' + name + ']';
            }
            result += ':' + desc.@name + ' => ';
            switch (type)
            {
            case "boolean" :
            case "number" :
            case "string" :
                result += String(o);
            break;
            case "xml":
                result += o.toXMLString();
            break;
            case "object" :
                if (desc.@name == "Object" || desc.@name == "Array")
                {
                    for (var key : String in o)
                    {
                        result += "\n";
                        result += print_r(o[key], key, (recur + 1));
                    }
                }
                else
                {
                    var prop : XML;
                    for each(prop in desc.variable)
                    {
                        result += "\n";
                        result += print_r(o[prop.@name], prop.@name, (recur + 1));
                    }
                    for each(prop in desc.method)
                    {
                        result += "\n";
                        result += print_r(o[prop.@name], prop.@name, (recur + 1));
                    }
                }
            break;
            case "function":
                result += String(o);
            break;
            }
            if (recur == 0)
            {
                result += "\n---";
            }
            return result;
        }
    }
}

import flash.display.Sprite;
import flash.events.Event;
import flash.text.TextField;
import flash.geom.Matrix;
import flash.filters.ColorMatrixFilter;
import flash.filters.GlowFilter;
class Button extends Sprite
{
    private static const mono:ColorMatrixFilter = new ColorMatrixFilter([
        1 / 3, 1 / 3, 1 / 3, 0, 10,
        1 / 3, 1 / 3, 1 / 3, 0, 10,
        1 / 3, 1 / 3, 1 / 3, 0, 10,
            0,     0,     0, 1, 0
    ]);
    private var _hover : Boolean = false;
    public function get hover() : Boolean
    {
        return _hover;
    }
    public function set hover(value : Boolean) : void
    {
        if (_hover != value)
        {
            _hover = value;
            filters = (_hover ? null : [mono]);
        }
    }
    public function Button(W : Number, H : Number, R : Number, label : String = "", size : int = 11)
    {
        var matrix : Matrix = new Matrix();
        matrix.createGradientBox(W, H, Math.PI / 2);
        var bg : Sprite = new Sprite();
        bg.graphics.beginGradientFill("linear", [0xDDE9F4, 0xD5E4F1, 0xBAD2E8], [1, 1, 1], [0, 120, 136], matrix);
        bg.graphics.drawRoundRect(0, 0, W, H, R, R);
        bg.graphics.endFill();
        bg.filters = [new GlowFilter(0xFFFFBE, .5, 10, 10, 2, 1, true)];
        addChild(bg);
        var line : Sprite = new Sprite();
        line.graphics.lineStyle(1, 0xBAD2E8);
        line.graphics.drawRoundRect(0, 0, W, H, R, R);
        addChild(line);
        filters = [mono];
        buttonMode = true;
        mouseChildren = false;
        if (label != "")
        {
            var textField : TextField = new TextField();
            textField.selectable = false;
            textField.autoSize = "left";
            textField.htmlText = <font size={size} color="#6B8399">{label}</font>.toXMLString();
            textField.x = (W - textField.width) / 2;
            textField.y = (H - textField.height) / 2;
            addChild(textField);
        }
        addEventListener("rollOver", buttonRollOver);
        addEventListener("rollOut", buttonRollOut);
        addEventListener("removed", function(event : Event) : void
        {
            removeEventListener("rollOver", buttonRollOver);
            removeEventListener("rollOut", buttonRollOut);
            removeEventListener("removed", arguments.callee);
        });
    }
    protected function buttonRollOver(event : Event) : void
    {
        hover = true;
    }
    protected function buttonRollOut(event : Event) : void
    {
        hover = false;
    }
}
