/**
 * Copyright hacker_qus3vzf3 ( http://wonderfl.net/user/hacker_qus3vzf3 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pj8y
 */

// forked from peso's 物体を追いかける
package {
    import flash.events.*;
    import flash.text.*;
    import flash.utils.*;
    
    import org.papervision3d.cameras.*;
    import org.papervision3d.core.geom.*;
    import org.papervision3d.core.math.*;
    import org.papervision3d.lights.*;
    import org.papervision3d.materials.shadematerials.*;
    import org.papervision3d.materials.special.*;
    import org.papervision3d.materials.utils.*;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.view.*;
    [SWF(width=640,height=395)]
    public class week3_example4 extends BasicView {
        private var eye:Sphere;
        private var cnt:Number = 0;
        private var text_field = new TextField(); // テキストフィールドの作成
        
        public function week3_example4():void {
            // 背景を白にする。
            graphics.beginFill(0xFFFFFF);
            graphics.drawRect(0,0,stage.stageWidth, stage.stageHeight);
            graphics.endFill();
            
            // カメラタイプをスプリングカメラとして指定
            super(0, 0, true, false, CameraType.SPRING);
            
            // マテリアルを作成
            var material:FlatShadeMaterial = new FlatShadeMaterial(new PointLight3D());
            
            // 3Dオブジェクトを100個配置
            for (var i:int = 0; i < 50; i++) {
                // 直方体を作成
                var cube:Cube = new Cube(new MaterialsList({all:material}), 75, 75, 75, 1, 1, 1);
                scene.addChild(cube);
                
                // 計算式で求めたXZ座標に配置
                var rot:Number = 360 * (i/50);
                cube.x = 1000 * Math.sin(rot*Math.PI/180);
                cube.z = 1000 * Math.cos(rot*Math.PI/180);
                
            }
            
            // 上を走らせるオブジェクトを作成
            eye = new Sphere(material, 50, 4, 2);
            scene.addChild(eye);
            
            // eyeを追随するように設定
            camera.target = eye;
            
            // スプリングカメラの設定
            SpringCamera3D(camera).mass = 30;    // 動きの勢い
            SpringCamera3D(camera).damping = 30;    // 摩擦
            SpringCamera3D(camera).stiffness = 1;    // 動きの固さ
            SpringCamera3D(camera).positionOffset = new Number3D(0, 100, 0); // カメラの位置を指定
            SpringCamera3D(camera).lookOffset = new Number3D(0, 100, 0); // カメラの目標点を指定
            
            // テキストフィールドの設定
            stage.addChild(text_field);
            text_field.border = true;    // 枠を表示する
            text_field.x = 50;        // x 座標
            text_field.y = 100;        // y 座標
            text_field.width  = 200;    // 幅
            text_field.height = 20;    // 高さ
            
            addEventListener(Event.ENTER_FRAME, loop);
            startRendering();
        }
        
        private function loop(e:Event):void{
            cnt += 0.2;
            
            var angle:Number = 360 * (cnt/50);
            eye.x = 1000 * Math.sin(angle*Math.PI/180);
            eye.z = 1000 * Math.cos(angle*Math.PI/180);
            eye.y = 100;
            
            // 距離を測定し、タイムラインに配置したダイナミックテキストに表示
            text_field.text = String(camera.distanceTo(eye));
        }
    }
}
