/**
 * Copyright greentec ( http://wonderfl.net/user/greentec )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pj6j
 */

package 
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    
    /**
     * ...
     * @author ypc
     */
    [SWF(width = "465", height = "465", backgroundColor = "#ffffff")]
    public class Main extends Sprite 
    {
        
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            
            stage.scaleMode = "noScale";
            
            var i:int;
            var j:int;
            var rowNum:int = 28;
            var colNum:int = 50;
            var triCell:TriCell;
            var edgeLength:int = 20;
            var cellWidth:Number = edgeLength;
            var cellHeight:Number = cellWidth * Math.sqrt(3) / 2;
            var indentX:Number = -cellWidth / 2;
            var indentY:Number = -cellHeight / 2;
            var colorArray:Array = [0x00a9e5, 0x1778e7, 0x2e53ea, 0x5447ec, 0x925fef, 0xc579f2, 0xeb92f4, 0xf7adea, 0xf9c7e3, 0xfce3ea, 0xffffff];
            
            for (i = 0; i < rowNum; i += 1)
            {
                for (j = 0; j < colNum; j += 1)
                {
                    triCell = new TriCell(j, i, true, edgeLength, colorArray[int(Math.random() * colorArray.length)]);
                    triCell.y = i * cellHeight + indentY;
                    if (i % 2 == 1)
                    {
                        triCell.x = int(j / 2) * cellWidth - cellWidth / 2 + indentX;
                        if (j % 2 == 1)
                        {
                            triCell.x += cellWidth;
                        }
                    }
                    else
                    {
                        triCell.x = int(j / 2) * cellWidth + indentX;
                    }
                    //triCell.addEventListener(MouseEvent.CLICK, onMouseClick);
                    addChild(triCell);
                }
            }
            
            
            
        }
        
        //private function onMouseClick(e:MouseEvent):void
        //{
            //var triCell:TriCell = e.target.parent as TriCell;
            //trace(triCell._x, triCell._y);
        //}
        
    }
    
}

Class
{
    import flash.display.Sprite;
    /**
     * ...
     * @author ypc
     */
    class TriCell extends Sprite
    {

        public var _x:int;
        public var _y:int;
        public var edgeLength:int;
        public var _G:Sprite;
        
        public function TriCell(_x:int, _y:int, _draw:Boolean = true, edge:int = 20, color:uint = 0x000000) 
        {
            this._x = _x;
            this._y = _y;
            this.edgeLength = edge;
            
            _G = new Sprite();
            addChild(_G);
            
            if (_draw)
            {
                drawCell(color);
            }
        }
        
        public function drawCell(color:uint = 0x000000):void
        {
            _G.graphics.clear();
            _G.graphics.lineStyle(1, color);
            _G.graphics.beginFill(color);
            var h:Number = edgeLength * Math.sqrt(3) / 2;
            
            if ((_x + _y) % 2 == 0) //normal triangle
            {
                with (_G.graphics)
                {
                    moveTo(0, 0);
                    lineTo( -edgeLength / 2, h);
                    lineTo( edgeLength / 2, h);
                    lineTo(0, 0);
                    endFill();
                }
            }
            else //inverted triangle
            {
                with (_G.graphics)
                {
                    moveTo(0, 0);
                    lineTo(edgeLength / 2, h);
                    lineTo(edgeLength, 0);
                    lineTo(0, 0);
                    endFill();
                }
            }
            
        }
    }
}