/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/phwG
 */





package 
{
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    import flash.filters.BlurFilter;
    import flash.filters.GlowFilter;
    import net.hires.debug.Stats;    

    [SWF(width=465, height=465, backgroundColor=0x000000, frameRate=45)]

    
    public class RainbowStarPainter extends Sprite 
    { 
        private const GLOW_FILTER :GlowFilter = new GlowFilter( 0xFFFFFF*Math.random(),1,6,6,2,2,false,true );
        private const BLUR_FILTER :BlurFilter = new BlurFilter( 16,16,1 ); //16,16,2 );
        private const BLUR_FILTER2:BlurFilter = new BlurFilter( 16,16,1 ); //20,20,2 );
        private const ZERO_POINT:Point = new Point(0, 0);
        //private const DIM_COLOR:ColorTransform = new ColorTransform(1.0, 1.0, 1.0, 0.2);     
        //private const rainbow:Gradation = new Gradation( 0xFF0000,0x00FF00,0x0000FF ); // 0xff0000, 0xffff00, 0x00ff00, 0x00ffff, 0x0000ff, 0xff00ff, 0xff0000);
        private const DIM_COLOR:ColorTransform = new ColorTransform(0.2, 0.2, 0.2, 0.2);    
        private const rainbow:Gradation = new Gradation(0xff0000, 0xffff00, 0x00ff00, 0x00ffff, 0x0000ff, 0xff00ff, 0xff0000);
        private var _stats:Stats = new Stats();
        private var color:Number;
        private var trend:Number;
        private var yCount:int;        
        private var canvasCache:Bitmap; 
        private var canvasBrush:Rectangle;
        private var canvas:Bitmap;
        private var tmpCache:Sprite;
        private var myMask:Sprite;
        private var stars:Array;
        
        public function RainbowStarPainter() 
        {
            stage.addChild( _stats );
            stage.quality = StageQuality.MEDIUM;
            stars = new Array;
            color = Math.random();
            trend = Math.random()*0.005;
            yCount = 0;
            
            canvas = addChild(new Bitmap(new BitmapData(465, 465, true))) as Bitmap;
            tmpCache = new Sprite;
            canvasCache = tmpCache.addChild(new Bitmap(new BitmapData(465, 465, false))) as Bitmap;
            myMask = tmpCache.addChild(new Sprite) as Sprite;
            canvasCache.mask = myMask;
            canvasBrush = new Rectangle(0, 0, 60, 60);
            canvasCache.bitmapData.fillRect(canvas.bitmapData.rect, rainbow.getColor(color));
            addEventListener(Event.ENTER_FRAME, _updateScreen);
        }
        
        private function _updateScreen(e:Event):void 
        {
            var y:int;
            color += trend;
            trend += (Math.random() * 0.001)-0.0005;
            trend  = Math.max(0.001, Math.min(0.005, trend));

            if (color > 1) {
                color = 0;
            }

            for (var x:int = 0; x < 465; x += 30) {
                y = yCount - x;
                if (yCount - x > 465) {
                    y = 930 - y;
                } else if (y < 0) {
                    y = -y;
                }
                canvasBrush.x = x;
                canvasBrush.y = y;
                canvasCache.bitmapData.fillRect(canvasBrush, rainbow.getColor(color));
            }
            yCount += 5;
            yCount %= 930;
            //canvasCache.bitmapData.applyFilter(canvasCache.bitmapData, canvasCache.bitmapData.rect, ZERO_POINT, GLOW_FILTER );
            canvasCache.bitmapData.applyFilter(canvasCache.bitmapData, canvasCache.bitmapData.rect, ZERO_POINT, BLUR_FILTER2);
            //this.filters = [ GLOW_FILTER ];
            //update stars
            var i:int = stars.length;
            if ( i<1 ) 
            {
                stars.push(myMask.addChild(new Star()));
            }
            
            while (i--) 
            {
                stars[i].x += stars[i].speedX;
                stars[i].y += stars[i].speedY;
                stars[i].rotation += stars[i].rotationSpeed * (-1*Math.random());
                if (stars[i].y < -100) 
                {
                    stars[i].resetStar();
                }
            }
            
            canvas.bitmapData.applyFilter(canvas.bitmapData, canvas.bitmapData.rect, ZERO_POINT, BLUR_FILTER);
            canvas.bitmapData.draw(canvas.bitmapData, null, DIM_COLOR, BlendMode.ADD);
            canvas.bitmapData.draw(tmpCache);
        }
    }
}

import flash.display.Sprite;
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.geom.Matrix;
import flash.geom.Rectangle;
class Star extends Sprite 
{
    public var speedX:Number;
    public var speedY:Number;
    public var rotationSpeed:Number;
    public function Star() 
    {
        this.blendMode = "difference";
        graphics.beginFill(0xFFFFFF);
        graphics.drawCircle( 20,20,40 );
        graphics.endFill();
        var tmpRect:Rectangle = getRect(this);
        x = -tmpRect.left;
        y = -tmpRect.top;
        resetStar();      
    }    
    public function resetStar():void 
    {
        //scaleX = scaleY = Math.random() * 0.125;
        speedX = 0; // ( Math.random() * 2) - 2; // Math.random()*2 - 1;
        speedY = 0; // (-Math.random() * 2) - 2; // (-Math.random() * 4)-2;
        rotationSpeed = Math.random()-5; // Math.random() * 14 - 7;
        rotationSpeed += rotationSpeed > 0?1: -1;
        y = 465/2; // 465;
        x = 465/2; // Math.random() * 465;
    }
}


import frocessing.color.ColorLerp;

import org.libspark.betweenas3.core.easing.IEasing;
import org.libspark.betweenas3.easing.Linear;

class Gradation {
    
    private var _colors:Array;
    private var _easing:IEasing;
    
    public function Gradation(...args) {
        _colors = args.concat();
        _easing = Linear.linear;
    }
    
    public function setEasing(easing:IEasing):void {
        _easing = easing;
    }
    
    public function getColor(position:Number):uint {
        position = (position < 0 ? 0 : position > 1 ? 1 : position) * (_colors.length - 1);
        var idx:int = position;
        var alpha:Number = _easing.calculate(position - idx, 0, 1, 1);
        if (alpha == 0) {
            return _colors[idx];
        } else {
            return ColorLerp.lerp(_colors[idx], _colors[idx + 1], alpha);
        }
    }
}