/**
 * Copyright mex_md ( http://wonderfl.net/user/mex_md )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ph1U
 */

/* 
 * AS100本ノック
 * 1本目のお題は「Hello World」
 * あなたなりの「Hello World」を表現してください。
 */
package 
{
    import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.TimerEvent;
	import flash.geom.Point;
	import flash.utils.Timer;
	
	import flash.utils.Dictionary;
	import caurina.transitions.Tweener;
    public class FlashTest2 extends Sprite
	{
		private const elementsArr:Array = ["H", "E", "L", "L", "O", "W", "O", "R", "L", "D"];
		private var lineSpeed:Array = [1, 2, 3, 4, 5, 1, 2, 3, 4, 5, 1, 2, 3, 4, 5, 1, 2, 3, 4, 5, 1, 2, 3, 4, 5]
		private var columSpeed:Array = [-5, -4, -3, -2, -1, 1, 2, 3, 4, 5, 5, 4, 3, 2, 1, -1, -2, -3, -4, -5, -5, -4, -3, -2, -1, 1, 2, 3, 4, 5]
		
		private const unit:int = 20;
        private var numElem:int;
		private var timer:Timer;
		private var map:Array = [];
		private var t:int = 0;
	
		public function FlashTest2()
		{
			numElem = elementsArr.length;
			
			createInitialLines();
			createButton();
			timer = new Timer(1000);
			timer.addEventListener(TimerEvent.TIMER, timerTick);
			timer.start();
        }
		
		private function createButton():void
		{
			
			//var btn
		}
		
		
		private function createInitialLines():void
		{
			
			for (var i:int = 0; i < 20; i++) 
			{
				var colArr:Array = [];
				for (var j:int = 0; j < 20 ; j++) 
				{
					var char:Charactor = new Charactor(elementsArr[i % numElem]);
					char.x = i * unit;
					char.y = j * unit;
					this.addChild(char);
					
					colArr.push(char);
				}
				map.push(colArr);
			}
		}
		
		private function timerTick(e:TimerEvent):void 
		{
			if (t % 2) moveColom();
			else moveLine();
			t++;
			searchHelloWorld();
		}
		
		private function searchHelloWorld():void
		{
			columScan();
			lineScan()	
		}
		
		private function lineScan():void
		{
			//line
			for (var j:int = 0; j < 20; j++) 
			{
				var linStr:String = "";
				for(var i:int = 0; i < 20; i++)
				{
					linStr += map[i][j].str;
				}
				var index:int = linStr.indexOf("HELLO");
				var index2:int = linStr.indexOf("WORLD");
				if (index != -1)
				{
					for (var n:int = index; n < index + 5; n++ )
					{
						map[n][j].glow();
					}
				}
				if (index2 != -1)
				{
					for (var m:int = index2; m < index2 + 5; m++ )
					{
						map[m][j].glow();
					}
				}
			}
		}
		
		private function columScan():void
		{
			for (var i:int = 0; i < 20; i++) 
			{
				var colmStr:String = "";
				for(var j:int = 0; j < 20; j++)
				{
					colmStr += map[i][j].str;
				}
				var index:int = colmStr.indexOf("HELLO");
				var index2:int = colmStr.indexOf("WORLD");
				if (index != -1)
				{
					for (var k:int = index; k < index + 5; k++ )
					{
						map[i][k].glow();
						//timer.stop();
					}
				}
				if (index2 != -1)
				{
					for (var m:int = index2; m < index2 + 5; m++ )
					{
						map[i][m].glow();
					}
				}
			}
		}
		
		private function moveColom():void
		{
			var newArr:Array = create20x20Array();
			for (var i:int = 0; i <20; i++) 
			{
				//var amount:int = (Math.random() * 5 >> 0);
				var amount:int = columSpeed[i];
				for (var j:int = 0; j < 20; j++) 
				{
					var target:Charactor = map[i][j];
					var dest:Number = target.y + unit * amount;
					/*if (dest > 400)
					{*/
						dest = (dest +400) % 400;
					/*}else if (dest < 0)
					{*/
						//dest = ()
					//}
					target.unglow();
					Tweener.addTween(target, { y:dest, time:0.8,transition:"easeOutSine" } );
					
					var jShift:int =  ((j + amount + 20) % 20);
					
					newArr[i][jShift] = target;
				}
			}
			map = newArr;
		}
		
		private function create20x20Array():Array
		{
			var arr:Array = [];
			for (var i:int = 0; i < 20; i++) 
			{
				arr.push(new Array(20));
			}
			return arr;
		}
		
		private function moveLine():void
		{
			var newArr:Array = create20x20Array();
			for (var j:int = 0; j <20; j++) 
			{
				//var amount:int = (Math.random() * 5 >> 0);
				var amount:int = lineSpeed[j];
				for (var i:int = 0; i < 20; i++) 
				{
					var target:Charactor = map[i][j];
					var dest:Number = target.x + unit * amount;
					/*if (dest > 400)
					{*/
						dest = (dest +400) % 400;
					//}
					target.unglow();
					Tweener.addTween(target, { x:dest, time:0.8,transition:"easeOutSine" } );
					
					var iShift:int =  ((i + amount + 20) % 20);
					
					newArr[iShift][j] = target;
				}
			}
			map = newArr;
		}
    }
}
import flash.text.TextField;
import flash.text.TextFormat;
import flash.display.Sprite;
class Charactor extends Sprite
{
	private var _textField:TextField;
	private var _str:String;
	public function Charactor(char:String):void
	{
		_str = char;
		textField = new TextField();
		var tf:TextFormat = new TextFormat();
		tf.font = "_等幅"
		tf.bold = true;
		tf.size = 20;
		tf.color = 0x000000;
		textField.text = char;
		textField.setTextFormat(tf);
		addChild(textField);
	}
	
	public function get textField():TextField { return _textField; }
	
	public function set textField(value:TextField):void 
	{
		_textField = value;
	}
	
	public function glow():void
	{
		var tfglow:TextFormat = new TextFormat();
		tfglow.color = 0xff00ff;
		textField.setTextFormat(tfglow);
	}
	
	public function unglow():void
	{
		var tfunglow:TextFormat = new TextFormat();
		tfunglow.color = 0x000000;
		textField.setTextFormat(tfunglow);
	}
	
	public function get str():String { return _str; }
	
	
}