/**
 * Copyright tkinjo ( http://wonderfl.net/user/tkinjo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pecd
 */

package  
{
	/**
	 * ターゲットの周りを飛ぶキューブ
	 * 
	 * 
	 * --- 参考 ---
	 * 
	 * sake - PV3Dその8 Pixels使ってみる
	 * http://wonderfl.kayac.com/code/834affa8c7b8c668f2de620b62fa61c217df2805
	 */
	
	import flash.events.Event;
	import org.papervision3d.core.geom.Lines3D;
	import org.papervision3d.materials.ColorMaterial;
	import org.papervision3d.materials.special.LineMaterial;
	import org.papervision3d.materials.utils.MaterialsList;
	import org.papervision3d.materials.WireframeMaterial;
	import org.papervision3d.objects.primitives.Cone;
	import org.papervision3d.objects.primitives.Cube;
	import org.papervision3d.view.BasicView;
	
	[SWF(width=465,height=465,frameRate=60,backgroundColor=0xffffff)]
	/**
	 * ...
	 * @author tkinjo
	 */
	public class Main extends BasicView
	{
		private const radius:Number = -500;
		private var cube:Cube;
		
		public function Main() 
		{
			var targetCube:Cube = new Cube( new MaterialsList( { all : new WireframeMaterial( 0 ) } ), 100, 100, 100 );
			scene.addChild( targetCube );
			
			var cubeMaterialParams:Array = [ 
					{ name:"front", color:0xff0000 }, 
					{ name:"back", color:0xffff00 }, 
					{ name:"right", color:0x00ff00 }, 
					{ name:"left", color:0x00ffff }, 
					{ name:"top", color:0x0000ff },
					{ name:"bottom", color:0xff00ff } 
				];
			var cubeMaterialsList:MaterialsList = new MaterialsList();
			for ( var i:uint = 0; i < 6; i++ ) {
				var colorMaterial:ColorMaterial = new ColorMaterial( cubeMaterialParams[ i ].color,0.5 );
				colorMaterial.doubleSided = true;
				cubeMaterialsList.addMaterial( colorMaterial, cubeMaterialParams[ i ].name );
			}
			cube = new Cube( cubeMaterialsList, 100, 100, 100 );
			scene.addChild( cube );
			
			startRendering();
			
			addEventListener( Event.ENTER_FRAME, enterFrameHandler );
		}
		
		
		/**
		 * 
		 * @param	event
		 */
		private function enterFrameHandler( event:Event ):void {
			
			var thetaXZ:Number=360 * ( ( mouseX + stage.stageWidth / 2 ) / stage.stageWidth ) * Math.PI / 180;
			var thetaYZ:Number=360 * ( ( mouseY + stage.stageHeight / 2 ) / stage.stageHeight ) * Math.PI / 180;
			cube.x = radius * Math.cos( thetaYZ ) * Math.sin( thetaXZ );
			cube.y = -radius * Math.sin( thetaYZ );
			cube.z = radius * Math.cos( thetaYZ ) * Math.cos( thetaXZ );
			cube.rotationX = thetaYZ * 180 / Math.PI;
			cube.rotationY = thetaXZ * 180 / Math.PI;
		}
	}
	
}