/**
 * Copyright hankuro ( http://wonderfl.net/user/hankuro )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pePK
 */

package
{  
	import caurina.transitions.Tweener;
	import flash.events.Event;
	import org.papervision3d.core.effects.view.ReflectionView;
	import org.papervision3d.core.geom.TriangleMesh3D;
	import org.papervision3d.core.geom.renderables.Triangle3D;
	import org.papervision3d.core.geom.renderables.Vertex3D;
	import org.papervision3d.core.math.NumberUV;
	import org.papervision3d.materials.ColorMaterial;
	import org.papervision3d.materials.special.Letter3DMaterial;
	import org.papervision3d.objects.DisplayObject3D;
	import org.papervision3d.objects.primitives.Plane;
	import org.papervision3d.view.BasicView;
	import org.papervision3d.typography.Text3D;
	import org.papervision3d.typography.fonts.HelveticaBold;
	import org.papervision3d.typography.fonts.HelveticaRoman;

	[SWF(width = "500", height = "500", backgroundColor = "0" )] 
   
     /** 
      * 
      * @author modoki 
      */  
     public class Main extends BasicView	 
     {  
		 public var mesh_array:Array;
		 public var plane:Plane; 
		 private var uvA:NumberUV;
		 private var uvC:NumberUV;
		 private var uvB:NumberUV;
		 private var v0:Vertex3D;
		 private var v1:Vertex3D;
		 private var v2:Vertex3D;
		 private var meshface:Triangle3D;
		 private var text:Text3D;
		 public var set_sw:Boolean = false;
		 public var num:Number = 0;
		 public var obj3D:DisplayObject3D
		 public var cnt:Number = 50;
		 private var data:Array = [

		 [[-112,109,0],[-108,101,0],[-96,107,0]],
[[-96,107,0],[-108,101,0],[-99,90,0]],
[[-99,90,0],[-81,104,0],[-96,107,0]],
[[-81,104,0],[-99,90,0],[-90,80,0]],
[[-81,104,0],[-90,80,0],[-73,92,0]],
[[-71,84,0],[-73,92,0],[-90,80,0]],
[[-70,78,0],[-71,84,0],[-90,80,0]],
[[-90,80,0],[-85,76,0],[-70,78,0]],
[[-139,-2,0],[-128,-4,0],[-131,4,0]],
[[-128,-4,0],[-122,-3,0],[-131,4,0]],
[[-122,-3,0],[-101,10,0],[-131,4,0]],
[[-131,4,0],[-101,10,0],[-88,32,0]],
[[-101,10,0],[-66,18,0],[-88,32,0]],
[[-101,10,0],[-78,0,0],[-66,18,0]],
[[-78,0,0],[-101,10,0],[-96,5,0]],
[[-96,5,0],[-100,-15,0],[-78,0,0]],
[[-78,0,0],[-100,-15,0],[-94,-28,0]],
[[-100,-15,0],[-104,-30,0],[-94,-28,0]],
[[-94,-28,0],[-104,-30,0],[-96,-44,0]],
[[-96,-44,0],[-81,-34,0],[-94,-28,0]],
[[-96,-44,0],[-74,-44,0],[-81,-34,0]],
[[-96,-44,0],[-92,-49,0],[-74,-44,0]],
[[-92,-49,0],[-76,-59,0],[-74,-44,0]],
[[-76,-59,0],[-92,-49,0],[-92,-56,0]],
[[-92,-56,0],[-89,-88,0],[-76,-59,0]],
[[-89,-88,0],[-92,-56,0],[-97,-86,0]],
[[-140,-99,0],[-127,-107,0],[-115,-103,0]],
[[-140,-99,0],[-115,-103,0],[-111,-89,0]],
[[-111,-89,0],[-115,-103,0],[-107,-101,0]],
[[-97,-86,0],[-111,-89,0],[-107,-101,0]],
[[-97,-86,0],[-107,-101,0],[-88,-96,0]],
[[-97,-86,0],[-88,-96,0],[-75,-95,0]],
[[-97,-86,0],[-75,-95,0],[-76,-85,0]],
[[-75,-95,0],[-61,-97,0],[-76,-85,0]],
[[-76,-85,0],[-61,-97,0],[-59,-86,0]],
[[-61,-97,0],[-33,-91,0],[-59,-86,0]],
[[-33,-91,0],[-61,-97,0],[-13,-111,0]],
[[-33,-91,0],[-13,-111,0],[15,-101,0]],
[[-13,-111,0],[35,-125,0],[15,-101,0]],
[[15,-101,0],[35,-125,0],[92,-116,0]],
[[92,-116,0],[35,-125,0],[90,-147,0]],
[[92,-116,0],[90,-147,0],[159,-117,0]],
[[-27,126,0],[-22,116,0],[2,115,0]],
[[2,115,0],[-22,116,0],[-15,103,0]],
[[-15,103,0],[8,102,0],[2,115,0]],
[[-15,103,0],[7,94,0],[8,102,0]],
[[7,94,0],[-15,103,0],[-11,97,0]],
[[-11,97,0],[-6,91,0],[7,94,0]],
[[0,89,0],[7,94,0],[-6,91,0]],
[[56,145,0],[47,142,0],[49,137,0]],
[[49,137,0],[74,126,0],[56,145,0]],
[[49,137,0],[37,88,0],[74,126,0]],
[[49,137,0],[30,90,0],[37,88,0]],
[[-58,69,0],[-46,61,0],[20,86,0]],
[[20,86,0],[-46,61,0],[42,78,0]],
[[20,86,0],[42,78,0],[76,98,0]],
[[76,98,0],[42,78,0],[81,82,0]],
[[76,98,0],[81,82,0],[101,83,0]],
[[101,83,0],[85,102,0],[76,98,0]],
[[85,102,0],[101,83,0],[104,96,0]],
[[104,96,0],[101,83,0],[111,82,0]],
[[104,96,0],[111,82,0],[118,82,0]],
[[118,82,0],[120,87,0],[104,96,0]],
[[6,72,0],[12,68,0],[32,77,0]],
[[12,68,0],[33,63,0],[32,77,0]],
[[12,68,0],[5,38,0],[33,63,0]],
[[33,63,0],[5,38,0],[14,40,0]],
[[-15,37,0],[-27,39,0],[-22,26,0]],
[[-15,37,0],[-22,26,0],[-6,28,0]],
[[-15,37,0],[-6,28,0],[41,48,0]],
[[-6,28,0],[41,39,0],[41,48,0]],
[[41,39,0],[50,41,0],[41,48,0]],
[[61,54,0],[41,48,0],[50,41,0]],
[[61,54,0],[50,41,0],[56,37,0]],
[[61,54,0],[56,37,0],[82,38,0]],
[[56,37,0],[79,14,0],[82,38,0]],
[[56,37,0],[57,-24,0],[79,14,0]],
[[57,-24,0],[78,-21,0],[79,14,0]],
[[57,-24,0],[56,-46,0],[78,-21,0]],
[[78,-21,0],[56,-46,0],[76,-57,0]],
[[56,-46,0],[54,-57,0],[76,-57,0]],
[[54,-57,0],[74,-71,0],[76,-57,0]],
[[54,-57,0],[64,-85,0],[74,-71,0]],
[[54,-57,0],[53,-76,0],[64,-85,0]],
[[54,-57,0],[45,-52,0],[53,-76,0]],
[[53,-76,0],[45,-52,0],[37,-63,0]],
[[45,-52,0],[39,-49,0],[37,-63,0]],
[[39,-49,0],[15,-55,0],[37,-63,0]],
[[37,-63,0],[15,-55,0],[10,-66,0]],
[[15,-55,0],[-7,-61,0],[10,-66,0]],
[[-7,-61,0],[-5,-69,0],[10,-66,0]],
[[-7,-61,0],[-15,-73,0],[-5,-69,0]],
[[-7,-61,0],[-27,-52,0],[-15,-73,0]],
[[-7,-61,0],[-7,-20,0],[-27,-52,0]],
[[-27,-52,0],[-7,-20,0],[-23,-11,0]],
[[-7,-20,0],[-6,28,0],[-23,-11,0]],
[[-23,-11,0],[-6,28,0],[-22,26,0]],
[[-6,-2,0],[9,-3,0],[-6,3,0]],
[[9,-3,0],[21,14,0],[-6,3,0]],
[[21,14,0],[9,-3,0],[43,8,0]],
[[43,8,0],[27,15,0],[21,14,0]],
[[27,15,0],[43,8,0],[46,12,0]],
[[-7,-33,0],[10,-20,0],[-7,-27,0]],
[[-7,-33,0],[33,-27,0],[10,-20,0]],
[[10,-20,0],[33,-27,0],[22,-16,0]],
[[22,-16,0],[33,-27,0],[44,-23,0]],
[[22,-16,0],[44,-23,0],[46,-18,0]],
[[22,-16,0],[46,-18,0],[28,-13,0]],


		 
		 ]; 
		 
		 
         public function Main():void  
         {
			var color_init:Array = [0xFFFFFF, 0xFF0000, 0x00FF00, 0x0000FF, 0x00FFFF];
			
           	super(500, 500, false, false);
			camera.z = -400;
			obj3D = new DisplayObject3D();			
			scene.addChild(obj3D);
			plane = new Plane(new ColorMaterial(0xFF0000, 0), 200, 200, 24, 20);
			var letterformat:Letter3DMaterial = new Letter3DMaterial(0xFF0000 , 0.8);
			text = new Text3D("5" , new HelveticaBold() , letterformat);
			mesh_array = new Array(data.length);
			for (var i:Number = 0; i < data.length ; i++) {
				var c:ColorMaterial = new ColorMaterial(0xFFFFFF);
				c.doubleSided = true;
				mesh_array[i] = new TriangleMesh3D(c, new Array(), new Array(), null );
				v0 = new Vertex3D( 0, 0, 0 );
				v1 = new Vertex3D( 0, 0, 0 );
				v2 = new Vertex3D( 0, 0, 0 );
				mesh_array[i].geometry.vertices.push( v0 );
				mesh_array[i].geometry.vertices.push( v1 );
				mesh_array[i].geometry.vertices.push( v2 );
				uvA = new NumberUV( 0, 0 );
				uvC = new NumberUV( 1, 0 );
				uvB = new NumberUV( 0, 1 );

				mesh_array[i].geometry.faces.push( new Triangle3D( mesh_array[i], new Array(v0,v1,v2), null, new Array(uvA,uvC,uvB) ));
				mesh_array[i].geometry.ready = true;
				obj3D.addChild(mesh_array[i]);
			}
			startRendering();
			plane_make();
			addEventListener(Event.ENTER_FRAME, onLoop);
		}
		private function plane_make():void {
			for (var i:Number = 0; i < data.length; i++) {
				for (var n:Number = 0; n < 3; n++) {
					Tweener.addTween(mesh_array[i].geometry.vertices[n], { x: data[i][n][0],
																		   y: data[i][n][1],
																		   z: data[i][n][2],
																		   delay:i*.1,
																		   time:0.5,
																		   transition:"easeInOutCirc" } );
				}
			}
			Tweener.addTween(this,{delay:i*.1,onComplete:set_kanji});
		}
		private function set_kanji():void {
			set_sw = true;
		}
		private function onLoop(evt:Event):void {
			if (set_sw) {
				obj3D.rotationY += 1;
				
				for (var i:Number = 0 ; i < mesh_array.length; i++) {
					num += 10
					for (var n:Number = 0; n < 3; n++) {
						mesh_array[i].geometry.vertices[n].z = Math.cos((num + (Number(i) * 5)) * Math.PI / 180) * 200; ;
					}
				}
				cnt--;
			}
			if (cnt == 0) {
				cnt = 50 ;
				set_sw = false;
				for (i = 0; i < data.length; i++) {
					for (n = 0; n < 3; n++) {
						Tweener.addTween(mesh_array[i].geometry.vertices[n], { x: data[i][n][0],
																		   y: data[i][n][1],
																		   z: data[i][n][2],
																		   delay:i*.1,
																		   time:0.5,
																		   transition:"easeOutBounce" } );
					}
				}
				Tweener.addTween(this,{delay:i*.1,onComplete:set_kanji});
			}			
		}	
	 }

 }  