/**
 * Copyright seiya_i ( http://wonderfl.net/user/seiya_i )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/peID
 */

package {
    import frocessing.core.F5BitmapData2D;
    import frocessing.math.PerlinNoise;
    import frocessing.math.FMath;
    import flash.geom.ColorTransform;
    import flash.display.MovieClip;
    import flash.display.Bitmap;
    import flash.events.Event;
    import flash.events.MouseEvent;
    
    public class Spark extends MovieClip
    {
        private var ct:ColorTransform = new ColorTransform( 0.98, 0.98, 0.98 );
        private var lines:Array     = [];
        private var drawCount:int   = 30;
        private var cx:Number       = 300;
        private var cy:Number       = 300;
        private var nz:Number       = 0;
        private var noiseScale:Number = 100;
        private var line_length:Number = 20;
        
        private var fg:F5BitmapData2D;
        //private var perlin:PerlinNoise;
        private var isMousePressed:Boolean = false;
        
        public function Spark() 
        {
            //F5BitmapData2D
            fg = new F5BitmapData2D( 600, 600, false, 0 );
            addChild( new Bitmap(fg.bitmapData) );
            //PerlinNoise
            //perlin = new PerlinNoise();
            //
            addEventListener( Event.ENTER_FRAME, draw );
            stage.addEventListener( MouseEvent.MOUSE_DOWN, mouseDown );
            stage.addEventListener( MouseEvent.MOUSE_UP, mouseUp );
        }
        
        private function draw(e:Event):void {
            fg.beginDraw();
            //CurveDataの追加
            for ( var n:int = 0; n < 10 ; n++ ){
                var da:Number = FMath.random( Math.PI*2 );
                lines.push( new CurveData( mouseX + Math.cos(da)*10, mouseY + Math.sin(da)*10 ) );
            }
            //描画
            fg.noFill();
            for (var i:int = 0; i < lines.length; i++) {
                /*var pinum:Number = 2;
                pinum ^= -1;*/
                var c:CurveData = lines[i];
                var b:Number = FMath.random( Math.PI*2 );//perlin.noise( c.x3/noiseScale, c.y3/noiseScale, nz )*Math.PI* pinum;
                c.add( Math.cos(b)*line_length, Math.sin(b)*line_length );
                fg.stroke( FMath.random(0xff9900,0xffffcc), 0.5*(drawCount - c.n)/drawCount );
                fg.curve( c.x0, c.y0, c.x1, c.y1, c.x2, c.y2, c.x3, c.y3 );
                if ( c.n >= drawCount ) {
                    lines.splice( i, 1 ); i--;
                }
            }
            //アニメーション
            if ( !isMousePressed ) {
                fg.bitmapData.colorTransform( fg.bitmapData.rect, ct );
                nz += 0.02;
            }
            fg.endDraw();
        }
        
        public function mouseDown(e:MouseEvent):void {
            isMousePressed = true;
        }
        
        public function mouseUp(e:MouseEvent):void {
            isMousePressed = false;
        }
    }
}

class CurveData {
        public var x0:Number, x1:Number, x2:Number, x3:Number;
        public var y0:Number, y1:Number, y2:Number, y3:Number;
        public var n:int = 0;
        public function CurveData( x:Number, y:Number ) {
            x0 = x1 = x2 = x3 =  x;
            y0 = y1 = y2 = y3 =  y;
        }
        public function add( dx:Number, dy:Number ):void {
            x0 = x1; x1 = x2; x2 = x3; x3 += dx;
            y0 = y1; y1 = y2; y2 = y3; y3 += dy;
            n++;
        }
    }


