/**
 * Copyright Scmiz ( http://wonderfl.net/user/Scmiz )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pdpE
 */

package {
	import flash.display.Graphics;
    import flash.display.Sprite;
	import flash.geom.Point;
    public class FlashTest extends Sprite {
        public function FlashTest() {
			draw(10, 232.5, 232.5, -Math.PI * 0.5);
        }
		
		private function draw(n:uint, posX:Number, posY:Number, rad:Number):void {
			drawRecursive(n, posX, posY, rad, true);
		}

		private function drawRecursive(n:uint, posX:Number, posY:Number, rad:Number, isFirst:Boolean):void {
			var g:Graphics = this.graphics;
			g.lineStyle(1, 0x000000, 1.0 - (n * 0.1));
			
			var length:Number = 30 - (n * 2); 
			for (var index:uint = 0; index < (isFirst ? 3 : 2); ++index) {
				g.moveTo(posX, posY);
				var r:Number = rad - (Math.PI / 3) + (Math.PI * 2 / 3 * index);
				var nextPosX:Number = posX + (Math.cos(r) * length);
				var nextPosY:Number = posY + (Math.sin(r) * length);
				g.lineTo(nextPosX, nextPosY);
				
				if (n > 0) {
					drawRecursive(n - 1, nextPosX, nextPosY, r, false);
				}
			}
		}
    }
}