/**
 * Copyright kururu99 ( http://wonderfl.net/user/kururu99 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pdfh
 */

package {
    import flash.events.*;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    public class Main extends Sprite {
        private var videoSetting:VideoSetting;
        public function Main() {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            addEventListener(Event.ADDED_TO_STAGE, init);
            stage.addEventListener( Event.RESIZE, init);

        }
        public function init(event:Event):void {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            if (stage.stageWidth>0) {
                stage.removeEventListener( Event.RESIZE, init);
                videoSetting = new VideoSetting(stage.stageWidth,stage.stageHeight);
                addChild(videoSetting);
                videoSetting.videoIdRack = ["Ux9sogZkIm8"];
                stage.addEventListener( Event.RESIZE, Resize);
            }
        }
        public function Resize(event:Event):void {
            videoSetting.Resize(stage.stageWidth,stage.stageHeight);
        }
    }
}
    import flash.events.*;
    import flash.display.Loader;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.net.URLRequest;
    import flash.system.Security;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;

class VideoSetting extends Sprite
{
    private var player:Object;
    private var VideoPlayer:Loader;
    private var videoSeeker:Dragger;
    private var playerState:int;
    private var ButtonPlay:Shape;
    private var ButtonPause:Sprite;
    private var VideoPlayerBox:Sprite = new Sprite();
    private var playBg:Sprite = new Sprite();
    private var playButton:Sprite = new Sprite();
    private var VideoPlayerWidth:int = 500;
    private var VideoPlayerHeight:int = 400;
    public var videoIdRack:Array = new Array();
    private var videoIdCount:int = 0;
    public function VideoSetting(StageWidth:int=500,StageHeight:int=400):void{
        Security.allowDomain("*");
        Security.allowInsecureDomain("*");
        videoIdRack = ["xq-2B6UxMXM"];
        VideoPlayerWidth =StageWidth;
        VideoPlayerHeight = StageHeight;
        drawBox(VideoPlayerBox,0x000000,VideoPlayerWidth,VideoPlayerHeight,1);
        this.addChild(VideoPlayerBox);
        VideoPlayer = addChild(new Loader()) as Loader;
        VideoPlayer.contentLoaderInfo.addEventListener(Event.INIT, onLoaderInit);
        VideoPlayer.load(new URLRequest("http://www.youtube.com/apiplayer?version=3"));
        drawBox(playBg,0x000000,VideoPlayerWidth,30,1);
        this.addChild(playBg);
        playBg.y = VideoPlayerHeight- 30;
        drawBox(playButton,0x000000,30,30,1);
        playBg.addChild(playButton);
        ButtonPlay = getTriangle(0,0,0,18,18,9,0xffffff);
        ButtonPlay.x = ButtonPlay.y = 5;
        playButton.addChild(ButtonPlay);
        ButtonPause = getButton(0xffffff,18,18,1);
        ButtonPause.x = ButtonPause.y = 6;
        ButtonPlay.visible = false;
        playButton.addChild(ButtonPause);
        playButton.addEventListener(MouseEvent.CLICK,PlayChange);
        videoSeeker = new Dragger(VideoPlayerWidth - 45,20,30,20,0xCC0000);
        playBg.addChild(videoSeeker);
        videoSeeker.x = 30+5;
        videoSeeker.y = 5;
        videoSeeker.value = 12;
        videoSeeker.setValue(0);
        videoSeeker.addEventListener("CHANGE", function():void { player.seekTo(videoSeeker.value/100*player.getDuration());});
        videoSeeker.addEventListener("CLICK", function():void { player.seekTo(videoSeeker.valueC/100*player.getDuration());});
        videoSeeker.addEventListener("WHEEL", function():void { player.seekTo(videoSeeker.valueW/100*player.getDuration());});
    }
    public function Resize(StageWidth:int=500,StageHeight:int=400):void
    {
        VideoPlayerWidth =StageWidth;
        VideoPlayerHeight = StageHeight;
        drawBox(VideoPlayerBox,0x000000,VideoPlayerWidth,VideoPlayerHeight,1);
        drawBox(playBg,0x000000,VideoPlayerWidth,30,1);
        playBg.y = VideoPlayerHeight- 30;
        drawBox(playButton,0x000000,30,30,1);
        player.setSize(VideoPlayerWidth,VideoPlayerHeight-30);
        videoSeeker.Resize(VideoPlayerWidth - 45,20);
        if (player.getDuration()>0){
            videoSeeker.setValue(100*player.getCurrentTime()/player.getDuration());
            videoSeeker.setLoad(Math.floor(100*player.getVideoBytesLoaded()/player.getVideoBytesTotal()));
        }
    }
    private function drawBox(box:Sprite,color:uint,width:int=100, height:int=100,alpha:Number=1):void
    {
        box.graphics.clear();
        box.graphics.beginFill(color,alpha);
        box.graphics.drawRect(0, 0, width, height);
        box.graphics.endFill();
    }
    private function getButton(color:uint,width:int=100, height:int=100,alpha:Number=1):Sprite
    {
        var Button:Sprite = new Sprite();
        Button.graphics.clear();
        Button.graphics.beginFill(color,alpha);
        Button.graphics.drawRect(0, 0, width, height);
        Button.graphics.drawRect(Math.floor(width-4)/2, 0, 4, height);
        Button.graphics.endFill();
        return Button;
    }
    private function getTriangle(x1:int, y1:int, x2:int, y2:int, x3:int, y3:int, color:uint):Shape
    {
        var triangle:Shape = new Shape();
        triangle.graphics.clear();
        triangle.graphics.beginFill(color);
        triangle.graphics.moveTo(x1, y1);
        triangle.graphics.lineTo(x2, y2);
        triangle.graphics.lineTo(x3, y3);
        triangle.graphics.lineTo(x1, y1);
        triangle.graphics.endFill();
        return triangle;
    }
    private function onLoaderInit(event:Event):void
    {
        VideoPlayer.content.addEventListener("onReady", onPlayerReady);
        VideoPlayer.content.addEventListener("onError", onPlayerError);
        VideoPlayer.content.addEventListener("onStateChange", onPlayerStateChange);
        VideoPlayer.content.addEventListener("onPlaybackQualityChange", onVideoPlaybackQualityChange);
        VideoPlayer.content.addEventListener(Event.ENTER_FRAME, onVideoPlayLoading);
    }
    private function onPlayerReady(event:Event):void
    {
        player = VideoPlayer.content;
        player.setSize(VideoPlayerWidth,VideoPlayerHeight-30);
        player.loadVideoById(videoIdRack[videoIdCount], 0, "hd720");
    }
    private function onPlayerError(event:Event):void
    {
        trace("player error:", Object(event).data);
    }
    private function onPlayerStateChange(event:Event):void
    {
        playerState = Object(event).data;
        trace("playerState:", Object(event).data);
        if (player.getCurrentTime()==player.getDuration() && player.getDuration()>0)
        {
            videoIdCount=videoIdCount+1;
            if(videoIdCount==videoIdRack.length){
                videoIdCount=0;
                player.loadVideoById(videoIdRack[0], 0, "hd720");
            }
            else{
                player.loadVideoById(videoIdRack[videoIdCount], 0, "hd720");
            }
            trace("videoIdCount"+videoIdCount);
        }
    }
    private function onVideoPlayLoading(event:Event):void
    {
        if (playerState == 1){
            videoSeeker.setValue(100*player.getCurrentTime()/player.getDuration());
            videoSeeker.setLoad(Math.floor(100*player.getVideoBytesLoaded()/player.getVideoBytesTotal()));
            ButtonPause.visible = true;
            ButtonPlay.visible = false;
        }
        else{
            ButtonPause.visible = false;
            ButtonPlay.visible = true;    
        }
    }
    private function onVideoPlaybackQualityChange(event:Event):void
    {
        trace("video quality:", Object(event).data);
    }
    private function PlayChange(event:Event):void
    {
        if (playerState == 1)
        {
            player.pauseVideo();
            ButtonPause.visible = false;
            ButtonPlay.visible = true;
        }
        else
        {
            player.playVideo();
            ButtonPause.visible = true;
            ButtonPlay.visible = false;
        }
    }
}


import flash.events.*;
import flash.events.MouseEvent;
import flash.display.Sprite;
import flash.display.Stage;
import flash.text.TextField;

class Dragger extends Sprite
{
    private var draggLoad:Sprite = new Sprite;
    private var draggBg:Sprite = new Sprite;
    private var draggBar:Sprite = new Sprite;
    private var MaxWidth:int;
    private var MaxHeight:int;
    private var Text:TextField;
    private var scrollbarControl:Boolean = false;
    public var value:int = 0;
    public var valueC:int = 0;
    public var valueW:int = 0;
    public function Dragger(Bgwidth:int=200, Bgheight:int=100,width:int=100, height:int=100,color:uint=0x0099ff):void
    {
        drawBox(draggLoad,0xbbbbbb,1,Bgheight,1);
        this.addChild(draggLoad);
        Text= new TextField();
        Text.text = "0";
        Text.x = 5;
        Text.y = 0;
        Text.width = 80;
        Text.height = 20;
        this.addChild(Text);
        drawBox(draggBg,0xdddddd,Bgwidth,Bgheight,0.5);
        this.addChild(draggBg);
        drawBox(draggBar,color,width,height);
        draggBg.addChild(draggBar);
        draggBar.addEventListener(Event.ENTER_FRAME,MoveScroll);
        setMax(100);
    }
    public function Resize(Bgwidth:int=200, Bgheight:int=100):void
    {
        MaxWidth = Bgwidth;
        drawBox(draggBg,0xdddddd,Bgwidth,Bgheight,0.5);
    }
    public function setValue(v:Number):void
    {
        if (scrollbarControl == false)
        {
            draggBar.x = Math.floor((MaxWidth-draggBar.width)*v/100);
            setValueText();
        }
    }
    public function setLoad(v:Number):void
    {
        draggLoad.width = Math.floor(MaxWidth * v / 100);
    }
    public function setMax(v:Number):void
    {
        MaxWidth = draggBg.width * v / 100;
        MaxHeight = draggBg.height * v / 100;
        if (MaxHeight < draggBar.height)
        {
            MaxHeight = draggBar.height;
        }
        if (MaxWidth < draggBar.width)
        {
            MaxWidth = draggBar.width;
        }
    }
    private function drawBox(box:Sprite,color:uint,width:int=100, height:int=100,alpha:Number=1):void
    {
        box.graphics.clear();
        box.graphics.beginFill(color,alpha);
        box.graphics.drawRect(0, 0, width, height);
        box.graphics.endFill();
    }
    private function setValueText():void
    {
        Text.text = String(Math.floor(draggBar.x/(MaxWidth-draggBar.width)*100)+"%");
        value = Math.floor(draggBar.x/(MaxWidth-draggBar.width)*100);
    }
    private function MoveScroll(e:Event):void
    {
        removeEventListener(Event.ENTER_FRAME, MoveScroll);
        draggBar.addEventListener(MouseEvent.MOUSE_DOWN, scrollbarHandler);
        draggBg.addEventListener(MouseEvent.MOUSE_WHEEL,onScrollArea);
        draggBg.addEventListener(MouseEvent.CLICK, onScrollArea);
        stage.addEventListener(MouseEvent.MOUSE_UP, scrollbarUpHandler);
    }
    private function scrollbarHandler(e:Event):void
    {
        scrollbarControl = true;
        draggBar.addEventListener(Event.ENTER_FRAME, onScrollArea );
    }
    private function scrollbarUpHandler(e:Event):void
    {
        scrollbarControl = false;
        draggBar.removeEventListener(Event.ENTER_FRAME, onScrollArea );
    }
    private function onScrollArea(e)
    {
        if (e.type == "mouseWheel")
        {
            draggBar.x +=  e.delta * -3;
            draggBar.y +=  e.delta * -3;
            valueW = Math.floor(draggBar.x/(MaxWidth-draggBar.width)*100);
            this.dispatchEvent(new Event("WHEEL"));
        }
        else if (e.type == "click")
        {
            draggBar.x=(stage.mouseX-this.x)-draggBar.width/2;
            draggBar.y=(stage.mouseY-this.y)-draggBar.height/2;
            valueC = Math.floor(draggBar.x/(MaxWidth-draggBar.width)*100);
            this.dispatchEvent(new Event("CLICK"));
        }
        else
        {
            draggBar.x=(stage.mouseX-this.x)-draggBar.width/2;
            draggBar.y=(stage.mouseY-this.y)-draggBar.height/2;
            this.dispatchEvent(new Event(Event.CHANGE));
        }
        if (draggBar.x < 0)
        {
            draggBar.x = 0;
        }
        if (draggBar.y < 0)
        {
            draggBar.y = 0;
        }
        if (draggBar.x > MaxWidth - draggBar.width)
        {
            draggBar.x = MaxWidth - draggBar.width;
        }
        if (draggBar.y > MaxHeight - draggBar.height)
        {
            draggBar.y = MaxHeight - draggBar.height;
        }
        setValueText();
    }
}