/**
 * Copyright xSonoSx ( http://wonderfl.net/user/xSonoSx )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pdc2
 */

// forked from mousepancyo's Loose Glow Line（Math Graphics Example）
// forked from undo's forked from: 線がうまく描けません（Math Graphics Example）
// forked from mousepancyo's 線がうまく描けません（Math Graphics Example）
package  {
    import flash.display.Sprite;
    import flash.display.Shape;
    import flash.geom.Point;
    import flash.events.Event;
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.filters.BlurFilter;
    import flash.geom.Rectangle;
    import flash.geom.ColorTransform;
    import frocessing.color.ColorHSV;
    
    [SWF(frameRate=60)]
    public class Main extends Sprite{
        
        private var rotObj:Sprite = new RotObj();
        private var _r:Number;
        private var _rad:Number;
        private var _radius:Number;
        private var _centerX:Number = stage.stageWidth / 2;
        private var _centerY:Number = stage.stageHeight / 2;
        private var _p:Point = new Point(_centerX, _centerY);
        private var _isMouseDown:Boolean;
        
        private var _circleBmd:BitmapData;
        private var _canvas:BitmapData;
        private var _glowBmd:BitmapData;
        private var _bm:Bitmap;
        private var _glowBm:Bitmap;
        private var _blure:BlurFilter = new BlurFilter(16, 16, 3);
        
        private var _ct:ColorTransform;
        private var _hsv:ColorHSV;
        
        public function Main() {
            var sp:Shape = new Shape();
            sp.graphics.beginFill(0xFFFFFF);
            sp.graphics.drawCircle(30, 30, 10);
            sp.graphics.endFill()
            //
            _circleBmd = new BitmapData(50, 50, true, 0)
            _circleBmd.draw(sp);
            //
            _canvas = new BitmapData(500, 500, false, 0)
            _bm= new Bitmap( _canvas );
            _bm.x = _bm.y = -25;
            _bm.filters = [_blure];
            addChild(_bm);
            //
            _glowBmd = _canvas.clone();
            _glowBm = new Bitmap(_glowBmd);
            _glowBm.filters = [_blure];
            _glowBm.blendMode = "add";
            _glowBm.x = _glowBm.y = -25;
            addChild(_glowBm);
            //
            _ct= new ColorTransform();
            _hsv = new ColorHSV(0, .9, .99);
            //
            addChild(rotObj);
            rotObj.x = _centerX;
            rotObj.y = _centerY;
            stage.addEventListener(MouseEvent.MOUSE_DOWN, onDown);
            stage.addEventListener(MouseEvent.MOUSE_UP, onUp);
            graphics.lineStyle(1, 0);
            
            Wonderfl.capture_delay(10);
        }
        
        private function update(e:Event):void{
            var mPoint:Point = new Point(mouseX, mouseY);
            var cPoint:Point = new Point(_centerX, _centerY);
            rotObj.rotation += (mPoint.y - cPoint.y) * 0.05;
            _r = rotObj.rotation;
            _rad = _r * Math.PI / 180;
            
            if(_isMouseDown){
                _p.x = _centerX + Math.cos(_rad) * (mPoint.x - cPoint.x);
                _p.y = _centerY + Math.sin(_rad) * (mPoint.x - cPoint.x);
                _canvas.copyPixels(_circleBmd, _circleBmd.rect, _p);
                _canvas.colorTransform(_canvas.rect, _ct);
                _glowBmd.copyPixels(_canvas, _canvas.rect, new Point());
                //
                _ct.redMultiplier = (_hsv.value >> 16 & 0xff) / 255;
                _ct.greenMultiplier = (_hsv.value >> 8 & 0xff) / 255;
                _ct.blueMultiplier = (_hsv.value & 0xff) / 255;
                _hsv.h += 1;
            }
        }
        
        private function onDown(e:MouseEvent):void{
            _isMouseDown = true;
            var rad:Number = Math.atan2(mouseY - _centerY, mouseX - _centerX);
            _p.x = _centerX + Math.cos(rad) * (mouseX - _centerX);
            _p.y = _centerY + Math.sin(rad) * (mouseX - _centerX);
            rotObj.rotation = rad * 180 / Math.PI;
            //
            graphics.moveTo(_p.x, _p.y);
            addEventListener(Event.ENTER_FRAME, update);
        }
        private function onUp(e:MouseEvent):void{
            _isMouseDown = false;
            graphics.clear();
            graphics.lineStyle(1, 0);
            graphics.moveTo(_p.x, _p.y);
            removeEventListener(Event.ENTER_FRAME, update);
            rotObj.rotation = 0;
        }
    }
}

import flash.display.Sprite;
class RotObj extends Sprite{
    public function RotObj() {
        this.graphics.lineStyle(1, 0x990000);
        graphics.moveTo(0, 0);
        graphics.lineTo(-10, 0);
        graphics.moveTo(0, 0);
        graphics.lineTo(0, -10);
        graphics.moveTo(0, 0);
        graphics.lineTo(10, 0);
        graphics.moveTo(0, 0);
        graphics.lineTo(0, 10);
    }
}