/**
 * Copyright ohisama ( http://wonderfl.net/user/ohisama )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pczg
 */

// forked from wanson's 音声合成もどき
package 
{
    import flash.display.Sprite;
    import flash.events.*;
    import flash.media.Sound;
    import flash.utils.ByteArray;
    public class FlashTest extends Sprite 
    {
        private var phase : Number = 0, time : Number = 0;
        private var tap : Array = [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0];
        private const FL : Array = 
        [
            [800.0, 1300.0, 2500.0, 3500.0, 4500.0, 0.9],
            [250.0, 2100.0, 3100.0, 3500.0, 4500.0, 1.3],
            [250.0, 1400.0, 2200.0, 3500.0, 4500.0, 1.2],
            [450.0, 1900.0, 2400.0, 3500.0, 4500.0, 0.9],
            [450.0,  900.0, 2600.0, 3500.0, 4500.0, 0.8]
        ];
        private var _button : Button;
        public function FlashTest() : void
        {
            var labels : Array = "あいうえお".split("");
            var times : Array = [0.0, 0.15, 0.45, 0.8, 1.0];
            var button : Button;
            for (var i : uint = 0; i < 5; i++)
            {
                var x : int = (i % 5) * 60;
                var y : int = uint(i / 5) * 60;
                button = new Button(40, 40, 12, labels[i]);
                button.x = x;
                button.y = y;
                button.time = times[i];
                button.addEventListener(MouseEvent.MOUSE_DOWN, onButtonDown);
                addChild(button);
            }
            var sound : Sound = new Sound();
            sound.addEventListener(SampleDataEvent.SAMPLE_DATA, onSample);
            sound.play();
        }
        private function onButtonDown(e : MouseEvent) : void
        {
            _button = e.currentTarget as Button;
            _button.addEventListener(MouseEvent.MOUSE_UP, onButtonUp);
        }
        private function onButtonUp(e : MouseEvent) : void
        {
            _button = null;
            _button.removeEventListener(MouseEvent.MOUSE_UP, onButtonUp);
        }
        private function onSample(event : SampleDataEvent) : void
        {
            var pos : Number = event.position;
            if (_button === null)
            {
            }
            else
            {
                time = _button.time;
            }
            for (var i : int = 0; i < 4096; i++) 
            {
                if (_button === null)
                {
                    event.data.writeFloat(0); 
                    event.data.writeFloat(0);
                }
                else
                {
                    var vow1 : int = Math.floor(time / 1.5 * 5) % 5;
                    var vow2 : int = (vow1 + 1) % 5;
                    var amp : Number = (0.65 - 0.15 * Math.cos(time * Math.PI / 1.5 * 5));
                    var freq : Number = 160 + 50 * Math.sin(2 * Math.PI * time * 1.7) + 40 + 70 * Math.sin(2 * Math.PI * time / 23 +  2 * Math.cos(time));
                    var w : Number = 1 / (1 + Math.exp(-30 * (5 * time / 1.5 - Math.floor(5 * time / 1.5) - 0.5)));
                    var s : Number = 0.4 * Math.sin(phase - Math.floor(phase)) * ((1 - w) * FL[vow1][5] + w * FL[vow1][5]) * amp;
                    for (var k : int = 0; k < 5; k++) 
                    {
                        var ff : Number = (1 - w) * FL[vow1][k] + w * FL[vow2][k];
                        var r : Number  = Math.exp(-Math.PI * 50.0 * (1.0 + ff * ff * 1e-6 / 6.0) / 44100.0);
                        var a1 : Number = 2.0 * r * Math.cos(2.0 * Math.PI * ff / 44100.0);
                        s = (1.0 - a1 + r * r) * s + (a1 * tap[k]) - (r * r * tap[k + 5]);
                        tap[k + 5] = tap[k]; 
                        tap[k] = s;
                    }
                    event.data.writeFloat(s); 
                    event.data.writeFloat(s);
                    phase += freq / 44100;
                    time += 1.0 / 44100.0;
                }
            }
        }
    }
}
import flash.display.Sprite;
import flash.events.Event;
import flash.text.TextField;
import flash.geom.Matrix;
import flash.filters.ColorMatrixFilter;
import flash.filters.GlowFilter;
class Button extends Sprite
{
    private static const mono : ColorMatrixFilter = new ColorMatrixFilter([
        1 / 3, 1 / 3, 1 / 3, 0, 10,
        1 / 3, 1 / 3, 1 / 3, 0, 10,
        1 / 3, 1 / 3, 1 / 3, 0, 10,
            0,     0,     0, 1, 0
    ]);
    public var time : Number;
    private var _hover : Boolean = false;
    public function get hover() : Boolean
    {
        return _hover;
    }
    public function set hover(value : Boolean) : void
    {
        if (_hover != value)
        {
            _hover = value;
            filters = (_hover ? null : [mono]);
        }
    }
    public function Button(W : Number = 20, H : Number = 20, R : Number = 4, label : String = "", size : int = 11)
    {
        var matrix : Matrix = new Matrix();
        matrix.createGradientBox(W, H, Math.PI / 2);
        var bg : Sprite = new Sprite();
        bg.graphics.beginGradientFill("linear", [0xDDE9F4, 0xD5E4F1, 0xBAD2E8], [1, 1, 1], [0, 120, 136], matrix);
        bg.graphics.drawRoundRect(0, 0, W, H, R, R);
        bg.graphics.endFill();
        bg.filters = [new GlowFilter(0xFFFFBE, .5, 10, 10, 2, 1, true)];
        addChild(bg);
        var line : Sprite = new Sprite();
        line.graphics.lineStyle(1, 0xBAD2E8);
        line.graphics.drawRoundRect(0, 0, W, H, R, R);
        addChild(line);
        filters = [mono];
        buttonMode = true;
        mouseChildren = false;
        if (label != "")
        {
            var textField : TextField = new TextField();
            textField.selectable = false;
            textField.autoSize = "left";
            textField.htmlText = <font size={size} color="#6B8399">{label}</font>.toXMLString();
            textField.x = (W - textField.width) / 2;
            textField.y = (H - textField.height) / 2;
            addChild(textField);
        }
        addEventListener("rollOver", buttonRollOver);
        addEventListener("rollOut", buttonRollOut);
        addEventListener("removed", function(event : Event) : void
        {
            removeEventListener("rollOver", buttonRollOver);
            removeEventListener("rollOut", buttonRollOut);
            removeEventListener("removed", arguments.callee);
        });
    }
    protected function buttonRollOver(event : Event) : void
    {
        hover = true;
    }
    protected function buttonRollOut(event : Event) : void
    {
        hover = false;
    }
}

