/**
 * Copyright hi.kurosawa ( http://wonderfl.net/user/hi.kurosawa )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pcg9
 */

package 
{
    //------------------------------------------
    //マンデルブロ集合の画像のスライドショー
    // URL:http://programmingatelier.net/
    //------------------------------------------
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.utils.setTimeout;
    import flash.display.StageScaleMode; 
    import flash.display.StageAlign;
    
    public class Main extends Sprite {
        //それなりの画像が出来る位置（中心）と幅（d*2）
        public var arrItiData:Array = new Array(
            {x:1.2281216000000001,y:-0.16577279999999994,d:0.000460799999999999},
            {x:1.2292736,y:-0.16646399999999995,d:0.0005183999999999988},
            {x:1.2323264,y:-0.16565759999999993,d:0.0004031999999999991},
            {x:-0.32755839999999997,y:-0.5259904,d:0.0006911999999999985},
            {x:-0.3306688,y:-0.5329024,d:0.0006911999999999985},
            {x:-0.3282496,y:-0.5353216,d:0.0006911999999999985},
            {x:-0.3360039424,y:0.05715748864000004,d:0.000009953279999996844},
            {x:-0.335686912,y:0.057350656000000035,d:0.00000921599999999967},
            {x:-0.37781631999999993,y:0.13287411199999988,d:0.00011059200000000268},
            {x:-0.37645235199999993,y:0.13245017599999986,d:0.00011059200000000268},
            {x:-0.36718719999999994,y:0.12950719999999988,d:0.0012288000000000032},
            {x:-0.3733311999999999,y:0.13288639999999988,d:0.0012288000000000032},
            {x:-0.33843519999999994,y:0.5717503999999999,d:0.00007679999999999687},
            {x:-0.33914559999999994,y:0.5713088,d:0.00007679999999999687},
            {x:-0.33857919999999997,y:0.5713471999999999,d:0.0001343999999999945},
            {x:-0.3358239999999999,y:0.5749759999999999,d:0.00048000000000000267},
            {x:-0.33985599999999994,y:0.5743039999999999,d:0.00048000000000000267},
            {x:0.13158720000000002,y:0.8446752,d:0.00015360000000000262},
            {x:0.1316064,y:0.8449728000000001,d:0.00008640000000000148},
            {x:0.13876800000000003,y:0.839808,d:0.00047999999999999985},
            {x:0.1804096000000001,y:0.8304,d:0.0001920000000000005},
            {x:0.1807936000000001,y:0.8295551999999999,d:0.000384000000000001},
            {x:0.17896000000000006,y:0.8370912,d:0.00009600000000000164},
            {x:0.38164800000000015,y:0.6219296000000001,d:0.00028799999999999936},
            {x:0.38015040000000017,y:0.6194528,d:0.00028799999999999936},
            {x:0.5389568,y:0.6179552,d:0.0005183999999999988},
            {x:0.557552,y:0.5564799999999999,d:0.0007199999999999984},
            {x:0.5566880000000001,y:0.5537439999999999,d:0.0007199999999999984},
            {x:0.5594560000000001,y:0.48512,d:0.0007199999999999984},
            {x:0.5513920000000001,y:0.49232,d:0.0007199999999999984},
            {x:0.7344425600000001,y:0.18182879999999993,d:0.00010080000000000089},
            {x:0.7338982400000001,y:0.1811030399999999,d:0.00010080000000000089},
            {x:0.7309952000000001,y:0.18938879999999994,d:0.001411199999999997},
            {x:0.7376480000000001,y:0.19281599999999993,d:0.001411199999999997},
            {x:0.821389184,y:0.20151187199999995,d:0.00019756799999999243},
            {x:0.8324288,y:0.19820159999999995,d:0.001411199999999997},
            {x:0.830816,y:0.20666879999999996,d:0.0020159999999999957},
            {x:1.3976939916799997,y:0.00490229248000005,d:0.000027659519999989612},
            {x:1.3976939916799997,y:0.005052444160000044,d:0.000027659519999989612},
            {x:1.4766338560000003,y:0.00491468800000004,d:0.000002015999999995799},
            {x:1.4766528640000003,y:0.004909504000000039,d:0.000002591999999994599},
            {x:1.4766439360000003,y:0.004926208000000041,d:0.000002591999999994599},
            {x:1.4767600000000003,y:0.004734400000000038,d:0.000028800000000002157},
            {x:1.4766016000000002,y:0.0044896000000000345,d:0.000057600000000004314},
            {x:1.4765872000000002,y:0.004964800000000042,d:0.000057600000000004314},
            {x:1.4772208000000002,y:0.005396800000000047,d:0.000057600000000004314},
            {x:-0.0773472,y:-0.6215136,d:0.0004320000000000004},
            {x:-0.07752,y:-0.6239328,d:0.0004320000000000004},
            {x:-0.0798528,y:-0.6210816,d:0.0004320000000000004},
            {x:0.013024256000000047,y:-0.734970048,d:0.000015551999999999962},
            {x:0.013044992000000047,y:-0.734788608,d:0.000015551999999999962},
            {x:0.013169408000000046,y:-0.7347937920000001,d:0.000015551999999999962},
            {x:-0.011660799999999949,y:-0.651048,d:0.00017280000000000003},
            {x:-0.011185599999999948,y:-0.6505152,d:0.00017280000000000003},
            {x:-0.004863999999999949,y:-0.650832,d:0.0007199999999999999},
            {x:0.04694720000000005,y:-0.8085088,d:0.00019199999999999982},
            {x:0.048214400000000046,y:-0.8073568,d:0.00019199999999999982},
            {x:0.04971200000000005,y:-0.8079712,d:0.00019199999999999982},
            {x:0.12859200000000004,y:-0.8806880000000001,d:0.00026880000000000014},
            {x:0.13248960000000004,y:-0.8802176000000002,d:0.0003360000000000002},
            {x:0.13141440000000004,y:-0.8786048000000001,d:0.0003360000000000002},
            {x:0.15787200000000004,y:-0.8414144000000001,d:0.0002688000000000007},
            {x:0.15890880000000004,y:-0.8401088000000001,d:0.000768000000000002},
            {x:0.12797760000000002,y:-0.8798144000000001,d:0.00026880000000000014},
            {x:0.13120320000000002,y:-0.8784704000000001,d:0.00047040000000000027},
            {x:0.13268160000000004,y:-0.8793440000000001,d:0.00047040000000000027},
            {x:0.14051520000000003,y:-0.8643680000000001,d:0.00047040000000000027},
            {x:0.14192640000000004,y:-0.8655776000000002,d:0.00047040000000000027},
            {x:0.14380800000000005,y:-0.8684000000000002,d:0.00047040000000000027},
            {x:0.5590976000000001,y:-0.48115519999999995,d:0.00047040000000000417},
            {x:0.5563424,y:-0.48256639999999995,d:0.00047040000000000417},
            {x:0.5597024,y:-0.48424639999999997,d:0.00047040000000000417},
            {x:0.6564640000000002,y:-0.4483711999999999,d:0.00047040000000000417},
            {x:0.6592192000000002,y:-0.4511263999999999,d:0.00047040000000000417},
            {x:0.6538984960000002,y:-0.481112192,d:0.00006585599999999747},
            {x:0.6728320000000001,y:-0.45876799999999995,d:0.00033599999999999407},
            {x:0.71653152,y:-0.28493408000000003,d:0.000042239999999993395},
            {x:0.71653152,y:-0.28509152,d:0.000042239999999993395},
            {x:0.71666592,y:-0.28509152,d:0.000042239999999993395},
            {x:0.7163039999999999,y:-0.283496,d:0.00026399999999999536},
            {x:0.5441408000000001,y:0.617264,d:0.0015551999999999966},
            {x:0.7234848,y:0.28981119999999994,d:0.003244800000000012},
            {x:1.016901504,y:0.2576632575999999,d:0.000004492800000002184},
            {x:1.0169174016,y:0.25765047039999994,d:0.00001036800000000504},
            {x:1.01856,y:0.2561919999999999,d:0.0002879999999999949},
            {x:1.4003328000000002,y:0.002211199999999992,d:0.000057599999999999875},
            {x:1.4022912,y:-0.00003520000000000953,d:0.00011519999999999975},
            {x:1.4037888,y:-0.00003520000000000953,d:0.00017279999999999962},
            {x:1.4766898124799999,y:-0.004783621120000009,d:5.529600000020452e-7},
            {x:1.476764032,y:-0.0047914240000000085,d:0.000015359999999997596},
            {x:1.4767194879999999,y:-0.004859008000000006,d:0.000015359999999997596},
            {x:1.4844757964800002,y:0.00008175103999999196,d:0.000002211839999994858},
            {x:1.484550016,y:-0.000029824000000009776,d:0.000012287999999998079},
            {x:1.484881792,y:0.000007039999999990852,d:0.000012287999999998079},
            {x:1.484599168,y:0.000007039999999990852,d:0.000024575999999996158},
            {x:1.2601182080000002,y:-0.04000240000000013,d:0.000007775999999983796},
            {x:1.2599408,y:-0.040321600000000124,d:0.00004320000000000324},
            {x:1.2612800000000002,y:-0.03980800000000013,d:0.00023999999999999578},
            {x:1.3922624000000001,y:-0.011545600000000033,d:0.0002303999999999995},
            {x:1.3912256,y:-0.012006400000000033,d:0.000460799999999999},
            {x:1.395488,y:-0.016844800000000038,d:0.000460799999999999},
            {x:1.22046912,y:-0.1659167999999999,d:0.00010367999999998379},
            {x:1.2205152,y:-0.16670015999999993,d:0.000046079999999992796},
            {x:1.231056,y:-0.16804799999999992,d:0.0007200000000000095}
        );
        //マンデルブロ集合の描画エリア
        private var bdMandelbrot:BitmapData;
        public var arrColor:Array;    //グラデーションカラー
        public var uintHassan:uint;    //発散しない時のカラー
        private var intBMw:Number;    //描画サイズ
        private var intBMh:Number;
        private var iloop:int;        //描画状態(0～39)
        private var iTyp:int;        //画像の切り替え時のエフェクト
        private    var xMin:Number;    //マンデルブロ集合の左上の座標値
        private    var yMin:Number;
        private    var Step:Number;    //マンデルブロ集合の1ピクセルの値
        private const intKurikaesi:Number = 256;    //最大繰り返し数

        public function Main():void {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            //下の2行を加えるとHTMLで定義したサイズで表示
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align =StageAlign.TOP_LEFT;
            intBMw =  stage.stageWidth;    //描画サイズ取得
            intBMh = stage.stageHeight;
            //描画エリアの作成
            bdMandelbrot = new BitmapData(intBMw, intBMh, false, 0xffffff);
            var bm:Bitmap = new Bitmap(bdMandelbrot);
            stage.addChild(bm);
            fncDispSt();        //描画開始
        }
        //描画開始
        private function fncDispSt():void {
            iloop = 0;        //描画位置クリア
            fncSerColor();    //グラデーションカラー
            uintHassan = 0x000000;    //発散しない時のカラー
            //それなりの画像が出来る位置テーブルの選択
            var intItiData:int = getIntRand(0, arrItiData.length - 1);
            var d:Number = arrItiData[intItiData].d;
            //マンデルブロ集合上の開始位置を決める
            xMin = arrItiData[intItiData].x - d  + getNumRand(0, 1.5*d);
            yMin = arrItiData[intItiData].y - d  + getNumRand(0, 1.5 * d);
            //マンデルブロ集合の1ピクセルの値
            if (intBMh > intBMw) {
                Step = arrItiData[intItiData].d / intBMh;
            } else {
                Step = arrItiData[intItiData].d / intBMw;
            }
            Step = getNumRand(Step / 3.0, Step / 2.0);
            //画像の切り替え時のエフェクトを指定
            iTyp = getIntRand(0, 5);
            //繰り返しイベントにマンデルブロ集合の描画追加
            this.addEventListener(Event.ENTER_FRAME, fncMandelbroDisp);
        }
        //マンデルブロ集合の描画(1/40分描画、40回繰り返し）
        private function fncMandelbroDisp(e:*):void {
            var bolEnd:Boolean = false
            var bmItiY:int;
            var bmItiX:int;
            var a:Number;
            var b:Number;
            var xx:int;
            var yy:int;
            //描画時エフェクトする。
            switch (iTyp) {
            case 0 :
                for (bmItiY = iloop; bmItiY < intBMh; bmItiY+=40) {
                    b = yMin + bmItiY * Step;
                    for (bmItiX = 0; bmItiX < intBMw; bmItiX++) {
                        a = xMin + bmItiX * Step;
                        bdMandelbrot.setPixel(bmItiX, bmItiY, fncGetColor(a, b));
                    }
                }
                break;
            case 1 :
                for (bmItiY = 0; bmItiY < intBMh; bmItiY++) {
                    b = yMin + bmItiY * Step;
                    for (bmItiX = iloop; bmItiX < intBMw; bmItiX+=40) {
                        a = xMin + bmItiX * Step;
                        bdMandelbrot.setPixel(bmItiX, bmItiY, fncGetColor(a, b));
                    }
                }
                break;
            case 2 :
                for (bmItiY = iloop; bmItiY < intBMh; bmItiY+=40) {
                    for (bmItiX = 0; bmItiX < intBMw; bmItiX++) {
                        yy = bmItiY + bmItiX;
                        yy = yy % intBMh;
                        b = yMin + yy * Step;
                        a = xMin + bmItiX * Step;
                        bdMandelbrot.setPixel(bmItiX, yy, fncGetColor(a, b));
                    }
                }
                break;
            case 3 :
                for (bmItiY = iloop; bmItiY < intBMh; bmItiY+=40) {
                    for (bmItiX = 0; bmItiX < intBMw; bmItiX++) {
                        yy = bmItiY +intBMw- bmItiX;
                        yy = yy % intBMh;
                        b = yMin + yy * Step;
                        a = xMin + bmItiX * Step;
                        bdMandelbrot.setPixel(bmItiX, yy, fncGetColor(a, b));
                    }
                }
                break;
            case 4 :
                for (bmItiY = iloop; bmItiY < intBMh; bmItiY+=40) {
                    for (bmItiX = 0; bmItiX < intBMw; bmItiX++) {
                        yy = bmItiY;
                        if ((bmItiX % 60) < 30) { yy += 30; }
                        if (yy >= intBMh) { yy -= intBMh; }
                        b = yMin + yy * Step;
                        a = xMin + bmItiX * Step;
                        bdMandelbrot.setPixel(bmItiX, yy, fncGetColor(a, b));
                    }
                }
                break;
            case 5 :
                for (bmItiY = 0; bmItiY < intBMh; bmItiY++) {
                    b = yMin + bmItiY * Step;
                    for (bmItiX = iloop; bmItiX < intBMw; bmItiX+=40) {
                        xx = bmItiX;
                        if ((bmItiY % 60) < 30) { xx += 30; }
                        if (xx >= intBMw) { xx -= intBMw; }
                        a = xMin + xx * Step;
                        bdMandelbrot.setPixel(xx, bmItiY, fncGetColor(a, b));
                    }
                }
                break;
            }
            if (iloop >= 39) { bolEnd = true; }
            iloop++;            
            
            if(bolEnd == true) {
                this.removeEventListener(Event.ENTER_FRAME,fncMandelbroDisp);
                var setIDName:Number = setTimeout(fncDispSt, 3000);    //3秒後に実行
            }
        }
        //マンデルブロ集合の1点でのカラー
        private function fncGetColor(a:Number, b:Number):uint {
            var uiCol:uint = uintHassan;    //発散しないときのカラー
            var x:Number=0;
            var y:Number=0;
            var i:int = 0;
            for(i=0;i<=intKurikaesi;i++){    //最大繰り返し数繰り返し
                var x2:Number=x*x;
                var y2:Number=y*y;
                var zx:Number=x2-y2-a;
                var zy:Number=2*x*y-b;
                x=zx;
                y=zy;
                if (x2 + y2 >= 4) {
                    var id:int = i % arrColor.length;
                    uiCol= arrColor[id];
                    break;
                }
            }
            return uiCol;
        }
        //グラデーションカラー取得
        private function fncSerColor():void {
            var arrCl0:Array;
            var arrCl1:Array;
            var icflg:uint = 0;
            while (icflg == 0) {    //256階調異なるRGBがあるか？
                icflg = 0;
                arrCl0 = new Array();
                arrCl1 = new Array();
                for (var ino:int = 0; ino < 3; ino++) {    //2色RGBの各値を求める
                    var icf:int = getIntRand(0, 2);
                    icflg += icf;
                    if (icf == 1) {            //明－＞暗
                        arrCl0.push(255);
                        arrCl1.push(0);
                    } else if (icf == 2) {    //暗ー＞明
                        arrCl0.push(0);
                        arrCl1.push(255);
                    } else {                //適当
                        arrCl0.push(getIntRand(0, 255));
                        arrCl1.push(getIntRand(0, 255));
                    }
                }
            }
            arrColor = new Array();
            for(var i:int = 0; i < intKurikaesi; i++) {    //グラデーションカラー作成
                var ir:uint = arrCl0[0] + (arrCl1[0] - arrCl0[0]) * i / intKurikaesi;
                var ig:uint = arrCl0[1] + (arrCl1[1] - arrCl0[1]) * i / intKurikaesi;
                var ib:uint = arrCl0[2] + (arrCl1[2] - arrCl0[2]) * i / intKurikaesi;
                arrColor.push(ir * 256 * 256 + ig * 256 + ib);
            }
        }
        //乱数
        private function getIntRand(intMin:int, intMax:int):int {
                return intMin + Math.floor(Math.random() * (intMax + 1 - intMin));
        }
        private function getNumRand(numMin:Number, numMax:Number):Number {
                return numMin + Math.random() * (numMax  - numMin);
        }
    }
}