/**
 * Copyright kotobuki ( http://wonderfl.net/user/kotobuki )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pcR4
 */

// A very simple ping test regarding Union
// 
// Reference:
// http://www.unionplatform.com/?page_id=44

package {
    import flash.display.Sprite;
    import flash.text.TextField;
    import flash.utils.getTimer;
    
    import net.user1.reactor.IClient;
    import net.user1.reactor.Reactor;
    import net.user1.reactor.ReactorEvent;
    import net.user1.reactor.Room;

    public class UnionPingTest extends Sprite {
        private var reactor:Reactor;

        private var testRoom:Room;

        private var incomingMessages:TextField;

        private var sent:Number = 0;

        private var count:int = 0;

        public function UnionPingTest() {
            buildUI();
            reactor = new Reactor();
            reactor.addEventListener(ReactorEvent.READY, readyListener);
            reactor.connect("tryunion.com", 9100);
        }

        private function readyListener(e:ReactorEvent):void {
            incomingMessages.appendText("Connected to Union\n");
            testRoom = reactor.getRoomManager().createRoom("funnelTestRoom");
            testRoom.addMessageListener("TEST_MESSAGE", testMessageListener);
            testRoom.join();
            sendPingMessage();
            sent = getTimer();
        }

        private function buildUI():void {
            incomingMessages = new TextField;
            incomingMessages.border = true;
            incomingMessages.background = true;
            incomingMessages.width = 400;
            incomingMessages.height = 200;

            addChild(incomingMessages);
        }

        private function testMessageListener(fromClient:IClient):void {
            var now:Number = getTimer();
            incomingMessages.appendText("ping (" + count + "): " + (now - sent) + "ms\n");
            count++;
            if (count < 10) {
                sendPingMessage();
            }
            sent = now;
        }
        
        private function sendPingMessage():void {
            testRoom.sendMessage("TEST_MESSAGE", true, null);
        }
    }
}