/**
 * Copyright Nicolas ( http://wonderfl.net/user/Nicolas )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pbqq
 */

// forked from sake's Pixel3Dの座標⇒普通のxy座標
/*
   プリミティブオブジェクトのどの頂点が頂点番号何番なのか今一分からないので、
   fork元のsakeさんのコードのShapeをTextFieldにして
   TextFieldの位置を各頂点の座標に合わせ、頂点番号を表示しました。
   クラス化してテスト用に使えるようにしたい。
 */

package
{
	import flash.text.TextField;
	import flash.display.Shape;
	import flash.display.StageQuality;
	import flash.events.Event;

	import org.papervision3d.core.effects.utils.BitmapClearMode;
	import org.papervision3d.core.geom.Pixels;
	import org.papervision3d.core.geom.renderables.Pixel3D;
	import org.papervision3d.core.geom.renderables.Vertex3DInstance;
	import org.papervision3d.core.geom.renderables.Vertex3D;
	import org.papervision3d.materials.WireframeMaterial;
	import org.papervision3d.objects.primitives.*;
	import org.papervision3d.view.BasicView;
	import org.papervision3d.view.layer.BitmapEffectLayer;

	[SWF(width="465", height="465", backgroundColor="0x000000", frameRate="40")]
	public class Main extends BasicView
	{
		private const RADIUS:int=140;
		private var pixels:Pixels;
		private var sphere:Sphere;
		private var ary:Array;
		//private var t:TextField = addChild(new TextField()) as TextField;//確認用

		// コンストラクタ
		public function Main()
		{
			// もろもろの準備
			stage.quality=StageQuality.HIGH;
			super(0, 0, true, true);

			var layer:BitmapEffectLayer=new BitmapEffectLayer(viewport, 465, 465, true, 0, BitmapClearMode.CLEAR_PRE, true);
			layer.clearBeforeRender=true;
			viewport.containerSprite.addLayer(layer);

			camera.z=-500;
			sphere=new Sphere(new WireframeMaterial(0xdddddd, 0.1, 1), Math.sqrt(RADIUS * RADIUS * 3), 10, 10);
			sphere.material.doubleSided=true;
			scene.addChild(sphere);

			pixels=new Pixels(layer);
			scene.addChild(pixels);
			
			var verticesNum:uint = sphere.geometry.vertices.length;
			var p:Pixel3D;
			var vertex:Vertex3D;
			for (var v:int = 0; v < verticesNum; v++){
				vertex = sphere.geometry.vertices[v];
				p = new Pixel3D(0xFFFFFFFF, vertex.x, vertex.y, vertex.z);
				pixels.addPixel3D(p);
			}

			ary=[];
			var tf:TextField;
			for (var i:int=0; i < verticesNum; i++)
			{
				tf = new TextField();
				tf.textColor = 0xFFFFFF;
				tf.text = i.toString();
				addChild(tf);
				ary[i] = tf;
			}

			// Let's レンダリング！
			startRendering();
			addEventListener(Event.ENTER_FRAME, onFrame);
		}

		// エンターフレーム
		private function onFrame(e:Event):void
		{
			sphere.rotationX=pixels.rotationY+=0.5;
			sphere.rotationY=pixels.rotationX+=0.5;

			// Pixelの座標をスクリーン座標にしてShapeに適用
			// RenderPixels.asを参考にしました。っていうかほぼそのまま。
			var offsetX:Number=stage.stageWidth >> 1;
			var offsetY:Number=stage.stageHeight >> 1;

			var v3d:Vertex3DInstance;
			var i:int=0;   
			for each (var p:Pixel3D in pixels.pixels)
			{
				v3d=p.vertex3D.vertex3DInstance;
				
				if (v3d.visible)
				{
					(ary[i] as TextField).x=v3d.x + offsetX;
					(ary[i] as TextField).y=v3d.y + offsetY;
					i++;
				}
			}
		}
	}
}
