/**
 * Copyright axcel_work ( http://wonderfl.net/user/axcel_work )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pb6p
 */

package {
    import com.bit101.components.HUISlider;
    import com.bit101.components.PushButton;

    import org.si.sion.SiONDriver;
    import org.si.sion.events.SiONTrackEvent;
    import org.si.sound.DrumMachine;

    import flash.display.Loader;
    import flash.display.MovieClip;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.ProgressEvent;
    import flash.net.URLLoader;
    import flash.net.URLLoaderDataFormat;
    import flash.net.URLRequest;
    import flash.system.ApplicationDomain;
    import flash.system.LoaderContext;
    import flash.utils.ByteArray;

    [SWF(width="465", height="465", backgroundColor="0x0", frameRate="30")]

    /**
     * @author axcelwork
     */
    public class Index extends Sprite {
        private var _sionDriver:SiONDriver;
        private var _sionDrum:DrumMachine;

        private var _loader:Loader;
        private var _urlLoader:URLLoader = new URLLoader();

        private var _progressBar:Sprite = new Sprite();
        private var _movie:MovieClip;
        private var _currentFrame:int = 0;
        private var _maxFrame:int;
        private var _isPlay:Boolean = false;

        // Compornet
        private var seekSlider:HUISlider;
        private var btnPlay:PushButton;
        private var frameSlider:HUISlider;
        private var beatSlider:HUISlider;

        /**
         * 
         */
        public function Index() {
            if(stage) this.atInit();
            else this.addEventListener(Event.ADDED_TO_STAGE, atInit);
        }

        private function atInit(e:Event = null):void {
            this._sionDriver = new SiONDriver();
            this._sionDriver.setBeatCallbackInterval(4);
            
            this._sionDrum = new DrumMachine(0, 0, 0, 0, 0, 0);
            
            this._progressBar.graphics.beginFill(0xFFFFFF);
            this._progressBar.graphics.drawRect(0, 0, this.stage.stageWidth, 1);
            this._progressBar.graphics.endFill();
            this._progressBar.scaleX = 0;
            this._progressBar.y = Math.round(this.stage.stageHeight / 2);
            this.addChild(this._progressBar);
            
            this._urlLoader.dataFormat = URLLoaderDataFormat.BINARY;
            this._urlLoader.addEventListener(Event.COMPLETE, swfBynaryComplete);
            this._urlLoader.load(new URLRequest("http://shift-style.org/labo/sion/movie_nhk.swf"));
        }

        private function swfBynaryComplete(e:Event):void {
            var context:LoaderContext = new LoaderContext(true);
            context.applicationDomain = ApplicationDomain.currentDomain;
            
            var array:ByteArray = e.target.data;
            
            this._loader = new Loader();
            this._loader.contentLoaderInfo.addEventListener(ProgressEvent.PROGRESS, progress);
            this._loader.contentLoaderInfo.addEventListener(Event.COMPLETE, complete);
            
            this._loader.loadBytes(array);
        }

        private function progress(e:ProgressEvent):void {
            this._progressBar.scaleX = e.bytesLoaded / e.bytesTotal;
        }

        private function complete(e:Event):void {
            this._movie = this._loader.contentLoaderInfo.content as MovieClip;
            this._maxFrame = this._movie.totalFrames;
            
            this.addChild(this._movie);
            this.seekSlider = new HUISlider(this, 0, 370, "", changeSeek);
            this.seekSlider.width = 495;
            this.seekSlider.maximum = 804;
            this.seekSlider.labelPrecision = 0;

            this.btnPlay = new PushButton(this, 10, 400, "Play", clickPlay);
            this.btnPlay.width = 50;
            this.btnPlay.toggle = true;

            this.frameSlider = new HUISlider(this, 90, 400, "Frame");
            this.frameSlider.width = 208;
            this.frameSlider.value = 10;
            this.frameSlider.labelPrecision = 0;

            this.beatSlider = new HUISlider(this, 280, 400, "Beat", changeBeat);
            this.beatSlider.maximum = 16;
            this.beatSlider.value = 4;
            this.beatSlider.labelPrecision = 0;
            /*
            */
        }

        protected function changeSeek(e:Event):void {
            this._movie.gotoAndStop(this.seekSlider.value);
            this._currentFrame = this.seekSlider.value;
        }

        protected function clickPlay(e:Event = null):void {
            this._isPlay = !this._isPlay;
            
            if(this._isPlay) {
                this.btnPlay.label = "Stop";
                this._sionDriver.addEventListener(SiONTrackEvent.BEAT, beatOn);
                this._sionDriver.play();
                this._sionDrum.play();
            } else {
                this._movie.gotoAndStop(0);
                this.seekSlider.value = this._movie.currentFrame;
                this._currentFrame = 0;
                
                this.btnPlay.label = "Play";
                this._sionDriver.removeEventListener(SiONTrackEvent.BEAT, beatOn);
                this._sionDriver.stop();
                this._sionDrum.stop();
            }
        }

        protected function changeBeat(e:Event):void {
            this._sionDriver.setBeatCallbackInterval(this.beatSlider.value);
        }

        private function beatOn(e:SiONTrackEvent):void {
            this._currentFrame += this.frameSlider.value;
            
            if(this._currentFrame > this._maxFrame) {
                clickPlay();
            }
            else{
                this.seekSlider.value = this._movie.currentFrame;
                this._movie.gotoAndStop(this._currentFrame);
            }
            
        }
    }
}
