/**
 * Copyright Tamanegi_kenshi ( http://wonderfl.net/user/Tamanegi_kenshi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pahu
 */

package {
    import flash.display.Sprite;
    import flash.events.Event;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.scenes.Scene3D;
    import org.papervision3d.cameras.Camera3D;
    import org.papervision3d.render.BasicRenderEngine;
    import org.papervision3d.view.Viewport3D;
    import org.papervision3d.materials.ColorMaterial;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.materials.BitmapFileMaterial;
    
    
    [SWF(backgroundColor = "#000000")]
    
    
    public class FlashTest extends Sprite {
        
        private var camera:Camera3D;
        private var view:Viewport3D;
        private var scene:Scene3D;
        private var renderer:BasicRenderEngine;
        private var plane:Plane;
        private var plane2:Plane;
        private var rootOB:DisplayObject3D;
        private var planeArr:Array = [];
        
        private var angle:int = 0;
        private var angle2:int = 0;
        private var rotetonAngle:int = 5;
        
        public function FlashTest() {
            init();   
        }
        private function init():void{
            camera = new Camera3D();
            scene = new Scene3D();
            view = new Viewport3D(465, 465);
            renderer = new BasicRenderEngine();
            
            camera.y = 150;
            addChild(view);
            
            var material:BitmapFileMaterial = new BitmapFileMaterial("images/cyo1.gif");
            material.doubleSided = true;
            plane = new Plane(material, 100, 150);
            planeArr.push(plane);
            
            var material2:BitmapFileMaterial = new BitmapFileMaterial("images/cyo2.gif");
            material2.doubleSided = true;
            plane2 = new Plane(material2, 100, 150);
            planeArr.push(plane2);
            
            rootOB = new DisplayObject3D();
            rootOB.addChild(plane);
            rootOB.addChild(plane2);
            rootOB.rotationX = 90;
            //rootOB.rotationY = 90;
            
            plane2.x = 100;
            
            addEventListener(Event.ENTER_FRAME, rootEnter);
            
            scene.addChild(rootOB);
        }//init
        
        private function rootEnter(e:Event):void{
            angle2 += 2;
            var radian:Number = angle2 * Math.PI / 180;
            rootOB.z = Math.cos(radian) * 350;
            rootOB.x= Math.sin(radian) * 350;
            renderer.renderScene(scene, camera, view);
            rootOB.rotationY = 90 +angle2;
            planeEnter();
            onOri();
        }
        
        private function planeEnter():void{
            var radian:Number = angle * Math.PI / 180;
        
        //planeNumの回数繰り返す
        for(var i:int = 0; i < planeArr.length; i++){
        
        //コサインで底辺の長さx1を求める
        var x1:Number = Math.cos(radian) *  100;
        
        //var z1:Number = Math.sin(radian) * 100;

        //planの位置を設定する
        //rootNodeをステージ真ん中に配置するために,（底辺の長さの半分をplaneNumから1を引いた数でかけてマイナスにす)
        //　＋　底辺の長さとplaneNumの数をかける
        planeArr[i].x = (-x1 / 2 * planeArr.length - 1) + x1 * i;
        
        
        //もし、iが2で割り切れる場合
        if(i % 2 == 0){
        
            //planeの角度はそのまま
            planeArr[i].rotationY = angle;
        
        //それ以外(2で割り切らない場合)
        }else{
        
            //planeの角度は反対にする
            planeArr[i].rotationY = -angle;
        }//if
        }///for i
            
        }
        private function onOri():void{
        
        //angleを変数vaづつ増やす
        angle += rotetonAngle;
        
        //もし、anngleが90以上か-90以下なら
        if(angle >= 60 || angle <= -60){
        
        //変数vaに-1をかける
        rotetonAngle *= -1;
        }
    }



    }//class
}//package