/**
 * Copyright romatica ( http://wonderfl.net/user/romatica )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pZej
 */

// forked from rettuce's Butterfly Sound
/**
 *  @author itoz ( http://www.romatica.com/ )
 *  フォーク元 [butterfly sound ]　http://wonderfl.net/c/8xSc
 *  
 *  - 音はTsabeat より拝借
 *  - http://www.ektoplazm.com/2010/highpersonic-whomen-alternative-energysource
 */
package 
{
    import flash.geom.Point;
    import flash.display.Shape;
    import flash.display.MovieClip;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.media.Sound;
    import flash.media.SoundChannel;
    import flash.net.URLRequest;
    import flash.media.SoundMixer;
    import flash.utils.ByteArray;
    import flash.media.SoundLoaderContext; 
    
    public class SpaceButterflySound extends MovieClip 
    {
        private var _bg:Sprite;
        private var _sound:Sound;
        private var _channel:SoundChannel;
        private var _byteArray:ByteArray;
        private var _rectArray1:Vector.<Shape>;
        private var _rectArray2 : Vector.<Shape>;
        private var _radius:Number;
        
        private var _flg:Boolean = true;
        private var _bold : Number = 10 ;
        private var _keisu : Number = 5;
        private var _count : int;
        private var _star : StarDust;
        private var _wrap : Sprite;
        private var sw : int;
        private var sh : int;
        private var scx : Number;
        private var scy : Number;
        
        public function SpaceButterflySound()
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init );
        }
        
        private function init(e:Event = null ):void
        {
            removeEventListener(Event.ADDED_TO_STAGE, init );
            
            sw =stage.stageWidth;
            sh =stage.stageHeight;
            scx=sw/2;
            scy=sh/2;
            
            _byteArray = new ByteArray();
            _rectArray1 = _rectArray2 = new Vector.<Shape>();
            _count = 10;

            _radius = stage.stageHeight / 2.5;

            _bg = addChild( new Sprite() ) as Sprite;
            _bg.graphics.beginFill(0x0);
            _bg.graphics.drawRect(0,0,468,468);
            _bg.graphics.endFill();

            _star = addChild( new StarDust() ) as StarDust;
            _star.create(150);
            
            _wrap =addChild(new Sprite) as Sprite;
            _wrap.x =scx;
            _wrap.y =scy;
            _rectArray1 = soundRectSet( _radius * 1.1 , -_bold * 1.3 );
            _rectArray2 = soundRectSet( _radius * 2   , -_bold * 4 );
            
            soundSet();
            
            addEventListener(Event.ENTER_FRAME, update );
        }
      
        private function soundRectSet(rad:Number,yy:Number):Vector.<Shape>
        {           
            var vec:Vector.<Shape> = new Vector.<Shape>();
            for (var i:int = 0; i < 1024; i++) {
                var rect:Shape = _wrap.addChild(newRect(yy)) as Shape;
                rect.alpha  = 0.3;
                rect.width  = sw / 256;
                rect.height = sh / 512;
                var p:Point = Point.polar(rad,(((360 / 1024) * i+90)* Math.PI / 180));
                rect.x = p.x;
                rect.y = p.y;
                rect.rotation = (360 / 1024) * i ;
                rect.scaleY =Math.random()*1+0.5;
                vec.push(rect);
            }
            return vec;
        }
        
        private function soundSet():void 
        {
            _sound = new Sound();
            _sound.addEventListener(Event.COMPLETE, onSoundLoaded,false,0,true);
            _sound.load(new URLRequest("http://rettuce.com/material/mp3/PieceOfCake.mp3"), 
                        new SoundLoaderContext(1000, true));
            _channel = _sound.play( 0, 1 );
        }

        private function onSoundLoaded(event : Event) : void 
        {
             _sound.removeEventListener(Event.COMPLETE, onSoundLoaded);
             //
        }
        
 
        private function newRect(yy : Number) : Shape
        {
            var rect : Shape = new Shape();
            rect.graphics.beginFill( 0xff * Math.random() * 0xff * Math.random() );
            rect.graphics.drawRect( 0, yy, _bold, _bold );
            rect.graphics.endFill();
            return rect;
        }

        private function update(e : Event) : void
        {
            soundAnimation( _rectArray1, _flg );
            soundAnimation( _rectArray2, !_flg );
        }

        private function soundAnimation(arr : Vector.<Shape>, flag : Boolean) : void
        {
            SoundMixer.computeSpectrum( _byteArray, flag, _count );
            for (var i : int = 0; i < 512; i += 2) {
                var n : int = 1023 - i;
                var numL:Number = _byteArray.readFloat() * _keisu +1.4;
                arr[i].scaleY     = numL;
                arr[i+1].scaleY = numL;
                arr[n].scaleY     = numL;
                arr[n-1].scaleY = numL;
            }
        }

        public function get _sh() : int {
            return sh;
        }

        public function set _sh(sh : int) : void {
            this.sh = sh;
        }
    }
}
import flash.display.Sprite;
import flash.events.Event;

class StarDust extends Sprite
{
    private const _fl : int = 5000;
    private var _vpx : int;
    private var _vpy : int;
    private var _starVec : Vector.<Star> 

    public function StarDust()
    {
        setVp();
    }

    public function create(allNum : int) : void
    {
        _starVec  = new Vector.<Star>();
        for (var i : int = 0; i < allNum; i++) {
            var s : Star = addChild( new Star() ) as Star;
            s.graphics.beginFill( 0xaaaaaa  );
            s.graphics.drawCircle( 0, 0, 1.5);
            s.setPosition(Math.floor( Math.random() * 1000 - Math.random() * 1500 )
                        , Math.floor( Math.random() * 1000 - Math.random() * 500 )
                        , Math.floor( Math.random() * 8000 - Math.random() * 16000 ));
            s._speed = Math.floor( Math.random() * 50+100 );
            _starVec.push(s);
        }
        addEventListener( Event.ENTER_FRAME, moveStars );
    }

    private function moveStars(e : Event) : void
    {
        var i:int =0;
        var max:int = _starVec.length;
        for ( i  = 0; i < max; i++) {
            var s : Star = _starVec[i] as Star;
            s.zz -= s._speed;
            s.rota();
            if (s.zz <= -_fl) {
                s.setPosition( s.xx,s.yy,16000 );
                s._speed = Math.floor( Math.random() * 50+100 );
            } else {
                var scale : Number = _fl / (_fl + s.zz);
                s.scaleX = s.scaleY = scale * 1.1;
                s.x = _vpx + s.xx * scale;
                s.y = _vpy + s.yy * scale;
            }
        }
    }

    private function setVp() : void
    {
        _vpx = 468 / 2;
        _vpy = 468 / 2;
    }
}
import flash.display.Shape;

class Star extends Shape
{
    public var xx : Number;
    public var yy : Number;
    public var zz : Number;
    public var _speed : Number;
    
    private var leng : Number;
    private var radian : Number;

    public function Star(){}
    
    public function setPosition(_xx : Number , _yy : Number , _zz : Number ) : void
    {
        xx = _xx;
        yy = _yy;
        zz = _zz;
        radian = Math.atan2( xx, yy );
    }

    public function rota() : void
    {
        leng = Math.sqrt(xx*xx +yy*yy);
        radian +=_speed/5000;
        xx = Math.sin(radian)*leng;
        yy = Math.cos(radian)*leng;
    
    }
}