/**
 * Copyright echo ( http://wonderfl.net/user/echo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pZKw
 */

// forked from checkmate's Checkmate Vol.6 Sponser
package {
    import flash.display.*;
    import flash.events.*;
    
    import org.libspark.betweenas3.*;
    import org.libspark.betweenas3.tweens.ITween;
    //[SWF(backgroundColor=0x3399ff)]
    public class Sponser extends Sprite {
        private var robo:Robo;
        public function Sponser() {
            addChild(new BlueSheet());
            
            for( var i:int = 0; i<5; ++i ) {
                robo = new Robo( 8, true, true );
                robo.load();
            
                addChild(robo);
                var t:ITween = BetweenAS3.tween( robo, { x : i*20 - 5*20, y: 320 - i*20 }, { x:465 + i*20, y: 320 - i*20 }, 8 );
                t.stopOnComplete = false;
                t.play();
            }
        }
    }
}
import flash.display.*;
import flash.events.*;
import flash.net.*;
import flash.geom.*;
import flash.system.*;
class BlueSheet extends Shape {
    public function BlueSheet(){
        graphics.beginFill(0x3399ff);
        graphics.drawRect(0,0,465,465);
        graphics.endFill();
    }
}
class Robo extends Sprite {
    public static const READY:String = "READY";
    public var imgSrc:String = "http://assets.dev.wonderfl.net/images/related_images/e/ea/ea8a/ea8a6b1d37c2cec12e07893c66f164a9da1e92c0";
    
    private var _loader:Loader;
    private var _frame:Bitmap;
    
    public var frames:Array;
    private var _currentFrame:int = 0;
    private var _totalFrames:int = 0;
    
    private var _frameRate:int = 8;
    private var _autoPlay:Boolean = false;
    public function Robo( frameRate:int = 8, autoPlay:Boolean = false, autoLoad:Boolean = false ){
        _frameRate = frameRate;
        _autoPlay = autoPlay;
        
       // if( autoLoad ) load();
    }
    public function load():void {
        _loader = new Loader();
        
        _loader.contentLoaderInfo.addEventListener( Event.COMPLETE, completeHandler );
        _loader.load( new URLRequest(imgSrc), new LoaderContext(true) );
    }
    private function completeHandler(e:Event):void {
        var bmp:BitmapData = Bitmap( _loader.content ).bitmapData;
        _loader.contentLoaderInfo.removeEventListener( Event.COMPLETE, completeHandler );
        _loader= null;
        
        _frame = new Bitmap();
        addChild( _frame );
        
        frames = [];
        
        const frameWidth:int = 20;
        const frameHeight:int = 34;
        
        var numFrames:int = bmp.width/frameWidth;
        for( var i:int=0; i< numFrames; ++i ) {
            for( var f:int=0; f<_frameRate; ++f ) {
                var frame:BitmapData = new BitmapData( frameWidth, frameHeight, true, 0 );
                var matrix:Matrix = new Matrix();
                matrix.translate( -i*frameWidth, 0 );
                frame.draw( bmp, matrix );
                frames.push( frame );
            }
        }
        _totalFrames = frames.length;
        
        update();
        
        dispatchEvent( new Event(READY) );
        
        if( _autoPlay ) play();
    }
    
    private function update(e:Event=null):void {
        _frame.bitmapData = frames[_currentFrame]
        _currentFrame = (_currentFrame+1) % _totalFrames;
    }
    
    public function play():void {
        if( isReady )
            addEventListener( Event.ENTER_FRAME, update );
    }
    public function stop():void {
        removeEventListener( Event.ENTER_FRAME, update );
    }
    
    public function get currentFrame():int { return _currentFrame+1; }
    public function get totalFrames():int { return _totalFrames; }
    
    public function get isReady():Boolean {
        return frames && frames.length>0;
    }
    
}