/**
 * Copyright ile ( http://wonderfl.net/user/ile )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pYcK
 */

package {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.display.Loader;
    import flash.net.URLRequest;
    import flash.system.Security;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Rectangle;
    [SWF(width = "350",height = "350")]
    public class Main extends Sprite {
        private const WIDTH:Number = 35;
        private const HEIGHT:Number = 35;
        private var yPanel:uint = 10;
        private var xPanel:uint = 10;
        private var yobiPanel:uint = 5;
        private var baseX:Number = 0;
        private var baseY:Number = 0;
        private var dragOnX:Number;
        private var dragOnY:Number;
        private var dragTate:uint;
        private var dragYoko:uint;
        private var loopFlg:int = 0;
        private var gameBoard:Array = new Array();
        private var copyPanelS1:Array = new Array();
        private var copyPanelS2:Array = new Array();
        private var roadColor:Array = new Array();
        private var usedRoad:Array = new Array();

        private var swfLoader:Loader;
        private var panelClsArr:Array = new Array();

        public function Main() {
            loadPanel();
        }

        private function loadPanel():void {
            var url:String = "http://ile.jp/wp-content/uploads/2011/11/panel1.swf";
            var urlReq:URLRequest;

            Security.allowDomain("*");
            swfLoader = new Loader();
            urlReq = new URLRequest(url);
            swfLoader.contentLoaderInfo.addEventListener(Event.COMPLETE, setPanels);
            swfLoader.load(urlReq);
        }
        private function setPanels(event:Event):void {
            //0,emp　1,┘　2,┐　3,─　4,└　5,┌　6,│　
            panelClsArr[0] = swfLoader.contentLoaderInfo.applicationDomain.getDefinition("panelKL_mc") as Class;
            panelClsArr[1] = swfLoader.contentLoaderInfo.applicationDomain.getDefinition("panelMS_mc") as Class;
            panelClsArr[2] = swfLoader.contentLoaderInfo.applicationDomain.getDefinition("panelMU_mc") as Class;
            panelClsArr[3] = swfLoader.contentLoaderInfo.applicationDomain.getDefinition("panelYK_mc") as Class;
            panelClsArr[4] = swfLoader.contentLoaderInfo.applicationDomain.getDefinition("panelHS_mc") as Class;
            panelClsArr[5] = swfLoader.contentLoaderInfo.applicationDomain.getDefinition("panelHU_mc") as Class;
            panelClsArr[6] = swfLoader.contentLoaderInfo.applicationDomain.getDefinition("panelTT_mc") as Class;
            for (var i:uint = 0; i < yPanel; i++) {
                gameBoard[i] = new Array();
                for (var j:uint = 0; j < xPanel; j++) {
                    loopFlg = 0;
                    
                    var r:uint = Math.floor(Math.random() * 6) + 1;
                    //調整adjusting
                    if(r==1||r==2||r==4||r==5)r=Math.floor(Math.random() * 6) + 1;
                    //if(r==1||r==2||r==4||r==5)r=Math.floor(Math.random() * 6) + 1;
                    
                    var panel:PanelMaker = new PanelMaker(panelClsArr,WIDTH * j + baseX,HEIGHT * i + baseY,r,1,i,j);
                    addChild(panel);
                    panel.addEventListener(MouseEvent.MOUSE_DOWN, startDragging);
                    gameBoard[i][j] = panel;

                }
                trace(gameBoard[i][0].panelType+" "+gameBoard[i][1].panelType+" "+gameBoard[i][2].panelType+" "+gameBoard[i][3].panelType+" "+gameBoard[i][4].panelType+" "+gameBoard[i][5].panelType+" "+gameBoard[i][6].panelType+" "+gameBoard[i][7].panelType+" "+gameBoard[i][8].panelType+" "+gameBoard[i][9].panelType);
            }
            coloring();
        }
        private function startDragging(event:MouseEvent):void {
            var panel:PanelMaker = event.currentTarget as PanelMaker;
            dragTate = panel.tate;
            dragYoko = panel.yoko;
            // mouseの座標を取得
            dragOnX = stage.mouseX;
            dragOnY = stage.mouseY;
            stage.addEventListener(MouseEvent.MOUSE_UP, stopMove);
            stage.addEventListener(MouseEvent.MOUSE_MOVE, wayGet);
            function stopMove(event:MouseEvent):void {
                //panel.stopDrag();
                stage.removeEventListener(MouseEvent.MOUSE_UP, stopMove);
                stage.removeEventListener(MouseEvent.MOUSE_MOVE, dragLine);
                stage.removeEventListener(MouseEvent.MOUSE_MOVE, wayGet);
                dragOnX = panel.x;
                ichiAwase();
            }
            function wayGet(e:MouseEvent):void {
                var tate:uint = dragTate;
                var yoko:uint = dragYoko;
                var yuyo:uint = 7;
                var i:uint;
                var j:uint;
                var r:uint;
                var copyPanel1:PanelMaker;
                var copyPanel2:PanelMaker;
                var rCol:uint;
                var loopNum:uint;

                //move direction 1,Horizontal/2,Vertical
                if (loopFlg == 1) {
                    i = tate;
                    stage.removeEventListener(MouseEvent.MOUSE_MOVE, wayGet);
                    dragOnX = stage.mouseX;
                    dragOnY = stage.mouseY;
                    stage.addEventListener(MouseEvent.MOUSE_MOVE, dragLine);
                    //copy& rightleft move
                    for (j = 0; j < xPanel; j++) {
                        //タイプ継承
                        r = gameBoard[tate][j].panelType;
                        //フレーム継承
                        loopNum = usedRoad[tate][j];
                        rCol = roadColor[loopNum];
                        //左
                        copyPanel1 = new PanelMaker(panelClsArr,WIDTH * j + baseX - WIDTH * xPanel,HEIGHT * i + baseY,r,rCol,i,j);
                        addChild(copyPanel1);
                        copyPanelS1[j] = copyPanel1;
                        //右
                        copyPanel2 = new PanelMaker(panelClsArr,WIDTH * j + baseX + WIDTH * xPanel,HEIGHT * i + baseY,r,rCol,i,j);
                        addChild(copyPanel2);
                        copyPanelS2[j] = copyPanel2;
                    }
                } else if (loopFlg == 2) {
                    i = yoko;
                    stage.removeEventListener(MouseEvent.MOUSE_MOVE, wayGet);
                    dragOnX = stage.mouseX;
                    dragOnY = stage.mouseY;
                    stage.addEventListener(MouseEvent.MOUSE_MOVE, dragLine);
                    //copy& updown move
                    for (j = 0; j < yPanel; j++) {
                        //タイプ継承
                        r = gameBoard[j][yoko].panelType;
                        //フレーム継承
                        loopNum = usedRoad[j][yoko];
                        rCol = roadColor[loopNum];
                        //左
                        copyPanel1 = new PanelMaker(panelClsArr,WIDTH * i + baseX,HEIGHT * j + baseY - HEIGHT * yPanel,r,rCol,j,i);
                        addChild(copyPanel1);
                        copyPanelS1[j] = copyPanel1;
                        //右
                        copyPanel2 = new PanelMaker(panelClsArr,WIDTH * i + baseX,HEIGHT * j + baseY + HEIGHT * yPanel,r,rCol,j,i);
                        addChild(copyPanel2);
                        copyPanelS2[j] = copyPanel2;
                    }
                } else {

                    if (stage.mouseX > dragOnX + yuyo) {
                        //right
                        loopFlg = 1;
                    } else if (stage.mouseX < dragOnX - yuyo) {
                        //left
                        loopFlg = 1;
                    } else if (stage.mouseY > dragOnY + yuyo) {
                        //down
                        loopFlg = 2;
                    } else if (stage.mouseY < dragOnY - yuyo) {
                        //up
                        loopFlg = 2;
                    }
                }

            }
        }

        //Align
        private function ichiAwase():void {
            var tate:uint = dragTate;
            var yoko:uint = dragYoko;
            var xx:Number = 0;
            var nh:uint;
            var i:uint;
            var slideCnt:Number;
            //type save
            var bMemo:Array = new Array();

            if (loopFlg == 1) {
                if (gameBoard[tate][0].x >= baseX) {
                    xx = gameBoard[tate][0].x - baseX + WIDTH / 2;
                } else {
                    xx = (gameBoard[tate][0].x *-1)+ baseX + WIDTH / 2;
                }
                nh = Math.floor(xx / WIDTH);
                slideCnt = nh % xPanel;
                for (i = 0; i < xPanel; i++) {
                    bMemo[i] = gameBoard[tate][i].panelType;
                }
            } else if (loopFlg == 2) {
                if (gameBoard[0][yoko].y >= baseY) {
                    xx = gameBoard[0][yoko].y - baseY + HEIGHT / 2;
                } else {
                    xx = (gameBoard[0][yoko].y *-1)+ baseY + HEIGHT / 2;
                }
                nh = Math.floor(xx / HEIGHT);
                slideCnt = nh % yPanel;
                for (i = 0; i < yPanel; i++) {
                    bMemo[i] = gameBoard[i][yoko].panelType;
                }
            }

            //panel subst
            i = 0;
            var j:uint;
            var num:Number;
            if (loopFlg == 1) {
                for (j = 0; j < xPanel; j++) {
                    num = 0;
                    if (gameBoard[tate][0].x >= baseX) {
                        //right
                        if (j < slideCnt) {
                            num = xPanel - Number(slideCnt) + Number(j);
                            gameBoard[tate][j].panelType = bMemo[num];
                        } else {
                            gameBoard[tate][j].panelType = bMemo[i];
                            i++;
                        }
                    } else {
                        //left
                        if (j < xPanel - slideCnt) {
                            num = Number(slideCnt) + Number(j);
                            gameBoard[tate][j].panelType = bMemo[num];
                        } else {
                            gameBoard[tate][j].panelType = bMemo[i];
                            i++;
                        }
                    }
                }
            } else if (loopFlg==2) {
                for (j = 0; j < yPanel; j++) {
                    num = 0;
                    if (gameBoard[0][yoko].y >= baseY) {
                        //down
                        if (j < slideCnt) {
                            num = yPanel - Number(slideCnt) + Number(j);
                            gameBoard[j][yoko].panelType = bMemo[num];
                        } else {
                            gameBoard[j][yoko].panelType = bMemo[i];
                            i++;
                        }
                    } else {
                        //up
                        if (j < yPanel - slideCnt) {
                            num = Number(slideCnt) + Number(j);
                            gameBoard[j][yoko].panelType = bMemo[num];
                        } else {
                            gameBoard[j][yoko].panelType = bMemo[i];
                            i++;
                        }
                    }
                }
            }
            //del align
            if (loopFlg == 1) {
                for (j = 0; j < xPanel; j++) {
                    gameBoard[tate][j].x = j * WIDTH + baseX;
                    gameBoard[tate][j].frame = 1;

                    removeChild(copyPanelS1[j]);
                    removeChild(copyPanelS2[j]);
                    loopFlg = 0;
                }
            } else if (loopFlg==2) {
                for (j = 0; j < yPanel; j++) {
                    gameBoard[j][yoko].y = j * HEIGHT + baseY;
                    gameBoard[j][yoko].frame = 1;

                    removeChild(copyPanelS1[j]);
                    removeChild(copyPanelS2[j]);
                    loopFlg = 0;
                }
            }

            coloring();

        }

        //loop check & Colouring
        private function coloring():void {
            var j:uint;
            var i:uint;
            var yi:int;
            var xj:int;
            var arrown:uint;
            var loopNum:uint = 1;
            var nextpanelType:uint;

            var searchFlg:Boolean = true;
            //配列の初期化 一度調べた道は調べない(最後は省く)
            for (i = 0; i < yPanel; i++) {
                usedRoad[i] = new Array();

                for (j = 0; j < xPanel; j++) {
                    //未開のパネル
                    usedRoad[i][j] = 0;
                }
            }


            //link of ALL Unuse panel
            for (i = 0; i < yPanel; i++) {
                for (j = 0; j < xPanel; j++) {
                    //他のループが通ってないとき
                    if (usedRoad[i][j] == 0) {

                        //ベース方向その１

                        //ベースパネル i=y j=x
                        nextpanelType = gameBoard[i][j].panelType;
                        usedRoad[i][j] = loopNum;
                        roadColor[loopNum] = 2;
                        yi = i;
                        xj = j;

                        //arrown 0N 1A 2> 3V 4<

                        if (nextpanelType == 1) {
                            //上 進む方向とパネル（繋がっているかはまだ不明）
                            arrown = 1;
                            yi -=  1;
                        } else if (nextpanelType == 2) {
                            //左
                            arrown = 4;
                            xj -=  1;
                        } else if (nextpanelType == 3) {
                            //左
                            arrown = 4;
                            xj -=  1;
                        } else if (nextpanelType == 4) {
                            //上
                            arrown = 1;
                            yi -=  1;
                        } else if (nextpanelType == 5) {
                            //下
                            arrown = 3;
                            yi +=  1;
                        } else if (nextpanelType==6) {
                            //上
                            arrown = 1;
                            yi -=  1;
                        } else {
                            //空パネル
                            arrown = 0;
                        }

                        ijRange();

                        if (usedRoad[yi][xj] == 0 && arrown != 0) {

                            loopSearch();

                        }

                        //ベース方向その２  るーぷしなかったら

                        //ベースパネル i=y j=x
                        nextpanelType = gameBoard[i][j].panelType;
                        yi = i;
                        xj = j;

                        if (nextpanelType == 1) {
                            //左
                            arrown = 4;
                            xj -=  1;
                        } else if (nextpanelType == 2) {
                            //下
                            arrown = 3;
                            yi +=  1;
                        } else if (nextpanelType == 3) {
                            //右
                            arrown = 2;
                            xj +=  1;
                        } else if (nextpanelType == 4) {
                            //右
                            arrown = 2;
                            xj +=  1;
                        } else if (nextpanelType == 5) {
                            //右
                            arrown = 2;
                            xj +=  1;
                        } else if (nextpanelType==6) {
                            //下
                            arrown = 3;
                            yi +=  1;
                        } else {
                            //空パネル
                            arrown = 0;
                        }

                        ijRange();

                        if (usedRoad[yi][xj] == 0 && arrown != 0) {

                            loopSearch();

                        }

                        loopNum++;

                    }
                }
            }

            //color frame change
            for (i = 0; i < yPanel; i++) {
                trace("usedRoadARR"+i+"="+usedRoad[i]);
                for (j = 0; j < xPanel; j++) {
                    loopNum = usedRoad[i][j];
                    var rCol:uint = roadColor[loopNum];
                    gameBoard[i][j].frame = rCol;
                }

            }

            function ijRange():void {
                //edge looprule
                if (yi < 0) {
                    yi = yPanel - 1;
                } else if (yi > yPanel - 1) {
                    yi = 0;
                }
                if (xj < 0) {
                    xj = xPanel - 1;
                } else if (xj > xPanel - 1) {
                    xj = 0;
                }
            }

            function loopSearch():void {
                //follow to roadend
                searchFlg = true;
                do {
                    if (usedRoad[yi][xj] == 0) {
                        //次のパネルが未使用の時

                        //次のパネルのタイプ
                        nextpanelType = gameBoard[yi][xj].panelType;
                        //来た方向が次のパネルのタイプに繋がるか
                        if (arrown == 1) {
                            //上　２５６
                            if (nextpanelType == 2) {
                                //繋がっていたので、ルート番号をふる
                                usedRoad[yi][xj] = loopNum;
                                //道に沿って次に進む方向
                                arrown = 4;
                                //まだ繋がっているかわからないが次のパネル
                                xj -=  1;
                            } else if (nextpanelType == 5) {
                                usedRoad[yi][xj] = loopNum;
                                arrown = 2;
                                xj +=  1;
                            } else if (nextpanelType == 6) {
                                usedRoad[yi][xj] = loopNum;
                                arrown = 1;
                                yi -=  1;
                            } else {
                                //繋がらないか空パネル
                                arrown = 0;
                            }

                        } else if (arrown == 2) {
                            //右　１２３
                            if (nextpanelType == 1) {
                                usedRoad[yi][xj] = loopNum;
                                arrown = 1;
                                yi -=  1;
                            } else if (nextpanelType == 2) {
                                usedRoad[yi][xj] = loopNum;
                                arrown = 3;
                                yi +=  1;
                            } else if (nextpanelType == 3) {
                                usedRoad[yi][xj] = loopNum;
                                arrown = 2;
                                xj +=  1;
                            } else {
                                arrown = 0;
                            }

                        } else if (arrown == 3) {
                            //下　１４６
                            if (nextpanelType == 1) {
                                usedRoad[yi][xj] = loopNum;
                                arrown = 4;
                                xj -=  1;
                            } else if (nextpanelType==4) {
                                usedRoad[yi][xj] = loopNum;
                                arrown = 2;
                                xj +=  1;
                            } else if (nextpanelType == 6) {
                                usedRoad[yi][xj] = loopNum;
                                arrown = 3;
                                yi +=  1;
                            } else {
                                arrown = 0;
                            }

                        } else if (arrown == 4) {
                            //左　３４５
                            if (nextpanelType == 3) {
                                usedRoad[yi][xj] = loopNum;
                                arrown = 4;
                                xj -=  1;
                            } else if (nextpanelType == 4) {
                                usedRoad[yi][xj] = loopNum;
                                arrown = 1;
                                yi -=  1;
                            } else if (nextpanelType == 5) {
                                usedRoad[yi][xj] = loopNum;
                                arrown = 3;
                                yi +=  1;
                            } else {
                                arrown = 0;
                            }
                        } else {
                            arrown = 0;
                        }

                        ijRange();

                        if (arrown != 0) {
                            //ルート色UP
                            roadColor[loopNum]++;
                        } else {
                            //つながらない
                            searchFlg = false;
                        }
                    } else if (i==yi&&j==xj) {
                        //使用済みだが元のパネルなのでループするかも

                        //どちらにせよルート検索終了
                        searchFlg = false;

                        //元のパネルのタイプ
                        nextpanelType = gameBoard[yi][xj].panelType;
                        //来た方向がループに繋がるか
                        if (arrown == 1) {
                            //上　２５６
                            if (nextpanelType == 2 || nextpanelType == 5 || nextpanelType == 6) {
                                roadColor[loopNum] = 1;

                            } else {
                                arrown = 0;
                            }
                        } else if (arrown == 2) {
                            //右　１２３
                            if (nextpanelType == 1 || nextpanelType == 2 || nextpanelType == 3) {
                                roadColor[loopNum] = 1;
                            } else {
                                arrown = 0;
                            }
                        } else if (arrown == 3) {
                            //下　１４６
                            if (nextpanelType == 1 || nextpanelType == 4 || nextpanelType == 6) {
                                roadColor[loopNum] = 1;
                            } else {
                                arrown = 0;
                            }
                        } else if (arrown == 4) {
                            //左　３４５
                            if (nextpanelType == 3 || nextpanelType == 4 || nextpanelType == 5) {
                                roadColor[loopNum] = 1;
                            } else {
                                arrown = 0;
                            }
                        } else {
                            arrown = 0;
                        }
                    } else {
                        //次のパネルが使用済み
                        searchFlg = false;
                    }
                } while (searchFlg);
            }

        }

        //drag/frame
        private function dragLine(e:MouseEvent):void {
            //[]vertical
            var tate:uint = dragTate;
            //[][]horizontal
            var yoko:uint = dragYoko;
            var moveDot:Number;
            var j:uint;

            if (loopFlg == 1) {

                moveDot = stage.mouseX - dragOnX;
                dragOnX = stage.mouseX;

                for (j = 0; j < xPanel; j++) {
                    //left
                    if (copyPanelS1[j].x + moveDot <  -  WIDTH * xPanel) {
                        copyPanelS1[j].x +=  WIDTH * xPanel * 3;
                    }
                    if (gameBoard[tate][j].x + moveDot <  -  WIDTH * xPanel) {
                        gameBoard[tate][j].x +=  WIDTH * xPanel * 3;
                    }
                    if (copyPanelS2[j].x + moveDot <  -  WIDTH * xPanel) {
                        copyPanelS2[j].x +=  WIDTH * xPanel * 3;
                    }

                    //right
                    if (copyPanelS1[j].x + moveDot > WIDTH * xPanel * 2) {
                        copyPanelS1[j].x -=  WIDTH * xPanel * 3;
                    }
                    if (gameBoard[tate][j].x + moveDot > WIDTH * xPanel * 2) {
                        gameBoard[tate][j].x -=  WIDTH * xPanel * 3;
                    }
                    if (copyPanelS2[j].x + moveDot > WIDTH * xPanel * 2) {
                        copyPanelS2[j].x -=  WIDTH * xPanel * 3;
                    }

                    //move
                    gameBoard[tate][j].x +=  moveDot;
                    copyPanelS1[j].x +=  moveDot;
                    copyPanelS2[j].x +=  moveDot;
                }

            } else if (loopFlg == 2) {

                moveDot = stage.mouseY - dragOnY;
                dragOnY = stage.mouseY;

                for (j = 0; j < yPanel; j++) {
                    //left
                    if (copyPanelS1[j].y + moveDot <  -  HEIGHT * yPanel) {
                        copyPanelS1[j].y +=  HEIGHT * yPanel * 3;
                    }
                    if (gameBoard[j][yoko].y + moveDot <  -  HEIGHT * yPanel) {
                        gameBoard[j][yoko].y +=  HEIGHT * yPanel * 3;
                    }
                    if (copyPanelS2[j].y + moveDot <  -  HEIGHT * yPanel) {
                        copyPanelS2[j].y +=  HEIGHT * yPanel * 3;
                    }

                    //right
                    if (copyPanelS1[j].y + moveDot > HEIGHT * yPanel * 2) {
                        copyPanelS1[j].y -=  HEIGHT * yPanel * 3;
                    }
                    if (gameBoard[j][yoko].x + moveDot > HEIGHT * yPanel * 2) {
                        gameBoard[j][yoko].x -=  HEIGHT * yPanel * 3;
                    }
                    if (copyPanelS2[j].y + moveDot > HEIGHT * yPanel * 2) {
                        copyPanelS2[j].y -=  HEIGHT * yPanel * 3;
                    }

                    //move
                    gameBoard[j][yoko].y +=  moveDot;
                    copyPanelS1[j].y +=  moveDot;
                    copyPanelS2[j].y +=  moveDot;
                }
            }
        }
    }
}


import flash.display.MovieClip;

class PanelMaker extends MovieClip {;
private var _panelType:uint;
private var _tate:uint;
private var _yoko:uint;
private var _frame:uint;
private var testCls:Class;
private var panelMcArr:Array = new Array();

public function PanelMaker(panelClsArr:Array, x:Number, y:Number, panelType:uint, frame:uint , tate:int, yoko:int):void {
    this.x = x;
    this.y = y;
    _panelType = panelType;
    _frame = frame;
    _tate = tate;
    _yoko = yoko;
    for (var i:uint=0; i<7; i++) {
        panelMcArr[i]= new panelClsArr[i]();
    }
    addChild(panelMcArr[_panelType]);
    panelMcArr[_panelType].gotoAndStop(_frame);
}
public function get tate():int {
    return _tate;
}
public function set tate(v:int):void {
    _tate = v;
}
public function get yoko():int {
    return _yoko;
}
public function set yoko(v:int):void {
    _yoko = v;
}
public function get panelType():uint {
    return _panelType;
}
public function set panelType(v:uint):void {
    removeChild(panelMcArr[_panelType]);
    _panelType = v;
    addChild(panelMcArr[_panelType]);
    this.panelMcArr[_panelType].gotoAndStop(1);
}
public function get frame():int {
    return panelMcArr[_panelType].currentFrame;
}
public function set frame(v:int):void {
    panelMcArr[_panelType].gotoAndStop(v);
}
}