/**
 * Copyright dakkie ( http://wonderfl.net/user/dakkie )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pXxU
 */

package {
	import flash.display.Sprite;
	import flash.events.Event;
	
	public class CaterPillar extends Sprite {
		private var balls:Array;
		private var numBalls:Number = 7;
		private var spring:Number = 0.1;
		private var friction:Number = 0.5;
		private var light:Number = 0.5;
		
		public function CaterPillar() {
			init();
		}
		
		private function init():void {
			balls = new Array();
			for (var i:uint = 0; i < numBalls; i++) {
				var ball:Ball = new Ball();
				addChild(ball);
				balls.push(ball);
			}
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
		}
		
		private function onEnterFrame(event:Event):void {
			graphics.clear();
			graphics.moveTo(mouseX, mouseY);
			moveBall(balls[0], mouseX, mouseY);
			
			for (var i:uint = 1; i < numBalls; i++) {
				var ballA:Ball = balls[i - 1];
				var ballB:Ball = balls[i];
				moveBall(ballB, ballA.x, ballA.y);
			}
		}
		
		private function moveBall(ball:Ball, targetX:Number, targetY:Number):void {
			ball.vx += (targetX - ball.x) * spring;
			ball.vy += (targetY - ball.y) * spring;
			ball.vy += light;
			ball.vx *= friction;
			ball.vy *= friction;
			ball.x += ball.vx;
			ball.y += ball.vy;
		}
	}
}


import flash.display.Sprite;

class Ball extends Sprite {
    public var vx:Number = 0;
    public var vy:Number = 0;
    public var radius:Number = 20;
     
    public function Ball(){
        init();
        }
        
        public function init():void {
            graphics.beginFill(0x00ff00);
            graphics.drawCircle(0,0,20);
            graphics.endFill();
            }
            }
            