/**
 * Copyright aruerula ( http://wonderfl.net/user/aruerula )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pXlG
 */

package
{
    import flash.display.Loader;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;
    import flash.system.Security;
    import com.bit101.components.ProgressBar;
    import com.bit101.components.Label;
 
    public class Main extends Sprite
    {
        private var count:int = 0;        // 読み込んだ画像数
        private var images:Array;        // 読み込んだ画像
        private var pbar:ProgressBar;     // プログレスバー 
        private var valueLabel:Label;    // 読み込み数を表示する
 
        private    const IMAGE_URL:Array =
        [
            "http://farm3.static.flickr.com/2205/2532926223_6b2745185b.jpg",
            "http://farm4.static.flickr.com/3372/3212206475_ec333b5c51.jpg",
            "http://farm1.static.flickr.com/24/53973269_1947656f3b.jpg",
            "http://farm4.static.flickr.com/3176/2605060584_559c1163d2.jpg",
            "http://farm3.static.flickr.com/2639/3788074641_e2fa4610ab.jpg",
            "http://farm1.static.flickr.com/233/535789866_d39e385c4e.jpg",
            "http://farm4.static.flickr.com/3472/3358943665_e06398e377.jpg",
            "http://farm4.static.flickr.com/3561/3467927336_0b72db14cb.jpg",
            "http://farm3.static.flickr.com/2200/2059143799_bd0f522dfe.jpg"
        ];
 
        public function Main()
        {
            images = new Array(IMAGE_URL.length);
            pbar = new ProgressBar(this, 182, 222);
            valueLabel = new Label(this, pbar.x + pbar.width + 10, pbar.y - 5, "0");
            var maxLabel:Label = new Label(this, valueLabel.x + 5, valueLabel.y, " / " + IMAGE_URL.length.toString());
 
            // crossdomain.xmlを読み込む
            Security.loadPolicyFile("http://farm3.static.flickr.com/crossdomain.xml");
 
            for (var i:int = 0; i < IMAGE_URL.length; i++)
            {
                var loader:Loader = new Loader();
                loader.contentLoaderInfo.addEventListener(Event.INIT, initHandler);
                loader.load(new URLRequest(IMAGE_URL[i]), new LoaderContext(true));
                loader.name = i.toString();
            }
        }
 
        private function initHandler(event:Event):void
        {
            images[event.currentTarget.loader.name] = event.currentTarget.loader;
            if (++count == IMAGE_URL.length) completeHandler();
            pbar.value = count / IMAGE_URL.length;
            valueLabel.text = count.toString();
        }
 
        private function completeHandler():void
        {
            var label:Label = new Label(this, 208, pbar.y + pbar.height + 5, "COMPLETE");
        }
    }
}
 