/**
 * Copyright utabi ( http://wonderfl.net/user/utabi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pX6i
 */

// forked from nengafl's nengafl


/////////////////////////////////////////////////////
//    プリローダー付きの画像読み込みクラス、ImageClip                        
/////////////////////////////////////////////////////
//
//    とにかくシンプルに書くだけで使える、外部画像ロードクラス
//    を目指しました。
//    基本、newしてlaodしてaddChildだけで動きます。
//    こだわりたい場合はスタイルシートまがいのものを指定できます。
//

package {

    import flash.text.*;
    import flash.display.*;
    import flash.events.*;


    [SWF(width=465, height=465, frameRate=30, backgroundColor=0x555555)]

    public class DocumentClass extends Sprite {


        public function DocumentClass() {
            
            var defaultURL:String = "http://kie.li/lab/images/paper_eva_thumb.jpg";
            //var defaultURL:String = ""; //よこなが
            //var defaultURL:String = "http://www.windowsthemes.info/wp-content/uploads/2009/04/tiger_2_vs_by__kol.jpg"; //たてなが
            //var defaultURL:String = "http://www.macupdate.com/images/icons/21515.png"; //ちいさい
            
            // imageStyle.typeは
            // "original" : 実寸のまま表示。左上が基準点になる。
            // "auto" : 縦または横、狭い方にあわせて表示
            // "trim center" : 実寸をかえずに、センター部分をトリミングして表示
            // "fit" : width x heightに強制的にあわせて表示
            // "show all" : 比率をかえずに、width x height 内におさめて表示
            
            
            // サンプル1 - スタイルを指定しない場合 (実寸で表示)
            var imageClip1:ImageClip = new ImageClip();
            imageClip1.load("http//kie.li/kieli.gif");
            addChild(imageClip1);
            imageClip1.x = 20;
            imageClip1.y = 20;
            
            // サンプル2 - ロードできなかった場合
            var imageClip2:ImageClip = new ImageClip();
            imageClip2.load("http://www.noimage.com/noimagehere");
            addChild(imageClip2);
            imageClip2.x = 250;
            imageClip2.y = 20;
            
            // サンプル3 - スタイル指定 "auto"
            var imageClip3:ImageClip = new ImageClip();
            imageClip3.imageStyle = {
                type:"auto",
                padding:5,
                width:150,
                height:100,
                bgColor:0x00aa44,
                bgAlpha:.5,
                bgVisible:true
            };
            imageClip3.loaderStyle = {
                radius:15,
                weight:3,
                color:0xffffff,
                bgColor:0x222222
            };
            imageClip3.load(defaultURL);
            addChild(imageClip3);
            imageClip3.x = 60;
            imageClip3.y = 160;
            
            
            // サンプル4 - スタイル指定 "trim center"
            var imageClip4:ImageClip = new ImageClip();
            imageClip4.imageStyle = {
                type:"trim center",
                padding:5,
                width:150,
                height:100,
                bgColor:0xaa0044,
                bgAlpha:.5,
                bgVisible:true
            };
            imageClip4.loaderStyle = {
                radius:15,
                weight:3,
                color:0xffffff,
                bgColor:0x222222
            };
            imageClip4.load(defaultURL);
            addChild(imageClip4);
            imageClip4.x = 250;
            imageClip4.y = 160;
            
            // サンプル5 - スタイル指定 "fit"
            var imageClip5:ImageClip = new ImageClip();
            imageClip5.imageStyle = {
                type:"fit",
                padding:5,
                width:150,
                height:100,
                bgColor:0x4400aa,
                bgAlpha:.5,
                bgVisible:true
            };
            imageClip5.loaderStyle = {
                radius:15,
                weight:5,
                color:0x003322,
                bgColor:0xafafaf
            };
            imageClip5.load(defaultURL);
            addChild(imageClip5);
            imageClip5.x = 60;
            imageClip5.y = 310;
            
            // サンプル6 - スタイル指定 "show all"
            var imageClip6:ImageClip = new ImageClip();
            imageClip6.loaderVisible = false; // ローダー非表示
            imageClip6.imageStyle = {
                type:"show all",
                padding:5,
                width:150,
                height:100,
                bgColor:0xaaaacc,
                bgAlpha:.5,
                bgVisible:true
            };
            imageClip6.loaderStyle = {
                radius:15,
                weight:8,
                color:0x22ffaa,
                bgColor:0x222222
            };
            imageClip6.load(defaultURL);
            addChild(imageClip6);
            imageClip6.x = 250;
            imageClip6.y = 310;
        }
    }
}









////////////////////////////////////////////
//            ImageClip Class
////////////////////////////////////////////

import flash.events.Event;
import flash.events.EventDispatcher;
import flash.events.ProgressEvent;
import flash.events.IOErrorEvent;
import flash.display.MovieClip;
import flash.display.Sprite;
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Loader;
import flash.display.LoaderInfo;
import flash.display.Shape;
import flash.text.TextField;
import flash.net.URLRequest;
import flash.system.LoaderContext;
import caurina.transitions.Tweener;

class ImageClip extends MovieClip {
    
    public static const READY_TO_DISPLAY:String = "ready_to_display";
    
    private var _imageStyle:Object = new Object();
    private var _loaderStyle:Object = new Object();
    private var imgLoader:Loader;
    private var tmpLoader:Loader;
    private var imageMask:Shape;
    private var req:URLRequest;
    private var donut:Donut;
    private var bmp:Bitmap;
    private var imageType:String;
    private var areaWidth:Number;
    private var areaHeight:Number;
    private var bg:Shape;
    private var bgColor:int;
    private var bgAlpha:Number;
    private var bgVisible:Boolean;
    private var padding:Number;
    private var _loaderVisible:Boolean = true;
    //private var _imageVisible:Boolean = true;
    
    public function ImageClip() {
        super();
    }
    private function init():void{

        _imageStyle.type ? imageType = _imageStyle.type : imageType = "original";
        _imageStyle.width ? areaWidth = _imageStyle.width : areaWidth = 100;
        _imageStyle.height ? areaHeight = _imageStyle.height : areaHeight = 100;
        _imageStyle.bgColor ? bgColor = _imageStyle.bgColor : bgColor = 0;
        _imageStyle.bgAlpha ? bgAlpha = _imageStyle.bgAlpha : bgAlpha = 1;
        _imageStyle.padding ? padding = _imageStyle.padding : padding = 0;
        _imageStyle.bgVisible ? bgVisible = _imageStyle.bgVisible : bgVisible = false;
        if(!_imageStyle.width && !_imageStyle.height){
            _loaderVisible = false;
        }
        
        if(bgVisible){
            bg = new Shape();
            bg.graphics.beginFill(bgColor,bgAlpha);
            bg.graphics.drawRect(0,0,areaWidth,areaHeight);
            bg.graphics.endFill();
            addChild(bg);
        }
        
        imageMask = new Shape();
        imageMask.graphics.beginFill(0,1);
        imageMask.graphics.drawRect(0,0,areaWidth - (padding*2), areaHeight - (padding*2));
        imageMask.x = padding;
        imageMask.y = padding;
        
        imgLoader = new Loader();
        imgLoader.contentLoaderInfo.addEventListener(ProgressEvent.PROGRESS, imageOnProgress);
        imgLoader.contentLoaderInfo.addEventListener(Event.COMPLETE,imageOnLoaded);
        imgLoader.contentLoaderInfo.addEventListener(IOErrorEvent.IO_ERROR, imageIOError);
        
        if(_loaderVisible){
            donut = new Donut(_loaderStyle, areaWidth, areaHeight);
            addChild(donut);
        }
    }
    private function imageOnProgress(event:ProgressEvent):void {
        if(_loaderVisible){
            var ratio:Number = event.bytesLoaded/event.bytesTotal;
            donut.loadedRatio = ratio;
        }
    }
    
    private function imageIOError(event:Event):void {
        imgLoader.contentLoaderInfo.removeEventListener(ProgressEvent.PROGRESS, imageOnProgress);
        imgLoader.contentLoaderInfo.removeEventListener(Event.COMPLETE,imageOnLoaded);
        imgLoader.contentLoaderInfo.removeEventListener(IOErrorEvent.IO_ERROR, imageIOError);
        if(_loaderVisible){
            donut.removeEventListener(Donut.TWEEN_COMPLETE, displayImage);
            donut.kill();
            removeChild(donut);
        }
        
        // エラー表示
        var errorBGColor:int;
        var errorLineColor:int;
        _loaderStyle.bgColor ? errorBGColor = _loaderStyle.bgColor : errorBGColor = 0x333333;
        _loaderStyle.color ? errorLineColor = _loaderStyle.color : errorLineColor = 0xaaaaaa;
        var errorBox:Sprite = new Sprite();
        errorBox.graphics.beginFill(errorBGColor,1);
        errorBox.graphics.drawRect(0,0,areaWidth,areaHeight);
        errorBox.graphics.endFill();
        errorBox.graphics.lineStyle(1,errorLineColor,1);
        errorBox.graphics.lineTo(areaWidth,areaHeight);
        errorBox.graphics.moveTo(0,areaHeight);
        errorBox.graphics.lineTo(areaWidth,0);
        
        addChild(imageMask);
        errorBox.mask = imageMask;
        addChild(errorBox);

        this.alpha = .2;
        
        trace(event);
        // TODO    //    クロスドメイン無しのアラートは可能か？
    }
    
    private function imageOnLoaded(event:Event):void {
        
        imgLoader.contentLoaderInfo.removeEventListener(Event.COMPLETE,imageOnLoaded);
        imgLoader.contentLoaderInfo.removeEventListener(ProgressEvent.PROGRESS, imageOnProgress);
        imgLoader.contentLoaderInfo.removeEventListener(IOErrorEvent.IO_ERROR, imageIOError);
        
        tmpLoader = new Loader();
        tmpLoader.contentLoaderInfo.addEventListener(Event.INIT, tmpOnLoaded);
        tmpLoader.loadBytes(imgLoader.contentLoaderInfo.bytes);
    
    }
    private function tmpOnLoaded(event:Event):void {
        
        tmpLoader.contentLoaderInfo.removeEventListener(Event.INIT, tmpOnLoaded);
        
        var loader:Loader = event.currentTarget.loader;
        var bd:BitmapData = new BitmapData(loader.content.width, loader.content.height, true, 0x00ffffff);
    bd.draw(loader.content);
        bmp = new Bitmap(bd);
        bmp.smoothing = true;
        
        if(_loaderVisible){
            donut.swapContent = bmp;
            donut.addEventListener(Donut.TWEEN_COMPLETE, function(e:Event):void{
                dispatchEvent(new Event(READY_TO_DISPLAY))
            });
        } else {
            dispatchEvent(new Event(READY_TO_DISPLAY));
        }
        displayImage();
    }
    private function displayImage(event:Event = undefined):void {
        
        if(_loaderVisible){
            donut.removeEventListener(Donut.TWEEN_COMPLETE, displayImage);
        }
        
        
        var areaAspectRatio:Number = areaWidth/areaHeight;
        var bmpAspectRatio:Number = bmp.width/bmp.height;
        var bmpRatioIsHigher:Boolean = ((bmpAspectRatio - areaAspectRatio) >= 0);
        
        switch (imageType){
            
            case "original":
                
                break;
                
            case "fit":
                bmp.width = areaWidth - (padding*2);
                bmp.height = areaHeight - (padding*2);
                bmp.x = padding;
                bmp.y = padding;
                break;
                
            case "auto":
                bmpRatioIsHigher ? adjustHeightFirst() : adjustWidthFirst();
                addChild(imageMask);
                bmp.mask = imageMask;
                break;
                
            case "show all":
                bmpRatioIsHigher ? adjustWidthFirst() : adjustHeightFirst();
                break;
                
            case "trim center":
                bmp.y = (areaHeight - bmp.height)/2;
                bmp.x = (areaWidth - bmp.width)/2;
                addChild(imageMask);
                bmp.mask = imageMask;
                break;
                
        }

        addChild(bmp);
        
        function adjustWidthFirst():void{
            bmp.width = areaWidth - (padding*2);
            bmp.height = bmp.width/bmpAspectRatio;
            bmp.x = padding;
            bmp.y = (areaHeight - bmp.height)/2;
        }
        
        function adjustHeightFirst():void{
            bmp.height = areaHeight - (padding*2);
            bmp.width = bmp.height*bmpAspectRatio;
            bmp.x = (areaWidth - bmp.width)/2;
            bmp.y = padding;
        }
    }

    
    public function load(url:String):void {
        init();
        req = new URLRequest(url);
        imgLoader.load(req,new LoaderContext(true));
    }
    
    public function set imageStyle(o:Object):void {
        _imageStyle = o;
    }
    /*public function set imageVisible(b:Boolean):void {
        _imageVisible = b;
    }*/
    public function set loaderStyle(o:Object):void {
        _loaderStyle = o;
    }
    public function set loaderVisible(b:Boolean):void {
        _loaderVisible = b;
    }
}


////////////////////////////////
//    Donut Class                
////////////////////////////////

//    ImageClipクラスとセットで使う。ドーナツを描くためのクラス。

import flash.display.Shape;
import flash.display.Bitmap;
import frocessing.display.*;
import flash.events.EventDispatcher;

class Donut extends F5MovieClip2DBmp {
    private var bg:Shape;
    private var _style:Object = new Object();
    private var _loadedRatio:Number = 0;
    private var _radius:Number;
    private var _weight:Number;
    private var _color:int;
    private var _bgColor:int;
    private var lastRadian:Number = 0;
    private var acceleration:Number = 8;
    private var isLoadedEnough:Boolean = false;
    private var _swapContent:Bitmap;
    
    public static const TWEEN_COMPLETE:String = "load_complete";
    
    public function Donut(style:Object, areaWidth:Number, areaHeight:Number) {
        super();
        
        if(style) { _style = style };
        _style.radius ? _radius = _style.radius : _radius = 15;
        _style.weight ? _weight = _style.weight : _weight = 5;
        _style.color ? _color = _style.color : _color = 0xaaaaaa;
        _style.bgColor ? _bgColor = _style.bgColor : _bgColor = 0x666666;
                        
        this.x = (areaWidth/2)-_radius-1;
        this.y = (areaHeight/2)-_radius-1;
    }

    public function setup():void {
        bg = new Shape();
        bg.graphics.beginFill(_bgColor,1);
        bg.graphics.drawCircle(_radius+1,_radius+1,_radius);
        bg.graphics.drawCircle(_radius+1,_radius+1,_radius-_weight);
        bg.graphics.endFill();
        addChild(bg);
        size(_radius*2+2,_radius*2+2);
        background(255,0);
        fill(_color);
        stroke(0,0);
    }

    public function draw():void {

        background(255,0);
        translate(_radius+1,_radius+1);
        var targetRadian:Number = Math.PI*2/(360/_loadedRatio);
        var amount:Number = lastRadian+(targetRadian - lastRadian)/acceleration;
        if(amount < 6.283185307179583){
            beginShape();
            moveTo(0,-_radius);
            arcTo(0, 0, _radius, _radius, 0, amount, -Math.PI/2);
            arcTo(0, 0, _radius-_weight, _radius-_weight, amount, 0, -Math.PI/2);
            endShape();
        }
        
        lastRadian = amount;
        
        if(amount >= 3.14){
            acceleration = 4
        }
        if(amount >= 6.26){
            this.alpha -= .1;
            if(!isLoadedEnough){
                isLoadedEnough = true;
            }
            if(isLoadedEnough && _swapContent){
                _swapContent.alpha = 1-this.alpha;
            }
            if(this.alpha <= 0){
                dispatchEvent(new Event(TWEEN_COMPLETE));
                noLoop();
            }
        }
    }
    public function set loadedRatio(n:Number):void{
        _loadedRatio = n*360;
    }
    public function set swapContent(bmp:Bitmap):void{
        _swapContent = bmp;
        _swapContent.alpha = 0;
    }
    public function kill():void{
        noLoop();
    }
}