/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pW3B
 */

// forked from ProjectNya's forked from: simple 3D 02 (not using PV3D)
// forked from sake's simple 3D 02 (not using PV3D)
/*
PV3Dとかを使わない3D表現その2
PixelじゃなくてBitmapを使う。Arrayを使ってZソートしとこう。
少し数値がおかしいんであとで修正。
*/
package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Loader;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.filters.BlurFilter;
    import flash.geom.Point;
    import flash.geom.Matrix;
    //import net.wonderfl.utils.SequentialLoader;
    
    [SWF(width="465", height="465", backgroundColor="0xffffff", frameRate="30")]

    public class simple3d_02 extends Sprite 
    {

        public  var   FOCUS:Number=stage.mouseY;
        private const RADIUS:Number=180;
        private const N_POINT1:int=8;
        private const N_POINT2:int=10;
        private const N_POINT3:int=N_POINT1 * N_POINT2;
        private const CENTER_X:int=465 / 2;
        private const CENTER_Y:int=465 / 2;
        private const W:int=465;
        private const H:int=465;
        private const RADIAN:Number=Math.PI / 180;
        private const N_BLUR_IMG:int=30;
        private const STEP:Number=RADIUS / N_BLUR_IMG;
        //private const imgURL:String="http://assets.wonderfl.net/images/related_images/6/64/643a/643a412effc1d96e4df242ad7590fe90fa7a56c1";
        
        private var ballAry:Array;
        private var imgAry:Array;
        //private var imgs:Array;
        
        public function simple3d_02()
        {
            //imgs=[];
            //SequentialLoader.loadImages([imgURL], imgs, onLoaded);
            onLoaded();
        }
        
        private function onLoaded():void
        {
            var i:int;
            var j:int;
            ballAry=[];
            imgAry=[];
            
            // 画像の読み込み
            //var ldr:Loader=imgs.pop();
            //var ballImg:BitmapData=(ldr.content as Bitmap).bitmapData;
            var aqua:Aqua = new Aqua(20, 230);
            addChild(aqua);
            var ballImg:BitmapData = new BitmapData(60, 60, true, 0x00000000);
            var matrix:Matrix = new Matrix();
            matrix.translate(30, 50);
            ballImg.draw(aqua, matrix);
            
            // ブラー付きのBitmapDataを先に作っておくべ。
            var p:Point=new Point;
            for(i=0; i < N_BLUR_IMG; i++)
            {
                var tmp:BitmapData=ballImg.clone();
                tmp.applyFilter(tmp, tmp.rect, p, new BlurFilter(0.4 * i, 0.4 * i));
                imgAry[i]=tmp;
            }
            
            // 各点の初期位置を計算
            for(i=0; i < N_POINT1; i++)
            {
                var theta1:Number=(360 / N_POINT1) * i * RADIAN;
                for(j=0; j < N_POINT2; j++)
                {
                    var theta2:Number=((180 / N_POINT2) * j - 90) * RADIAN;
                    var xx:Number=RADIUS * Math.cos(theta2) * Math.sin(theta1);
                    var yy:Number=RADIUS * Math.sin(theta2);
                    var zz:Number=RADIUS * Math.cos(theta2) * Math.cos(theta1);
                    var ball:Ball3D=new Ball3D(ballImg, xx, yy, zz);
                    ballAry[i * N_POINT2 + j]=ball;
                    addChild(ball);
                }
            }
            addEventListener(Event.ENTER_FRAME, onFrame);
        }
        
        private function onFrame(e:Event):void
        {
            // 座標計算
            for(var i:int=0; i < N_POINT3; i++)
            {
                var ball:Ball3D=ballAry[i]as Ball3D;
                
                // 回転行列で回転 (x軸回転とy軸回転の積を展開したもの)
                var tmpX:Number=ball.xx * Math.cos(RADIAN) + ball.yy * Math.sin(RADIAN) * Math.sin(RADIAN) - ball.zz * Math.sin(RADIAN) * Math.cos(RADIAN);
                var tmpY:Number=ball.yy * Math.cos(RADIAN) + ball.zz * Math.sin(RADIAN);
                var tmpZ:Number=ball.xx * Math.sin(RADIAN) - ball.yy * Math.sin(RADIAN) * Math.cos(RADIAN) + ball.zz * Math.cos(RADIAN) * Math.cos(RADIAN);
                
                // 3D→2D変換 
                var scale:Number=FOCUS / (FOCUS + tmpZ);
                var xx:int=int(tmpX * scale) + CENTER_X;
                var yy:int=int(tmpY * scale) * (-1) + CENTER_Y;
                
                ball.scaleX=ball.scaleY=scale;
                ball.x=xx;
                ball.y=yy;
                
                // BitmapDataの更新
                var tmp:int=int(tmpZ / STEP);
                tmp=(tmp > 0) ? (tmp) : (-1 * tmp);
                tmp=(tmp >= N_BLUR_IMG) ? (N_BLUR_IMG - 1) : (tmp);
                ball.bitmapData=imgAry[tmp]as BitmapData;
                
                // 座標の保存
                ball.yy=tmpY;
                ball.zz=tmpZ;
                ball.xx=tmpX;
            }
            
            // zソート
            ballAry.sortOn("zz", Array.NUMERIC | Array.DESCENDING);
            for(i=0; i < N_POINT3; i++)
            {
                ball=ballAry[i]as Ball3D;
                setChildIndex(ball, i)
            }
            
        }
    }
}


import flash.display.Bitmap;
import flash.display.BitmapData;

class Ball3D extends Bitmap
{
    public var xx:Number;
    public var yy:Number;
    public var zz:Number;
    public var sort:Number;
    private var w:Number;
    private var h:Number;
    
    public function Ball3D(bmpd:BitmapData=null, xx:Number=0, yy:Number=0, zz:Number=0)
    {
        this.xx=xx;
        this.yy=yy;
        this.zz=zz;
        bitmapData=bmpd;
        w=bmpd.width / 2;
        h=bmpd.height / 2;
    }
    
    override public function set x(value:Number):void
    {
        super.x=value - w;
    }
    
    override public function set y(value:Number):void
    {
        super.y=value - h;
    }
}


import flash.display.Sprite;
import flash.display.Shape;
import flash.filters.DropShadowFilter;
import flash.filters.GlowFilter;
import flash.filters.BlurFilter;
import flash.geom.Matrix;
import flash.display.GradientType;
import flash.display.SpreadMethod;
import flash.display.InterpolationMethod;
import flash.geom.ColorTransform;
import frocessing.color.ColorHSV;

class Aqua extends Sprite {
    private var radius:uint;
    private var hue:Number;
    private var light:Shape;
    private var inner:Shape;
    private var base:Shape;
    private static var bColor:uint = 0xFFFFFF;
    private static var sColor:uint = 0x000000;
    private var shaded:Boolean;

    public function Aqua(r:uint, h:Number) {
        radius = r;
        hue = h;
        draw();
    }

    private function draw():void {
        base = new Shape();
        addChild(base);
        base.y = -radius;
        inner = new Shape();
        addChild(inner);
        inner.y = -radius;
        light = new Shape();
        addChild(light);
        light.y = -radius;
        createLight();
        colorize(hue);
    }
    public function colorize(h:Number):void {
        h %= 360;
        if (h < 0) h += 360;
        hue = Math.floor(h);
        createBase();
        createInner();
    }
    private function createBase():void {
        base.graphics.clear();
        //var color:Number = ColorConversion.HSBtoHEX24(hue, 75, 78);
        var hsv:ColorHSV = new ColorHSV(hue, 0.75, 0.78);
        base.graphics.beginFill(hsv.value);
        base.graphics.drawCircle(0, 0, radius);
        base.graphics.endFill();
        var _hue:Number = (hue + 6)%360;
        //var gColor:Number = ColorConversion.HSBtoHEX24(_hue, 50, 53);
        var ghsv:ColorHSV = new ColorHSV(hue, 0.5, 0.53);
        var glow:GlowFilter = new GlowFilter(ghsv.value, 1, radius*0.5, radius*0.5, 2, 3, true, false);
        base.filters = [glow];
    }
    private function createLight():void {
        var colors:Array = [bColor, bColor];
        var alphas:Array = [0.7, 0];
        var ratios:Array = [0, 191];
        var matrix:Matrix = new Matrix();
        var w:Number = radius*1.44;
        var h:Number = radius*1.35;
        var yOffset:Number = radius*0.95;
        matrix.createGradientBox(w, h, 0.5*Math.PI, -w*0.5, -yOffset);
        light.graphics.beginGradientFill(GradientType.LINEAR, colors, alphas, ratios, matrix, SpreadMethod.PAD, InterpolationMethod.RGB, 0);
        light.graphics.drawEllipse(-w*0.5, -yOffset, w, h);
        light.graphics.endFill();
    }
    private function createInner():void {
        inner.graphics.clear();
        var colors:Array = [bColor, bColor];
        var alphas:Array = [1, 0];
        var ratios:Array = [0, 191];
        var matrix:Matrix = new Matrix();
        var w:Number = radius*1.44;
        var h:Number = radius*1.35;
        var yOffset:Number = radius*0.45;
        matrix.createGradientBox(w, h, -0.5*Math.PI, -w*0.5, -yOffset);
        inner.graphics.beginGradientFill(GradientType.LINEAR, colors, alphas, ratios, matrix, SpreadMethod.PAD, InterpolationMethod.RGB, 0);
        inner.graphics.drawEllipse(-w*0.5, -yOffset, w, h);
        inner.graphics.endFill();
        var colorTrans:ColorTransform = new ColorTransform();
        var _hue:Number = (hue - (Math.random()*10))%360;
        if (_hue < 0) _hue += 360; 
        //var color:Number = ColorConversion.HSBtoHEX24(_hue, 100, 100);
        var color:ColorHSV = new ColorHSV(hue, 1, 1);
        colorTrans.color = color.value;
        inner.transform.colorTransform = colorTrans;
        var b:Number = radius*0.35;
        var blur:BlurFilter = new BlurFilter(b, b, 3);
        inner.filters = [blur];
    }

}
