/**
 * Copyright aina ( http://wonderfl.net/user/aina )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pVGW
 */

package {
    import Box2D.Common.Math.b2Vec2;
    import Box2D.Dynamics.Joints.b2RevoluteJoint;
    import com.actionsnippet.qbox.*;
    import flash.display.MovieClip;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Matrix;
    
    import flash.events.Event;
    import flash.events.KeyboardEvent;
    import flash.ui.Keyboard;
   
   
    public class Main extends MovieClip{     
    private var sim:QuickBox2D;
        private var canvas:MovieClip;
        private var dx:Number = 0;
        private var dy:Number = 0;
        private var time:Number = 0;
        private var scale:Number = 1;
        private var scaleDest:Number = 1.0;
        private var currQuick:QuickObject;
        private var xx:Number = 0;
        private var yy:Number = 0;
       

        
        
    public function Main() {        
    
    if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
    }
    
    private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            
            canvas = new MovieClip();
            addChild(canvas);
            
            sim = new QuickBox2D(canvas, {debug:false});
            
                          
              
            sim.addCircle( { x:15, y:9.8, radius:1, restitution:1 ,density:0,fillColor:0x000000} );
            sim.addCircle( { x:16, y:9.8, radius:1, restitution:1 ,density:0,fillColor:0x000000} );
            sim.addCircle( { x:17, y:9.8, radius:1, restitution:1 ,density:0,fillColor:0x000000} );
            sim.addCircle( { x:18, y:9.8, radius:1, restitution:1 ,density:0,fillColor:0x000000} );
            sim.addCircle( { x:19.3, y:9.8, radius:1, restitution:1 ,density:0,fillColor:0x000000} );
            
            sim.addBox( { x:5, y:10.1, width:30, height:2, density:0,fillColor:0x000000} );
            sim.addBox( { x:21.6, y:11.3, width:5, height:2, angle:10, density:0,fillColor:0x000000 } );
            sim.addBox( { x:33.1, y:12.5, width:20, height:2, density:0 ,fillColor:0x000000} );
            sim.addBox( { x:58, y:12.5, width:20, height:2, density:0 ,fillColor:0x000000} );
            sim.addBox( { x:66, y:12.5, width:5, height:2, density:0 ,fillColor:0xf00000} );
            sim.addBox( { x:66, y:7.5, width:5, height:2, density:0 ,fillColor:0xf00000} );
            sim.addBox( { x:5, y:20, width:126, height:0.7, density:0,fillColor:0xf00000 } );
            sim.addBox( { x:68.5, y:10, width:2, height:7, density:0,fillColor:0xf00000} );
            //sim.addBox( { x:20, y:10, width:10, height:1, angle:-0.5, density:0 } );
            //sim.addBox( { x:28.2, y:10, width:10, height:1, angle:0.5, density:0 } );
            
            var body:QuickObject = sim.addBox( { x:2.5, y:8, width:4, height:1 } );
            var wheelA:QuickObject = sim.addCircle( { x:1, y:9, radius:0.5 } );
            var wheelB:QuickObject = sim.addCircle( { x:4, y:9, radius:0.5 } );
            sim.setDefault({type:"revolute", enableMotor:true, maxMotorTorque:250});
            var jointA:b2RevoluteJoint = sim.addJoint( { a:body.body, b:wheelA.body, x1:wheelA.x, y1:wheelA.y } ).joint as b2RevoluteJoint;
            var jointB:b2RevoluteJoint = sim.addJoint( { a:body.body, b:wheelB.body, x1:wheelB.x, y1:wheelB.y } ).joint as b2RevoluteJoint;
            jointA.SetMotorSpeed(5);
            jointB.SetMotorSpeed(5);
            sim.setDefault({});
             
           
            
            
            sim.addTimeStepSequence({ time:240, callback:camera, args:[body, 1] },
                                    { time:480, callback:camera, args:[body, 1] },
                                    { time:700, callback:camera, args:[body, 1] },
                                    { time:930, callback:camera, args:[body, 1] }
                                    );
                                    
                                    
             

                 sim.start();
                 sim.mouseDrag();  
                                                                        

      
            
             addEventListener(Event.ENTER_FRAME, loop);
            loop()
        }
  
        /*private function onKeyDown(e:KeyboardEvent):void        {                        
        if (e.keyCode == 39)            {                
        jointA.x += 2;            }                       
        else if (e.keyCode == 37)            {                
        ball.x -= 2;            }            
        else if (e.keyCode == 38)            {                
        ball.y -= 2;            }                       
        else if (e.keyCode == 40)            {                
        ball.y += 2;            }
        }*/
        
       
       
    
    private function loop(e:Event = null):void 
        {
            scale += (scaleDest - scale) * 0.2;
            dx += (currQuick.x * 30+xx - dx) * 0.2;
            dy += (currQuick.y * 30+yy - dy) * 0.2;
            var m:Matrix = canvas.transform.matrix;
            m.identity();
            m.translate(-dx+100,-dy+200);
            m.scale(scale, scale);
            canvas.transform.matrix = m;
        }   
     private function camera(quickObj:QuickObject, scale:Number = -1, x:Number = 0, y:Number = 0):void
        {
            currQuick = quickObj;
            xx = x;
            yy = y;
            if (scale != -1){
                scaleDest = scale;
            }
            
            
            
    }
   }
 }