/**
 * Copyright HaraMakoto ( http://wonderfl.net/user/HaraMakoto )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pUly
 */

package {
	import caurina.transitions.Equations;
	import caurina.transitions.Tweener;
	import caurina.transitions.properties.DisplayShortcuts;
	
	import com.adobe.serialization.json.JSON;
	import com.bit101.components.ColorChooser;
	import com.bit101.components.PushButton;
	
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Loader;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.Point;
	import flash.geom.Rectangle;
	import flash.media.Sound;
	import flash.media.SoundChannel;
	import flash.media.SoundLoaderContext;
	import flash.media.SoundMixer;
	import flash.media.SoundTransform;
	import flash.net.URLRequest;
	import flash.system.Security;
	import flash.utils.ByteArray;
	import flash.utils.getTimer;
	
        /**
        * 曲は夢幻のオルゴール工房さんにて配布されているmp3ファイルを使用しています
        * http://www.dream-orgel.net/diary.cgi?no=120&continue=on
        */
	[SWF(width="465", height="465", backgroundColor="#000000", frameRate=30)]
	public class LineReader extends Sprite
	{
		private var _field:Sprite = new Sprite();
		private var _paintField:Sprite = new Sprite();
		private var _uiField:Sprite = new Sprite();
		private var _stopUiField:Sprite = new Sprite();
		private var _startField:Sprite = new Sprite();
		
		//Clearエフェクト
		private var _clearEffBmp:Bitmap = new Bitmap();
		private var _clearBmd:BitmapData = new BitmapData(465,465,true,0);
		
		//座標リスト
		private var _pointListList:Array = new Array();
		private var _currentListIndex:int = 0;
		private var _actionFlg:Boolean = true;
		/**
		 * params
		 */
		private var _col:Number = 0xFFFFFF;
		/**
		 * Sound parts
		 */
		private var player:Object = new Object();
		private var loader:Loader = new Loader();
		private var bA:ByteArray;
		private var spectrum:Array;
		public static var lowVal:Number=0;
		public static var middleVal:Number=0;
		public static var highVal:Number = 0;
		private var sound:Sound;
		private var _ch:SoundChannel;
		
		/**
		 * UI
		 */
		private var _colSelector:ColorSelector;
		private var _colChooser:ColorChooser;
		
		/**
		 * RECORD
		 */ 
		private var _rec:DrawRecoder = new DrawRecoder();
		private var _player:DrawPlayer = new DrawPlayer();
		
		/**
		 * TIMER
		 */
		private var _startTime:int;
		
		public function LineReader()
		{
			init();
			setupDisplay();
		}
		
		public function init():void {
			DisplayShortcuts.init();
			Security.loadPolicyFile("http://swimmingbird.heteml.jp/crossdomain.xml");
			
			_field.graphics.clear();
			_field.graphics.beginFill(0xCCCCCC,0);
			_field.graphics.drawRect(0,0,465,465);
			_field.graphics.endFill();
			
			
			//UI Starting
			var _startButton:PushButton = new PushButton(_startField,20,20,"start", startHandler);
			//UI Playing
			//			var _actionBtn:PushButton = new PushButton(_uiField,20,20,"action",actionHandler);
			//			var _noActionBtn:PushButton = new PushButton(_uiField,20,45,"noAction",noActionHandler);
			var _clearBtn:PushButton = new PushButton(_uiField,20,20,"clear",clearHandler);
			var _plotBtn:PushButton = new PushButton(_uiField,20,45,"plot",plotHandler);
			var _stopBtn:PushButton = new PushButton(_uiField,20,120,"stop",stopHandler);
			//UI Stop
			var _playDataBtn:PushButton = new PushButton(_stopUiField,20,20,"play",playDataHandler);
			var _stopDrawBtn:PushButton = new PushButton(_stopUiField,20,45,"stop",stopDrawHandler);
			
			_colSelector = new ColorSelector();
			//			_colChooser = new ColorChooser(_uiField,20,145);
			
			//Effect Init
			_clearEffBmp.bitmapData = _clearBmd;
			_clearEffBmp.visible = false;
			_clearEffBmp.alpha = 0;
			//座標リスト
			var comListString:String = '[{"id":0,"col":16777010,"fx":200,"time":1039,"fy":130,"type":"draw","childlist":[{"time":1139,"x":199,"y":130},{"time":1161,"x":197,"y":130},{"time":1183,"x":194,"y":131},{"time":1204,"x":193,"y":131},{"time":1225,"x":192,"y":132},{"time":1246,"x":190,"y":132},{"time":1267,"x":187,"y":134},{"time":1287,"x":184,"y":135},{"time":1308,"x":181,"y":137},{"time":1330,"x":178,"y":138},{"time":1351,"x":174,"y":140},{"time":1372,"x":172,"y":141},{"time":1393,"x":171,"y":142},{"time":1414,"x":168,"y":144},{"time":1434,"x":164,"y":147},{"time":1455,"x":160,"y":150},{"time":1476,"x":158,"y":153},{"time":1496,"x":154,"y":156},{"time":1517,"x":150,"y":160},{"time":1537,"x":147,"y":163},{"time":1558,"x":144,"y":166},{"time":1579,"x":142,"y":169},{"time":1599,"x":139,"y":172},{"time":1620,"x":136,"y":176},{"time":1641,"x":134,"y":179},{"time":1663,"x":132,"y":182},{"time":1684,"x":129,"y":186},{"time":1705,"x":127,"y":189},{"time":1726,"x":125,"y":194},{"time":1746,"x":123,"y":198},{"time":1767,"x":121,"y":201},{"time":1788,"x":119,"y":207},{"time":1809,"x":116,"y":211},{"time":1831,"x":114,"y":216},{"time":1852,"x":112,"y":219},{"time":1873,"x":110,"y":225},{"time":1894,"x":108,"y":229},{"time":1914,"x":106,"y":234},{"time":1934,"x":105,"y":240},{"time":1954,"x":104,"y":244},{"time":1976,"x":103,"y":249},{"time":1997,"x":102,"y":251},{"time":2018,"x":101,"y":258},{"time":2039,"x":100,"y":262},{"time":2059,"x":99,"y":265},{"time":2081,"x":99,"y":268},{"time":2102,"x":99,"y":274},{"time":2122,"x":99,"y":279},{"time":2143,"x":99,"y":283},{"time":2165,"x":100,"y":289},{"time":2186,"x":101,"y":295},{"time":2207,"x":103,"y":300},{"time":2228,"x":104,"y":303},{"time":2249,"x":107,"y":308},{"time":2270,"x":109,"y":311},{"time":2291,"x":112,"y":315},{"time":2312,"x":114,"y":318},{"time":2333,"x":118,"y":322},{"time":2353,"x":122,"y":325},{"time":2374,"x":125,"y":328},{"time":2397,"x":128,"y":330},{"time":2418,"x":133,"y":332},{"time":2439,"x":137,"y":334},{"time":2460,"x":142,"y":336},{"time":2480,"x":147,"y":337},{"time":2501,"x":149,"y":338},{"time":2522,"x":155,"y":339},{"time":2543,"x":160,"y":340},{"time":2564,"x":166,"y":340},{"time":2584,"x":169,"y":340},{"time":2606,"x":172,"y":340},{"time":2627,"x":175,"y":340},{"time":2648,"x":181,"y":340},{"time":2669,"x":186,"y":338},{"time":2690,"x":192,"y":336},{"time":2710,"x":197,"y":334},{"time":2731,"x":200,"y":332},{"time":2752,"x":204,"y":330},{"time":2773,"x":209,"y":328},{"time":2794,"x":213,"y":326},{"time":2815,"x":216,"y":324},{"time":2835,"x":220,"y":322},{"time":2856,"x":222,"y":321},{"time":2877,"x":223,"y":321},{"time":2898,"x":228,"y":319},{"time":2919,"x":231,"y":317},{"time":2940,"x":234,"y":317},{"time":2961,"x":236,"y":316},{"time":2982,"x":237,"y":316},{"time":3002,"x":238,"y":316},{"time":3023,"x":240,"y":316},{"time":3044,"x":242,"y":316},{"time":3064,"x":243,"y":316},{"time":3086,"x":247,"y":316},{"time":3107,"x":248,"y":316},{"time":3129,"x":250,"y":317},{"time":3149,"x":252,"y":317},{"time":3169,"x":253,"y":318},{"time":3190,"x":256,"y":319},{"time":3211,"x":258,"y":320},{"time":3234,"x":262,"y":321},{"time":3255,"x":266,"y":323},{"time":3276,"x":268,"y":325},{"time":3300,"x":271,"y":327},{"time":3321,"x":274,"y":328},{"time":3343,"x":278,"y":332},{"time":3364,"x":280,"y":333},{"time":3385,"x":284,"y":335},{"time":3406,"x":288,"y":337},{"time":3427,"x":293,"y":339},{"time":3448,"x":294,"y":340},{"time":3469,"x":298,"y":341},{"time":3491,"x":301,"y":342},{"time":3512,"x":304,"y":343},{"time":3534,"x":306,"y":343},{"time":3555,"x":311,"y":344},{"time":3575,"x":315,"y":345},{"time":3594,"x":319,"y":345},{"time":3615,"x":321,"y":345},{"time":3634,"x":322,"y":345},{"time":3653,"x":324,"y":345},{"time":3674,"x":326,"y":345},{"time":3696,"x":327,"y":345},{"time":3716,"x":328,"y":345},{"time":3737,"x":329,"y":345},{"time":3758,"x":331,"y":344},{"time":3778,"x":332,"y":343},{"time":3798,"x":333,"y":343},{"time":3819,"x":335,"y":342},{"time":3840,"x":337,"y":341},{"time":3861,"x":339,"y":340},{"time":3882,"x":342,"y":337},{"time":3902,"x":344,"y":335},{"time":3924,"x":346,"y":334},{"time":3945,"x":347,"y":332},{"time":3967,"x":348,"y":332},{"time":3988,"x":349,"y":331},{"time":4009,"x":351,"y":329},{"time":4030,"x":352,"y":327},{"time":4051,"x":354,"y":325},{"time":4072,"x":354,"y":323},{"time":4093,"x":355,"y":322},{"time":4114,"x":356,"y":321},{"time":4135,"x":357,"y":318},{"time":4156,"x":358,"y":316},{"time":4177,"x":358,"y":315},{"time":4198,"x":360,"y":312},{"time":4219,"x":361,"y":307},{"time":4240,"x":363,"y":303},{"time":4266,"x":364,"y":300},{"time":4286,"x":364,"y":298},{"time":4305,"x":364,"y":297},{"time":4325,"x":365,"y":294},{"time":4344,"x":365,"y":291},{"time":4365,"x":366,"y":288},{"time":4385,"x":366,"y":286},{"time":4404,"x":366,"y":284},{"time":4424,"x":366,"y":283},{"time":4445,"x":366,"y":281},{"time":4466,"x":366,"y":279},{"time":4487,"x":366,"y":277},{"time":4507,"x":366,"y":275},{"time":4533,"x":366,"y":272},{"time":4554,"x":366,"y":271},{"time":4575,"x":366,"y":269},{"time":4601,"x":365,"y":265},{"time":4621,"x":365,"y":264},{"time":4642,"x":364,"y":263},{"time":4664,"x":364,"y":261},{"time":4685,"x":363,"y":259},{"time":4705,"x":362,"y":257},{"time":4725,"x":360,"y":251},{"time":4747,"x":359,"y":248},{"time":4768,"x":358,"y":245},{"time":4789,"x":356,"y":242},{"time":4810,"x":355,"y":238},{"time":4832,"x":353,"y":235},{"time":4852,"x":352,"y":230},{"time":4873,"x":350,"y":226},{"time":4895,"x":347,"y":220},{"time":4915,"x":345,"y":216},{"time":4935,"x":344,"y":213},{"time":4956,"x":341,"y":208},{"time":4977,"x":339,"y":204},{"time":5001,"x":337,"y":199},{"time":5022,"x":334,"y":196},{"time":5042,"x":332,"y":193},{"time":5063,"x":330,"y":191},{"time":5085,"x":327,"y":187},{"time":5106,"x":324,"y":184},{"time":5126,"x":322,"y":181},{"time":5148,"x":320,"y":180},{"time":5169,"x":318,"y":177},{"time":5190,"x":314,"y":174},{"time":5211,"x":311,"y":171},{"time":5234,"x":310,"y":170},{"time":5255,"x":309,"y":169},{"time":5275,"x":308,"y":169},{"time":5301,"x":307,"y":168},{"time":5321,"x":305,"y":166},{"time":5343,"x":302,"y":163},{"time":5364,"x":299,"y":160},{"time":5385,"x":298,"y":159},{"time":5405,"x":297,"y":158},{"time":5426,"x":295,"y":157},{"time":5449,"x":293,"y":155},{"time":5470,"x":290,"y":153},{"time":5491,"x":289,"y":152},{"time":5511,"x":288,"y":151},{"time":5531,"x":287,"y":150},{"time":5552,"x":283,"y":147},{"time":5573,"x":280,"y":145},{"time":5594,"x":277,"y":143},{"time":5616,"x":276,"y":142},{"time":5636,"x":274,"y":141},{"time":5657,"x":273,"y":140},{"time":5678,"x":272,"y":139},{"time":5701,"x":270,"y":139},{"time":5722,"x":269,"y":138},{"time":5743,"x":267,"y":137},{"time":5765,"x":265,"y":135},{"time":5785,"x":262,"y":134},{"time":5807,"x":261,"y":133},{"time":5828,"x":260,"y":133},{"time":5850,"x":259,"y":132},{"time":5871,"x":258,"y":132},{"time":5892,"x":257,"y":132},{"time":5912,"x":256,"y":131},{"time":5934,"x":254,"y":131},{"time":5955,"x":253,"y":131},{"time":6001,"x":252,"y":131},{"time":6022,"x":251,"y":131},{"time":6064,"x":250,"y":131},{"time":6083,"x":249,"y":131},{"time":6122,"x":248,"y":131},{"time":6143,"x":247,"y":131},{"time":6165,"x":246,"y":131},{"time":6185,"x":245,"y":131},{"time":6206,"x":244,"y":131},{"time":6226,"x":243,"y":131},{"time":6247,"x":241,"y":131},{"time":6286,"x":239,"y":132},{"time":6307,"x":237,"y":132},{"time":6334,"x":235,"y":133},{"time":6354,"x":233,"y":134},{"time":6374,"x":232,"y":134},{"time":6402,"x":231,"y":135},{"time":6421,"x":230,"y":135},{"time":6441,"x":229,"y":136},{"time":6464,"x":228,"y":136},{"time":6485,"x":227,"y":137},{"time":6552,"x":227,"y":138},{"time":6573,"x":226,"y":138},{"time":6615,"x":225,"y":139},{"time":6636,"x":224,"y":139},{"time":6741,"x":223,"y":139},{"time":6764,"x":222,"y":139},{"time":6784,"x":221,"y":139},{"time":6824,"x":220,"y":139},{"time":6845,"x":219,"y":139},{"time":6866,"x":219,"y":138},{"time":6887,"x":218,"y":138},{"time":6909,"x":217,"y":138},{"time":6932,"x":216,"y":137},{"time":6952,"x":214,"y":136},{"time":6973,"x":213,"y":136},{"time":6994,"x":212,"y":136},{"time":7016,"x":211,"y":135},{"time":7037,"x":210,"y":135},{"time":7057,"x":209,"y":135},{"time":7101,"x":208,"y":134},{"time":7122,"x":206,"y":134},{"time":7143,"x":204,"y":134},{"time":7185,"x":203,"y":134},{"time":7206,"x":202,"y":134},{"time":7227,"x":200,"y":134},{"time":7249,"x":199,"y":134},{"time":7270,"x":196,"y":134},{"time":7291,"x":195,"y":134},{"time":7312,"x":194,"y":134},{"time":7735,"x":212,"y":135},{"time":7744,"x":213,"y":135}]},{"id":0,"col":16777010,"fx":221,"time":8107,"fy":140,"type":"draw","childlist":[{"time":8206,"x":221,"y":142},{"time":8231,"x":220,"y":143},{"time":8254,"x":220,"y":145},{"time":8276,"x":219,"y":147},{"time":8299,"x":219,"y":149},{"time":8318,"x":219,"y":152},{"time":8338,"x":219,"y":155},{"time":8356,"x":219,"y":158},{"time":8375,"x":219,"y":160},{"time":8393,"x":219,"y":162},{"time":8413,"x":219,"y":163},{"time":8434,"x":219,"y":164},{"time":8452,"x":219,"y":165},{"time":8470,"x":219,"y":166},{"time":8488,"x":219,"y":167},{"time":8505,"x":219,"y":168},{"time":8523,"x":219,"y":169},{"time":8541,"x":219,"y":170},{"time":8565,"x":220,"y":171},{"time":8585,"x":220,"y":172},{"time":8606,"x":221,"y":172},{"time":8627,"x":221,"y":173},{"time":8691,"x":222,"y":174},{"time":8713,"x":223,"y":174},{"time":8754,"x":224,"y":174},{"time":8822,"x":225,"y":172},{"time":8843,"x":225,"y":169},{"time":8865,"x":225,"y":168},{"time":8886,"x":225,"y":166},{"time":8907,"x":225,"y":164},{"time":8932,"x":225,"y":163},{"time":8954,"x":225,"y":162},{"time":8993,"x":225,"y":161},{"time":9014,"x":225,"y":160},{"time":9035,"x":224,"y":159},{"time":9055,"x":224,"y":158},{"time":9094,"x":224,"y":157},{"time":9114,"x":224,"y":156},{"time":9157,"x":223,"y":154},{"time":9178,"x":223,"y":153},{"time":9200,"x":223,"y":152},{"time":9220,"x":223,"y":151},{"time":9265,"x":223,"y":149},{"time":9286,"x":223,"y":148},{"time":9307,"x":223,"y":147},{"time":9331,"x":223,"y":146},{"time":9353,"x":223,"y":145},{"time":9399,"x":223,"y":144},{"time":9481,"x":223,"y":143},{"time":9502,"x":223,"y":142},{"time":9543,"x":224,"y":141},{"time":9623,"x":224,"y":140},{"time":9708,"x":224,"y":139},{"time":9755,"x":223,"y":138},{"time":9795,"x":222,"y":138},{"time":9858,"x":222,"y":139},{"time":9900,"x":221,"y":140},{"time":9941,"x":221,"y":141},{"time":9965,"x":220,"y":141},{"time":10026,"x":221,"y":142},{"time":10109,"x":221,"y":143},{"time":10134,"x":221,"y":144},{"time":10155,"x":220,"y":145},{"time":10222,"x":221,"y":145},{"time":10284,"x":221,"y":147},{"time":10304,"x":220,"y":150},{"time":10388,"x":221,"y":150},{"time":10408,"x":221,"y":151},{"time":10454,"x":221,"y":153},{"time":10475,"x":221,"y":154},{"time":10540,"x":222,"y":154},{"time":10560,"x":223,"y":154},{"time":10580,"x":224,"y":154},{"time":10621,"x":224,"y":155},{"time":10642,"x":222,"y":159},{"time":10664,"x":222,"y":160},{"time":10684,"x":221,"y":161},{"time":10746,"x":222,"y":161},{"time":10809,"x":222,"y":162},{"time":10835,"x":222,"y":164},{"time":10856,"x":222,"y":165},{"time":10965,"x":222,"y":166},{"time":10986,"x":222,"y":167},{"time":11007,"x":222,"y":168},{"time":11072,"x":224,"y":168},{"time":11134,"x":224,"y":169},{"time":11154,"x":224,"y":170},{"time":11174,"x":224,"y":171}]},{"id":0,"col":16777010,"fx":197,"time":12976,"fy":211,"type":"draw","childlist":[{"time":13015,"x":196,"y":211},{"time":13055,"x":195,"y":210},{"time":13076,"x":192,"y":210},{"time":13102,"x":190,"y":209},{"time":13122,"x":189,"y":209},{"time":13143,"x":187,"y":209},{"time":13168,"x":185,"y":209},{"time":13188,"x":184,"y":209},{"time":13209,"x":182,"y":209},{"time":13234,"x":180,"y":210},{"time":13255,"x":179,"y":211},{"time":13275,"x":178,"y":212},{"time":13302,"x":176,"y":215},{"time":13321,"x":174,"y":218},{"time":13341,"x":172,"y":221},{"time":13364,"x":171,"y":223},{"time":13384,"x":171,"y":224},{"time":13404,"x":170,"y":226},{"time":13424,"x":169,"y":231},{"time":13444,"x":168,"y":235},{"time":13465,"x":168,"y":236},{"time":13485,"x":167,"y":240},{"time":13505,"x":167,"y":241},{"time":13526,"x":166,"y":243},{"time":13553,"x":166,"y":245},{"time":13575,"x":166,"y":247},{"time":13600,"x":166,"y":250},{"time":13620,"x":166,"y":253},{"time":13640,"x":167,"y":258},{"time":13667,"x":168,"y":262},{"time":13687,"x":168,"y":265},{"time":13706,"x":169,"y":267},{"time":13725,"x":169,"y":268},{"time":13750,"x":170,"y":270},{"time":13769,"x":171,"y":272},{"time":13788,"x":172,"y":273},{"time":13808,"x":173,"y":275},{"time":13827,"x":173,"y":276},{"time":13851,"x":174,"y":277},{"time":13870,"x":175,"y":278},{"time":13891,"x":177,"y":279},{"time":13912,"x":179,"y":280},{"time":13935,"x":180,"y":281},{"time":13956,"x":181,"y":282},{"time":13976,"x":182,"y":282},{"time":14002,"x":185,"y":283},{"time":14022,"x":187,"y":283},{"time":14043,"x":188,"y":283},{"time":14065,"x":190,"y":283},{"time":14086,"x":192,"y":283},{"time":14107,"x":193,"y":283},{"time":14132,"x":196,"y":282},{"time":14152,"x":198,"y":281},{"time":14172,"x":199,"y":280},{"time":14193,"x":200,"y":279},{"time":14215,"x":201,"y":279},{"time":14235,"x":202,"y":278},{"time":14254,"x":204,"y":277},{"time":14274,"x":204,"y":276},{"time":14300,"x":206,"y":274},{"time":14320,"x":207,"y":273},{"time":14340,"x":208,"y":271},{"time":14368,"x":210,"y":266},{"time":14388,"x":211,"y":264},{"time":14409,"x":211,"y":262},{"time":14435,"x":211,"y":260},{"time":14455,"x":212,"y":258},{"time":14475,"x":212,"y":255},{"time":14499,"x":212,"y":252},{"time":14519,"x":212,"y":250},{"time":14539,"x":212,"y":249},{"time":14567,"x":212,"y":245},{"time":14587,"x":212,"y":240},{"time":14608,"x":211,"y":236},{"time":14634,"x":210,"y":232},{"time":14654,"x":209,"y":228},{"time":14673,"x":209,"y":227},{"time":14693,"x":208,"y":225},{"time":14714,"x":207,"y":223},{"time":14735,"x":206,"y":221},{"time":14754,"x":205,"y":218},{"time":14774,"x":204,"y":216},{"time":14793,"x":203,"y":214},{"time":14815,"x":202,"y":212},{"time":14836,"x":201,"y":211},{"time":14857,"x":200,"y":210},{"time":14878,"x":199,"y":209},{"time":14899,"x":197,"y":208},{"time":14920,"x":193,"y":206},{"time":14940,"x":191,"y":205},{"time":14968,"x":190,"y":205},{"time":14989,"x":189,"y":205},{"time":15035,"x":188,"y":206}]},{"id":0,"col":16777010,"fx":274,"time":15647,"fy":205,"type":"draw","childlist":[{"time":15667,"x":272,"y":204},{"time":15687,"x":271,"y":204},{"time":15734,"x":270,"y":204},{"time":15754,"x":265,"y":206},{"time":15774,"x":263,"y":208},{"time":15794,"x":262,"y":208},{"time":15814,"x":260,"y":211},{"time":15835,"x":257,"y":214},{"time":15855,"x":256,"y":217},{"time":15874,"x":254,"y":220},{"time":15899,"x":254,"y":224},{"time":15919,"x":253,"y":230},{"time":15939,"x":252,"y":233},{"time":15958,"x":252,"y":235},{"time":15978,"x":252,"y":237},{"time":16000,"x":252,"y":238},{"time":16019,"x":252,"y":243},{"time":16039,"x":252,"y":249},{"time":16059,"x":253,"y":253},{"time":16081,"x":254,"y":258},{"time":16103,"x":255,"y":260},{"time":16123,"x":256,"y":263},{"time":16143,"x":256,"y":264},{"time":16165,"x":256,"y":265},{"time":16186,"x":257,"y":267},{"time":16207,"x":258,"y":269},{"time":16233,"x":258,"y":270},{"time":16254,"x":258,"y":271},{"time":16275,"x":259,"y":271},{"time":16301,"x":260,"y":272},{"time":16321,"x":261,"y":273},{"time":16342,"x":263,"y":275},{"time":16367,"x":264,"y":276},{"time":16386,"x":265,"y":276},{"time":16405,"x":266,"y":277},{"time":16425,"x":268,"y":278},{"time":16444,"x":270,"y":279},{"time":16468,"x":274,"y":280},{"time":16487,"x":275,"y":280},{"time":16506,"x":276,"y":280},{"time":16525,"x":278,"y":280},{"time":16548,"x":279,"y":280},{"time":16569,"x":281,"y":279},{"time":16589,"x":283,"y":278},{"time":16610,"x":285,"y":277},{"time":16633,"x":286,"y":277},{"time":16654,"x":288,"y":275},{"time":16674,"x":289,"y":275},{"time":16694,"x":290,"y":273},{"time":16716,"x":290,"y":272},{"time":16736,"x":291,"y":271},{"time":16756,"x":292,"y":269},{"time":16776,"x":292,"y":265},{"time":16802,"x":293,"y":262},{"time":16823,"x":293,"y":260},{"time":16843,"x":293,"y":259},{"time":16868,"x":293,"y":257},{"time":16888,"x":294,"y":255},{"time":16908,"x":294,"y":250},{"time":16933,"x":294,"y":247},{"time":16953,"x":294,"y":245},{"time":16974,"x":294,"y":242},{"time":16994,"x":294,"y":238},{"time":17017,"x":293,"y":234}, {"time":17038,"x":292,"y":232},{"time":17058,"x":292,"y":231},{"time":17082,"x":292,"y":228},{"time":17103,"x":291,"y":226},{"time":17123,"x":290,"y":223},{"time":17143,"x":290,"y":222},{"time":17165,"x":288,"y":219},{"time":17184,"x":286,"y":215},{"time":17204,"x":285,"y":214},{"time":17224,"x":284,"y":212},{"time":17268,"x":283,"y":211},{"time":17288,"x":283,"y":210},{"time":17308,"x":282,"y":209},{"time":17336,"x":280,"y":207},{"time":17355,"x":278,"y":205},{"time":17399,"x":277,"y":204},{"time":17418,"x":276,"y":204},{"time":17438,"x":272,"y":203},{"time":17458,"x":270,"y":203},{"time":17480,"x":268,"y":203},{"time":17502,"x":267,"y":203}]},{"id":0,"col":16777010,"fx":286,"time":18055,"fy":232,"type":"draw","childlist":[{"time":18121,"x":286,"y":231},{"time":18141,"x":286,"y":230},{"time":18168,"x":283,"y":228},{"time":18189,"x":282,"y":228},{"time":18208,"x":280,"y":228},{"time":18235,"x":279,"y":228},{"time":18255,"x":278,"y":228},{"time":18274,"x":277,"y":228},{"time":18299,"x":275,"y":229},{"time":18318,"x":274,"y":231},{"time":18337,"x":272,"y":233},{"time":18357,"x":269,"y":237},{"time":18378,"x":268,"y":240},{"time":18399,"x":268,"y":243},{"time":18418,"x":267,"y":247},{"time":18438,"x":266,"y":252},{"time":18458,"x":266,"y":256},{"time":18480,"x":265,"y":258},{"time":18502,"x":265,"y":260},{"time":18522,"x":265,"y":262},{"time":18543,"x":265,"y":263},{"time":18569,"x":265,"y":266},{"time":18589,"x":266,"y":269},{"time":18632,"x":267,"y":270},{"time":18654,"x":267,"y":271},{"time":18674,"x":268,"y":273},{"time":18699,"x":269,"y":274},{"time":18720,"x":270,"y":275},{"time":18807,"x":270,"y":274}]},{"id":0,"col":16777010,"fx":208,"time":19603,"fy":235,"type":"draw","childlist":[{"time":19609,"x":209,"y":235},{"time":19672,"x":208,"y":234},{"time":19700,"x":206,"y":233},{"time":19719,"x":205,"y":232},{"time":19740,"x":204,"y":231},{"time":19768,"x":201,"y":230},{"time":19789,"x":200,"y":230},{"time":19810,"x":199,"y":230},{"time":19836,"x":198,"y":230},{"time":19856,"x":197,"y":231},{"time":19876,"x":196,"y":231},{"time":19902,"x":195,"y":233},{"time":19922,"x":194,"y":234},{"time":19942,"x":194,"y":235},{"time":19968,"x":193,"y":236},{"time":19987,"x":192,"y":237},{"time":20006,"x":192,"y":238},{"time":20025,"x":191,"y":239},{"time":20047,"x":191,"y":240},{"time":20066,"x":191,"y":241},{"time":20085,"x":190,"y":243},{"time":20105,"x":190,"y":246},{"time":20125,"x":190,"y":247},{"time":20149,"x":190,"y":248},{"time":20170,"x":189,"y":250},{"time":20190,"x":189,"y":252},{"time":20210,"x":189,"y":254},{"time":20235,"x":189,"y":256},{"time":20255,"x":189,"y":257},{"time":20275,"x":189,"y":258},{"time":20302,"x":189,"y":259},{"time":20322,"x":189,"y":260},{"time":20370,"x":189,"y":261},{"time":20389,"x":189,"y":262},{"time":20410,"x":189,"y":263},{"time":20433,"x":189,"y":264},{"time":20454,"x":189,"y":266},{"time":20474,"x":190,"y":267},{"time":20494,"x":190,"y":268},{"time":20516,"x":190,"y":269},{"time":20556,"x":190,"y":270},{"time":20576,"x":190,"y":271},{"time":20603,"x":190,"y":272},{"time":20622,"x":191,"y":273},{"time":20669,"x":191,"y":274},{"time":20726,"x":192,"y":275},{"time":20775,"x":192,"y":276},{"time":20820,"x":193,"y":276},{"time":20840,"x":193,"y":277},{"time":20909,"x":194,"y":277},{"time":21053,"x":195,"y":278},{"time":21269,"x":196,"y":278}]},{"id":0,"col":16777010,"fx":203,"time":22343,"fy":238,"type":"draw","childlist":[{"time":22368,"x":203,"y":237},{"time":22407,"x":202,"y":239},{"time":22437,"x":197,"y":248},{"time":22456,"x":195,"y":253},{"time":22477,"x":194,"y":257},{"time":22527,"x":196,"y":256},{"time":22549,"x":201,"y":251},{"time":22569,"x":204,"y":250},{"time":22607,"x":204,"y":251},{"time":22626,"x":204,"y":253},{"time":22647,"x":201,"y":260},{"time":22669,"x":198,"y":265},{"time":22688,"x":198,"y":266},{"time":22733,"x":199,"y":266},{"time":22752,"x":203,"y":263},{"time":22771,"x":205,"y":262},{"time":22811,"x":203,"y":268},{"time":22833,"x":198,"y":277},{"time":22854,"x":195,"y":281},{"time":22919,"x":196,"y":281}]},{"id":0,"col":16777010,"fx":283,"time":23707,"fy":230,"type":"draw","childlist":[{"time":23790,"x":280,"y":233},{"time":23810,"x":276,"y":239},{"time":23841,"x":273,"y":244},{"time":23860,"x":273,"y":245},{"time":23920,"x":277,"y":243},{"time":23939,"x":283,"y":239},{"time":23958,"x":286,"y":238},{"time":24021,"x":284,"y":242},{"time":24041,"x":282,"y":245},{"time":24060,"x":278,"y":250},{"time":24081,"x":276,"y":254},{"time":24101,"x":274,"y":256},{"time":24164,"x":276,"y":255},{"time":24183,"x":284,"y":247},{"time":24203,"x":289,"y":244},{"time":24223,"x":290,"y":244},{"time":24244,"x":290,"y":245},{"time":24266,"x":286,"y":249},{"time":24287,"x":281,"y":255},{"time":24307,"x":277,"y":260},{"time":24333,"x":277,"y":261},{"time":24375,"x":278,"y":260},{"time":24401,"x":283,"y":257},{"time":24421,"x":288,"y":255},{"time":24441,"x":290,"y":255},{"time":24484,"x":290,"y":256},{"time":24505,"x":286,"y":261},{"time":24525,"x":282,"y":266},{"time":24549,"x":280,"y":269},{"time":24570,"x":279,"y":271},{"time":24636,"x":280,"y":271},{"time":24703,"x":279,"y":272},{"time":24722,"x":278,"y":273}]},{"id":0,"col":16777010,"fx":172,"time":25715,"fy":338,"type":"draw","childlist":[{"time":25835,"x":171,"y":339},{"time":25855,"x":171,"y":340},{"time":25875,"x":169,"y":341},{"time":25900,"x":168,"y":343},{"time":25920,"x":167,"y":344},{"time":25941,"x":166,"y":345},{"time":25968,"x":163,"y":350},{"time":25988,"x":161,"y":353},{"time":26009,"x":161,"y":354},{"time":26036,"x":160,"y":356},{"time":26056,"x":159,"y":358},{"time":26077,"x":159,"y":359},{"time":26104,"x":158,"y":361},{"time":26123,"x":158,"y":362},{"time":26142,"x":158,"y":363},{"time":26168,"x":157,"y":364},{"time":26187,"x":157,"y":365},{"time":26206,"x":157,"y":367},{"time":26225,"x":157,"y":368},{"time":26248,"x":156,"y":370},{"time":26272,"x":156,"y":372},{"time":26291,"x":155,"y":373},{"time":26310,"x":155,"y":374},{"time":26337,"x":154,"y":376},{"time":26356,"x":154,"y":377},{"time":26376,"x":154,"y":378},{"time":26403,"x":154,"y":379},{"time":26422,"x":154,"y":380},{"time":26441,"x":153,"y":381},{"time":26460,"x":153,"y":382},{"time":26482,"x":153,"y":383},{"time":26503,"x":153,"y":384},{"time":26523,"x":153,"y":385},{"time":26543,"x":153,"y":386},{"time":26570,"x":153,"y":387},{"time":26589,"x":153,"y":388},{"time":26610,"x":153,"y":389},{"time":26655,"x":153,"y":390},{"time":26674,"x":153,"y":391},{"time":26701,"x":153,"y":392},{"time":26720,"x":153,"y":393},{"time":26739,"x":153,"y":394},{"time":26758,"x":153,"y":396},{"time":26779,"x":153,"y":397},{"time":26809,"x":153,"y":398},{"time":26837,"x":153,"y":399},{"time":26857,"x":153,"y":400},{"time":26877,"x":154,"y":401},{"time":26904,"x":154,"y":402},{"time":26923,"x":155,"y":403},{"time":26964,"x":156,"y":403},{"time":26983,"x":157,"y":404},{"time":27002,"x":158,"y":404},{"time":27021,"x":159,"y":405},{"time":27040,"x":160,"y":405},{"time":27059,"x":161,"y":405},{"time":27080,"x":162,"y":405},{"time":27102,"x":163,"y":405},{"time":27122,"x":164,"y":405},{"time":27141,"x":165,"y":405},{"time":27164,"x":167,"y":403},{"time":27184,"x":168,"y":403},{"time":27225,"x":169,"y":403},{"time":27245,"x":170,"y":402},{"time":27265,"x":171,"y":402},{"time":27285,"x":173,"y":401},{"time":27306,"x":173,"y":400},{"time":27331,"x":174,"y":399},{"time":27351,"x":175,"y":398},{"time":27371,"x":176,"y":397},{"time":27391,"x":177,"y":397},{"time":27412,"x":177,"y":396},{"time":27434,"x":178,"y":395},{"time":27455,"x":179,"y":394},{"time":27475,"x":180,"y":392},{"time":27503,"x":181,"y":391},{"time":27523,"x":181,"y":390},{"time":27542,"x":182,"y":389},{"time":27569,"x":183,"y":388},{"time":27588,"x":183,"y":387},{"time":27607,"x":184,"y":386},{"time":27650,"x":184,"y":385},{"time":27670,"x":185,"y":383},{"time":27690,"x":185,"y":382},{"time":27710,"x":186,"y":381},{"time":27736,"x":186,"y":380},{"time":28223,"x":187,"y":381},{"time":28237,"x":187,"y":382},{"time":28252,"x":187,"y":383},{"time":28270,"x":187,"y":384},{"time":28293,"x":186,"y":385},{"time":28302,"x":186,"y":386},{"time":28323,"x":186,"y":387},{"time":28349,"x":186,"y":388},{"time":28361,"x":186,"y":389},{"time":28387,"x":186,"y":390},{"time":28419,"x":186,"y":391},{"time":28442,"x":186,"y":392},{"time":28470,"x":186,"y":394},{"time":28505,"x":186,"y":395},{"time":28538,"x":186,"y":397},{"time":28568,"x":186,"y":399},{"time":28596,"x":185,"y":401},{"time":28624,"x":185,"y":403},{"time":28651,"x":185,"y":405},{"time":28673,"x":185,"y":407},{"time":28695,"x":185,"y":409},{"time":28717,"x":185,"y":411},{"time":28737,"x":185,"y":413},{"time":28756,"x":185,"y":414},{"time":28776,"x":185,"y":415},{"time":28797,"x":185,"y":417},{"time":28823,"x":185,"y":419},{"time":28856,"x":185,"y":420},{"time":28873,"x":185,"y":421},{"time":28889,"x":185,"y":422},{"time":28904,"x":185,"y":423},{"time":28922,"x":185,"y":424},{"time":28938,"x":185,"y":425},{"time":28956,"x":185,"y":426},{"time":28975,"x":185,"y":427},{"time":28994,"x":185,"y":428},{"time":29021,"x":185,"y":429},{"time":29041,"x":185,"y":430},{"time":29061,"x":185,"y":431},{"time":29088,"x":185,"y":432},{"time":29108,"x":185,"y":433},{"time":29131,"x":185,"y":435},{"time":29155,"x":185,"y":436},{"time":29175,"x":185,"y":437},{"time":29198,"x":185,"y":438},{"time":29222,"x":185,"y":439},{"time":29242,"x":185,"y":440},{"time":29265,"x":185,"y":441},{"time":29288,"x":185,"y":442},{"time":29312,"x":185,"y":443},{"time":29335,"x":185,"y":444},{"time":29355,"x":186,"y":444},{"time":29374,"x":186,"y":445},{"time":29394,"x":187,"y":446},{"time":29421,"x":188,"y":447},{"time":29439,"x":189,"y":447},{"time":29458,"x":189,"y":448},{"time":29476,"x":190,"y":448},{"time":29497,"x":192,"y":449},{"time":29521,"x":193,"y":450},{"time":29558,"x":194,"y":450},{"time":29576,"x":196,"y":450},{"time":29597,"x":197,"y":450},{"time":29621,"x":198,"y":450},{"time":29658,"x":199,"y":449},{"time":29689,"x":201,"y":449},{"time":29707,"x":202,"y":449},{"time":29726,"x":203,"y":449},{"time":29754,"x":204,"y":448},{"time":29791,"x":205,"y":448},{"time":29821,"x":207,"y":446},{"time":29839,"x":208,"y":444},{"time":29861,"x":209,"y":443},{"time":29906,"x":209,"y":442},{"time":29925,"x":210,"y":441},{"time":29953,"x":211,"y":438},{"time":29971,"x":211,"y":437},{"time":30008,"x":212,"y":436},{"time":30028,"x":212,"y":435},{"time":30049,"x":212,"y":434},{"time":30068,"x":213,"y":433},{"time":30105,"x":213,"y":432},{"time":30125,"x":213,"y":431},{"time":30152,"x":213,"y":430},{"time":30172,"x":213,"y":429},{"time":30192,"x":214,"y":429},{"time":30220,"x":214,"y":428},{"time":30239,"x":214,"y":427},{"time":30258,"x":214,"y":426},{"time":30306,"x":215,"y":425},{"time":30487,"x":215,"y":424},{"time":30555,"x":215,"y":422},{"time":30574,"x":215,"y":421},{"time":30592,"x":216,"y":420},{"time":30657,"x":216,"y":418},{"time":31020,"x":215,"y":419},{"time":31040,"x":214,"y":419},{"time":31287,"x":214,"y":420},{"time":31306,"x":215,"y":420},{"time":31369,"x":216,"y":421},{"time":31431,"x":217,"y":421},{"time":31455,"x":218,"y":421},{"time":31474,"x":220,"y":421},{"time":31494,"x":221,"y":421},{"time":31523,"x":222,"y":421},{"time":31560,"x":223,"y":421},{"time":31588,"x":224,"y":421},{"time":31627,"x":225,"y":421},{"time":31655,"x":227,"y":421},{"time":31673,"x":228,"y":421},{"time":31691,"x":229,"y":421},{"time":31721,"x":230,"y":421},{"time":31739,"x":230,"y":422},{"time":31757,"x":233,"y":422},{"time":31776,"x":234,"y":422},{"time":31798,"x":236,"y":422},{"time":31821,"x":238,"y":422},{"time":31840,"x":239,"y":422},{"time":31859,"x":241,"y":422},{"time":31888,"x":243,"y":421},{"time":31906,"x":244,"y":421},{"time":31941,"x":245,"y":421},{"time":31960,"x":247,"y":420},{"time":31988,"x":252,"y":418},{"time":32006,"x":253,"y":418},{"time":32025,"x":255,"y":417},{"time":32044,"x":258,"y":416},{"time":32066,"x":260,"y":416},{"time":32088,"x":260,"y":415},{"time":32107,"x":261,"y":415},{"time":32173,"x":262,"y":415},{"time":32360,"x":263,"y":418},{"time":32386,"x":263,"y":423},{"time":32403,"x":264,"y":425},{"time":32422,"x":264,"y":428},{"time":32441,"x":265,"y":430},{"time":32460,"x":266,"y":431},{"time":32485,"x":266,"y":432},{"time":32503,"x":267,"y":433},{"time":32523,"x":267,"y":434},{"time":32542,"x":268,"y":436},{"time":32562,"x":268,"y":438},{"time":32588,"x":269,"y":438},{"time":32606,"x":269,"y":439},{"time":32642,"x":270,"y":440},{"time":32663,"x":270,"y":441},{"time":32687,"x":271,"y":441},{"time":32706,"x":271,"y":442},{"time":32725,"x":272,"y":442},{"time":32755,"x":273,"y":443},{"time":32791,"x":274,"y":443},{"time":32831,"x":275,"y":443},{"time":32854,"x":276,"y":444},{"time":32873,"x":277,"y":444},{"time":32893,"x":278,"y":444},{"time":32921,"x":280,"y":444},{"time":32940,"x":281,"y":444},{"time":32988,"x":282,"y":444},{"time":33028,"x":283,"y":444},{"time":33055,"x":284,"y":444},{"time":33074,"x":285,"y":444},{"time":33138,"x":286,"y":443},{"time":33157,"x":287,"y":442},{"time":33176,"x":288,"y":442},{"time":33196,"x":288,"y":441},{"time":33238,"x":289,"y":439},{"time":33257,"x":290,"y":438},{"time":33276,"x":290,"y":437},{"time":33297,"x":291,"y":434},{"time":33321,"x":291,"y":432},{"time":33340,"x":291,"y":431},{"time":33359,"x":291,"y":429},{"time":33388,"x":292,"y":425},{"time":33406,"x":292,"y":423},{"time":33425,"x":292,"y":421},{"time":33455,"x":292,"y":419},{"time":33474,"x":292,"y":417},{"time":33493,"x":292,"y":415},{"time":33520,"x":292,"y":413},{"time":33538,"x":292,"y":412},{"time":33556,"x":292,"y":410},{"time":33575,"x":291,"y":409},{"time":33597,"x":291,"y":407},{"time":33619,"x":290,"y":402},{"time":33639,"x":289,"y":399},{"time":33658,"x":289,"y":398},{"time":33687,"x":288,"y":396},{"time":33706,"x":288,"y":395},{"time":33724,"x":288,"y":393},{"time":33744,"x":287,"y":392},{"time":33765,"x":287,"y":391},{"time":33791,"x":287,"y":390},{"time":33809,"x":287,"y":389},{"time":33830,"x":287,"y":388},{"time":33853,"x":287,"y":387},{"time":33873,"x":287,"y":386},{"time":33893,"x":286,"y":384},{"time":33915,"x":286,"y":381},{"time":33935,"x":286,"y":380},{"time":33956,"x":286,"y":379},{"time":33998,"x":286,"y":377},{"time":34020,"x":286,"y":376},{"time":34041,"x":285,"y":375},{"time":34062,"x":285,"y":374},{"time":34106,"x":285,"y":373},{"time":34194,"x":285,"y":372},{"time":34361,"x":285,"y":375},{"time":34389,"x":287,"y":380},{"time":34408,"x":288,"y":385},{"time":34431,"x":289,"y":388},{"time":34455,"x":290,"y":390},{"time":34474,"x":291,"y":392},{"time":34495,"x":292,"y":394},{"time":34521,"x":293,"y":398},{"time":34541,"x":293,"y":399},{"time":34561,"x":294,"y":400},{"time":34585,"x":294,"y":401},{"time":34605,"x":295,"y":401},{"time":34625,"x":295,"y":402},{"time":34653,"x":296,"y":403},{"time":34718,"x":297,"y":404},{"time":34737,"x":298,"y":404},{"time":34775,"x":299,"y":405},{"time":34801,"x":300,"y":405},{"time":34839,"x":301,"y":405},{"time":34860,"x":302,"y":405},{"time":34885,"x":303,"y":405},{"time":34925,"x":304,"y":404},{"time":34992,"x":305,"y":404},{"time":35016,"x":306,"y":404},{"time":35036,"x":307,"y":403},{"time":35096,"x":308,"y":403},{"time":35118,"x":308,"y":402},{"time":35140,"x":309,"y":402},{"time":35188,"x":310,"y":402},{"time":35209,"x":310,"y":401},{"time":35230,"x":311,"y":400},{"time":35275,"x":312,"y":399},{"time":35322,"x":313,"y":398},{"time":35342,"x":313,"y":397},{"time":35365,"x":314,"y":397},{"time":35388,"x":314,"y":396},{"time":35408,"x":315,"y":395},{"time":35430,"x":315,"y":394},{"time":35454,"x":316,"y":392},{"time":35474,"x":316,"y":391},{"time":35493,"x":316,"y":390},{"time":35521,"x":316,"y":389},{"time":35540,"x":316,"y":388},{"time":35559,"x":316,"y":386},{"time":35588,"x":316,"y":384},{"time":35609,"x":316,"y":382},{"time":35630,"x":316,"y":381},{"time":35655,"x":316,"y":380},{"time":35674,"x":316,"y":379},{"time":35694,"x":316,"y":377},{"time":35720,"x":316,"y":376},{"time":35739,"x":316,"y":375},{"time":35787,"x":316,"y":374},{"time":35806,"x":316,"y":373},{"time":35826,"x":315,"y":372},{"time":35855,"x":315,"y":371},{"time":35874,"x":315,"y":370},{"time":35920,"x":315,"y":369},{"time":35958,"x":314,"y":368},{"time":35988,"x":314,"y":366},{"time":36006,"x":313,"y":365},{"time":36025,"x":313,"y":364},{"time":36043,"x":313,"y":363},{"time":36064,"x":312,"y":362},{"time":36088,"x":312,"y":361},{"time":36125,"x":311,"y":360},{"time":36144,"x":311,"y":359},{"time":36170,"x":311,"y":358},{"time":36189,"x":311,"y":357},{"time":36208,"x":310,"y":357},{"time":36229,"x":310,"y":356},{"time":36253,"x":310,"y":355},{"time":36273,"x":309,"y":354},{"time":36318,"x":308,"y":352},{"time":36338,"x":308,"y":351},{"time":36358,"x":307,"y":351},{"time":36383,"x":307,"y":350},{"time":36403,"x":307,"y":349},{"time":36452,"x":306,"y":348},{"time":36491,"x":306,"y":347},{"time":36538,"x":306,"y":346},{"time":36558,"x":305,"y":346},{"time":36606,"x":305,"y":345},{"time":36672,"x":305,"y":344},{"time":36715,"x":304,"y":344},{"time":36757,"x":304,"y":343},{"time":36821,"x":303,"y":343},{"time":36840,"x":303,"y":342},{"time":37022,"x":302,"y":342},{"time":37041,"x":298,"y":341}]}]';
			//			
			var comList:Array = JSON.decode(comListString);
			
			_player.setCommandList(comList);
			musicStart();
			_ch.stop();
		}
		
		private function musicStart():void {
			sound = new Sound(new URLRequest("http://swimmingbird.heteml.jp/wonderfl/sounds/stars.mp3"), new SoundLoaderContext(10000, true));
//			sound = new Sound(new URLRequest("http://swimmingbird.heteml.jp/wonderfl/sounds/stars_long.mp3"), new SoundLoaderContext(10000, true));
			_ch = sound.play();
			bA = new ByteArray();
			//			stage.quality = StageQuality.LOW;
			stage.fullScreenSourceRect=new Rectangle(0,0,465,465); 
			addEventListener(Event.ENTER_FRAME, updateSpectrum);
			
			//timer start
			_startTime = getTimer();
			
			/**
			 * action setup
			 */
			_field.addEventListener(MouseEvent.MOUSE_DOWN, _fieldDownHandler);
			_field.addEventListener(MouseEvent.MOUSE_UP, _fieldUpHandler);
			_field.addEventListener(Event.ENTER_FRAME, _enterFrameHandler);
			
			//Play Draw
			_player.addEventListener(DrawPlayer.DO_ROOT, _rootEventHandler);
			_player.addEventListener(DrawPlayer.DO_NODE, _nodeEventHandler);
			_player.addEventListener(DrawPlayer.DO_CLEAR, _clearEventHandler);
		}
		
		public function setupDisplay():void {
			addChild(_paintField);
			addChild(_field);
			addChild(_clearEffBmp);
			addChild(_uiField);
			addChild(_stopUiField);
			addChild(_startField);
			_uiField.addChild(_colSelector);
			_colSelector.x = 20;
			_colSelector.y = 85;
			_stopUiField.visible = true;
			_uiField.visible = false;
			_startField.visible = false;
		}
		/**
		 * mouse Action
		 */
		private function _fieldDownHandler(event:MouseEvent):void {
			addRoot();
			_col = _colSelector.currentColor;
			_field.addEventListener(MouseEvent.MOUSE_MOVE, _fieldMoveHandler);
			var currentTime:int = getTimer() - _startTime;
			var id:int=0;
			_rec.startLineRec(id,mouseX,mouseY,_colSelector.currentColor,currentTime);
		}
		private function _fieldUpHandler(event:MouseEvent):void {
			//今書いたものにベクトル情報追加
			_field.removeEventListener(MouseEvent.MOUSE_MOVE, _fieldMoveHandler);
		}
		private function _fieldMoveHandler(event:MouseEvent):void {
			addNode(_field.mouseX, _field.mouseY);
			//rec
			var currentTime:int = getTimer() - _startTime;
			_rec.addPoint(_field.mouseX, _field.mouseY, currentTime);
		}
		/**
		 * play Action
		 */
		private function _rootEventHandler(event:Event):void {
			addRoot();
			_col = _player.cur_Col;
		}
		private function _nodeEventHandler(event:Event):void {
			addNode(_player.cur_x, _player.cur_y);	
		}
		private function _clearEventHandler(event:Event):void {
			clear();
		}
		/**
		 * node Action
		 */
		private function addRoot():void {
			trace("adRoot");
			_currentListIndex = _pointListList.length;
			_pointListList.push(new Array());
		}
		private function addNode(px:Number, py:Number):void {
			trace("addNode");
			var _list:Array = _pointListList[_currentListIndex];
			_list.push(new LinePoint(px, py));
			var i:int = _list.length-1;
			_list[i].color = _col;
			if(_list[i-1]) {
				var _pt:LinePoint = _list[i];
				var _dx:Number = _list[i].x - _list[i-1].x;
				var _dy:Number = _list[i].y - _list[i-1].y;
				var _distance:Number = Math.sqrt(_dx*_dx+_dy*_dy);
				_pt.vx = _list[i].x - _list[i-1].x;
				_pt.vy = _list[i].y - _list[i-1].y;
				//				_pt.vx = _dx/_distance;
				//				_pt.vy = _dy/_distance;
				_pt.genRotation();
			}
		}
		private function _enterFrameHandler(event:Event):void {
			var i:int;
			var len:int = _pointListList.length;
			_paintField.graphics.clear();
			_paintField.graphics.lineStyle(1,0xFFFFFF);
			var _list:Array;
			var j:int;
			var _listlen:int;
			var nx:Number;
			var ny:Number;
			var dist:Number;
			if(_actionFlg) {
				for(i=0; i<len; i++) {
					_list = _pointListList[i];
					_listlen = _list.length;
					if(_listlen>0) {
						_paintField.graphics.lineStyle(1,_list[0].color);
						_paintField.graphics.moveTo(_list[0].x, _list[0].y);
						//スペクトラムずらす
						for(j=_listlen-1;j>0;j--) {
							_list[j].spectrum = _list[j-1].spectrum;
						}
						_list[0].spectrum = spectrum[10];
						for(j=0;j<_listlen;j++) {
							//							_paintField.graphics.moveTo(_list[j].x, _list[j].y);
							if(_list[j].r){
								nx = -(_list[j].vy);
								ny = _list[j].vx;
								dist = Math.sqrt(nx*nx+ny*ny);
								//							    _list[j].spectrum = spectrum[j];//スペクトラム直でまっぴんぐ
								_paintField.graphics.lineTo(_list[j].x+nx*_list[j].spectrum*7, _list[j].y+ny*_list[j].spectrum*7);
								//							    _paintField.graphics.lineTo(_list[j].x+_list[j].spectrum*2*nx/dist, _list[j].y+40*_list[j].spectrum*2*ny/dist);
							}
						}
					}
				}
			} else {
				for(i=0; i<len; i++) {
					_list = _pointListList[i];
					_listlen = _list.length;
					if(_listlen>0) {
						_paintField.graphics.moveTo(_list[0].x, _list[0].y); 
						for(j=0;j<_listlen;j++) {
							_paintField.graphics.lineTo(_list[j].x, _list[j].y);
						}
					}
				}
			}
		}
		
		private function updateSpectrum(e:Event):void {
			SoundMixer.computeSpectrum(bA,false,0);
			spectrum = [];
			var i:int;
			for(i=0; i<256; i++){
				spectrum[i] = bA.readFloat();
			}
			for(i=256; i<512; i++){
				spectrum[i] = bA.readFloat();
			}
			bA.position=0;
			lowVal = spectrum[0];
			middleVal = spectrum[1];
			highVal = spectrum[2];
		} 
		
		/**
		 * ui Action
		 */
		private function startHandler(event:MouseEvent):void {
			_startField.visible = false;
			_uiField.visible = true;
			musicStart();
		}
		private function actionHandler(event:MouseEvent):void {
			_actionFlg = true;
		}
		private function noActionHandler(event:MouseEvent):void {
			_actionFlg = false;
		}
		private function clearHandler(event:MouseEvent):void {
			_rec.addClear(getTimer()-_startTime)
			clear();
		}
		private function plotHandler(event:MouseEvent):void {
			_rec.outPut();
		}
		private function stopHandler(event:MouseEvent):void {
			_ch.stop();
			clear();
			_player.setCommandList(_rec.commandList);
			Tweener.addTween(_uiField, {_autoAlpha:0, time:0.5, transition:Equations.easeOutQuint});
			Tweener.addTween(_stopUiField, {_autoAlpha:1, time:0.5, transition:Equations.easeOutQuint});
		}
		private function playDataHandler(event:MouseEvent):void {
			_ch = sound.play(0);
			_player.playStart();
		}
		private function stopDrawHandler(event:MouseEvent):void {
			clear();
			_currentListIndex = 0;
			_ch.stop();
			_player.playStop();
		}
		public var clearCnt:Number = 0;
		private function clear():void {
			_clearBmd.fillRect(new Rectangle(0,0,465,465),0);
			_clearBmd.draw(_paintField);
			_clearEffBmp.visible = true;
			_clearEffBmp.alpha = 1;
			_clearEffBmp.scaleX = _clearEffBmp.scaleY = 1;
			Tweener.addTween(_clearEffBmp, {/*scaleX:2, scaleY:2, */_autoAlpha:0, time:1, transition:Equations.easeOutQuint});
			clearComp();
			//			var i:int;
			//			var len:int = _pointListList.length;
			//			var _list:Array;
			//			var _listlen:int;
			//			var j:int;
			//			var nx:int, ny:int;
			//			for(i=0; i<len; i++) {
			//				_list = _pointListList[i];
			//				_listlen = _list.length;
			//				for(j=0;j<_listlen;j++) {
			//					_list[j].endAction();
			//				}
			//			}
			//			Tweener.addTween(this, {clearCnt:10, time:0.8, transition:Equations.easeOutQuint, onComplete:clearComp});
		}
		private function clearComp():void {
			var i:int;
			var len:int = _pointListList.length;
			var _list:Array;
			var _listlen:int;
			var j:int;
			var nx:int, ny:int;
			for(i=0; i<len; i++) {
				_list = _pointListList[i];
				_listlen = _list.length;
				for(j=0;j<_listlen;j++) {
					_list[j] = null;
				}
			}
			for(i=0; i<len; i++) {
				_list = _pointListList[i];
				_list.length = 0;
				_list = null;
			}
			_pointListList.length = 0;
			_pointListList = new Array();
		}
	}
}
import caurina.transitions.Equations;
import caurina.transitions.Tweener;

import flash.display.Sprite;
import flash.events.Event;
import flash.events.MouseEvent;
import flash.events.TimerEvent;
import flash.external.ExternalInterface;
import flash.geom.Point;
import flash.utils.Timer;
import flash.utils.getTimer;

import org.osmf.events.TimeEvent;



class LinePoint extends Point {
	public var vx:Number, vy:Number, r:Number;
	public var spectrum:Number = 0;
	public var color:Number;
	public function LinePoint(x:Number=0, y:Number=0) {
		super(x,y);
	}
	public function genRotation():void {
		r = Math.atan2(vy, vx);
	}
	public function endAction():void {
		var _targetSp:Number = spectrum * 20;
		Tweener.addTween(this, {spectrum:_targetSp, time:0.5, transition:Equations.easeOutQuint});
	}
}

class ColorSelector extends Sprite {
	public var colorList:Array = new Array();
	public var currentColor:Number = 0xFFFF32;
	private var _colTotal:int = 5;
	private var _selectedColor:Sprite = new Sprite();
	
	public function ColorSelector() {
		init();
		setupDisplay();
	}
	public function init():void {
		var i:int;
		for(i=0; i<_colTotal; i++) {
			var block:Sprite = new Sprite();
			//			block.name = String(0xFF0000*Math.random());
			block.addEventListener(MouseEvent.CLICK, selectedHandler);
			colorList.push(block);
		}
		colorList[0].name = String(0xFFFF32);
		colorList[1].name = String(0xFFFF99);
		        colorList[2].name = String(0xFFFFCD);
		        colorList[3].name = String(0xFFCC32);
		        colorList[4].name = String(0xFFCC00);
		for(i=0; i<_colTotal; i++) {
			colorList[i].graphics.clear();
			colorList[i].graphics.beginFill(Number(colorList[i].name));
			colorList[i].graphics.drawRect(0,0,10,10);
			colorList[i].graphics.endFill();
		}
		
		currentColor = Number(colorList[0].name);
		_selectedColor.graphics.beginFill(currentColor);
		_selectedColor.graphics.drawRect(0,0,19,19);
		_selectedColor.graphics.endFill();
		
	}
	public function setupDisplay():void {
		addChild(_selectedColor);
		for(var i:int=0; i<_colTotal; i++) {
			addChild(colorList[i]);
			colorList[i].x = i*(colorList[i].width+1);
			colorList[i].y = 20;
		}
	}
	private function selectedHandler(event:MouseEvent):void {
		_selectedColor.graphics.clear();
		currentColor = Number(event.target.name);
		_selectedColor.graphics.beginFill(currentColor);
		_selectedColor.graphics.drawRect(0,0,19,19);
		_selectedColor.graphics.endFill();
	}
}

class DrawPlayer extends Sprite {
	
	public static const DO_ROOT:String = "DoRoot";
	public static const DO_NODE:String = "DoNode";
	public static const DO_CLEAR:String = "DoClear";
	private var _commandList:Array;
	private var _timer:Timer = new Timer(1);
	private var _rootIndex:int = 0;
	private var _nodeIndex:int = 0;
	private var _counter:int = 0;
	private var _watchTarget:int = 0; //0:親, 1:子
	
	//現在の命令
	public var cur_Command:int = 0; //0:親, 1:子
	public var cur_Col:Number;
	public var cur_x:Number;
	public var cur_y:Number;
	
	//timer
	private var _startTime:Number;
	
	public function DrawPlayer() {
		super();
	}
	
	public function setCommandList(list:Array):void {
		_commandList = list;
	}
	
	public function playStart():void {
		_counter = 0;
		_rootIndex = 0;
		_nodeIndex = 0;
		_watchTarget = 0;
		_startTime = getTimer();
		addEventListener(Event.ENTER_FRAME, _commandCheckHandler);
	}
	public function playStop():void {
		removeEventListener(Event.ENTER_FRAME, _commandCheckHandler);
	}
	
	private function _commandCheckHandler(event:Event):void {
		_counter = getTimer()-_startTime;
		//まだ終わってなかったら終わる
		if(_rootIndex == _commandList.length) {
			if(hasEventListener(Event.ENTER_FRAME))removeEventListener(Event.ENTER_FRAME, _commandCheckHandler);
			return;
		}
		if(_watchTarget==0) {
			if(_commandList[_rootIndex].time<=_counter) {
				switch(_commandList[_rootIndex].type) {
					case "clear":
						_watchTarget = 0;
						dispatchEvent(new Event(DO_CLEAR));
						_rootIndex++;
						break;
					case "draw":
						cur_Col = _commandList[_rootIndex].col;
						cur_x = _commandList[_rootIndex].fx;
						cur_y = _commandList[_rootIndex].fy;
						dispatchEvent(new Event(DO_ROOT));
						_watchTarget = 1;
						break;
				}
			}
		} else {
			var obj:Object = _commandList[_rootIndex][_nodeIndex];
			//マウス動かなかった時は親にそのまま向ける
			if(!_commandList[_rootIndex].childlist[_nodeIndex]){
				_rootIndex++;
				_nodeIndex=0;
				_watchTarget=0;
				return;
			}
			if(_commandList[_rootIndex].childlist[_nodeIndex].time<=_counter) {
				cur_x = _commandList[_rootIndex].childlist[_nodeIndex].x;
				cur_y = _commandList[_rootIndex].childlist[_nodeIndex].y;
				dispatchEvent(new Event(DO_NODE));
				_nodeIndex++;
				//最後尾到達で親監視に切り替え
				if(_nodeIndex==_commandList[_rootIndex].length-1) {
					//親も最後尾なら終了
					if(_rootIndex==_commandList.length-1) {
						_timer.removeEventListener(TimerEvent.TIMER, _commandCheckHandler);
						_timer.stop();
						return;
					} else {
						_watchTarget = 0;
						_rootIndex++;
					}
				}
			}
			
		}
	}
	
	private function _commandCheck():void{
		
	}
	
}

class DrawRecoder extends Sprite {
	private var _commandList:Array = new Array();
	public function get commandList():Array {
		return _commandList;
	}
	public function DrawRecoder() {
		
	}
	
	public function startLineRec(_id:int,_mx:Number,_my:Number,_col:Number, _time:Number):void {
		_commandList.push({type:"draw", id:_id,fx:_mx, fy:_my, col:_col, time:_time, childlist:new Array()});
	}
	public function addPoint(_mx:Number, _my:Number, _time:Number):void {
		var _currentList:Array = _commandList[_commandList.length-1].childlist;
		_currentList.push({x:_mx, y:_my, time:_time});
	}
	public function addClear(_time:Number):void {
		_commandList.push({type:"clear", time:_time});
	}
	public function endLineRec():void {
		
	}
	
	public function outPut():void {
		var i:int;
		var j:int;
	}
}