/**
 * Copyright mousepancyo ( http://wonderfl.net/user/mousepancyo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pUCu
 */

package 
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Point;
    import flash.display.BitmapData;

    
    [SWF(width = "465", height = "465", backgroundColor = "0xFFFFFF", frameRate = "60")]
    public class CurveTest extends Sprite
    {
        private var canvas:Sprite;
        private var dot1:Dot = new Dot();
        private var dot2:Dot = new Dot();
        
        private var _speed:Number = 0;
        private var _bmd:BitmapData;

        public function CurveTest()
        {
            canvas = new Sprite();
            canvas.x = canvas.y = 50;
            addChild(canvas);

            canvas.addChild(dot1);
            canvas.addChild(dot2);
            dot1.x = 0;
            dot1.y = 365;
            dot2.x = 365;
            dot2.y = 0;
            dot1.buttonMode = dot2.buttonMode = true;
            
            _bmd = new BitmapData(365, 365, false, 0xFFFFFF);
            
            canvas.graphics.lineStyle(1, 0x666666);
            canvas.graphics.drawRect(0, 0, 365, 365);
            
            canvas.graphics.lineStyle(0, 0xFF0000);
            canvas.graphics.moveTo(0, 365);
            canvas.graphics.cubicCurveTo(dot1.x, dot1.y , dot2.x, dot2.y, 365, 0);
            
            _bmd.draw(canvas);

            dot1.addEventListener(MouseEvent.MOUSE_DOWN, onPres);
            dot2.addEventListener(MouseEvent.MOUSE_DOWN, onPres);
            dot1.addEventListener(MouseEvent.MOUSE_UP, onReles);
            dot2.addEventListener(MouseEvent.MOUSE_UP, onReles);
        }

        
        
        private function update(e:Event):void
        {
            canvas.graphics.clear();
            
            canvas.graphics.lineStyle(1, 0x999999);
            canvas.graphics.drawRect(0, 0, 365, 365);
            
            canvas.graphics.lineStyle(0, 0xFF0000);
            canvas.graphics.moveTo(0, 365);
            canvas.graphics.cubicCurveTo(dot1.x, dot1.y , dot2.x, dot2.y, 365, 0);
            //
            canvas.graphics.moveTo(0, 365);
            canvas.graphics.lineStyle(.3, 0xFF00, .5);
            canvas.graphics.lineTo(dot1.x, dot1.y);
            canvas.graphics.moveTo(365, 0);
            canvas.graphics.lineStyle(.3, 0xFF, .5);
            canvas.graphics.lineTo(dot2.x, dot2.y);
        }

        private function onPres(e:MouseEvent):void
        {
            addEventListener(Event.ENTER_FRAME, update);
            var dot:Dot = e.currentTarget as Dot;
            dot.addEventListener(Event.ENTER_FRAME, drag);
        }
        private function onReles(e:MouseEvent):void
        {
            var dot:Dot = e.currentTarget as Dot;
            dot.removeEventListener(Event.ENTER_FRAME, drag);
        }
        
        private function drag(e:Event):void
        {
            e.currentTarget.x = canvas.mouseX;
            e.currentTarget.y = canvas.mouseY;
        }
    }

}


import flash.display.Sprite;

internal class Dot extends Sprite
{
    public function Dot(col:int = 0x99CA9D)
    {
        graphics.beginFill(col);
        graphics.lineStyle(.5, 0x999999);
        graphics.drawRect(-5, -5, 10, 10);
    }
}