/**
 * Copyright hacker_szoe51ih ( http://wonderfl.net/user/hacker_szoe51ih )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pThz
 */

 //papervision3Dの練習
 //ClockMakerさんの「Flash3Dコンテンツ制作のためのPapervision3D入門」参照
 

package {
    import flash.display.Sprite;
    import flash.display.*;
    import flash.events.*;
    import flash.utils.*;
	import flash.geom.Point;
 
    import org.papervision3d.materials.utils.*;
 	import org.papervision3d.materials.*;
    import org.papervision3d.objects.primitives.*;
	import org.papervision3d.events.InteractiveScene3DEvent;
	import org.papervision3d.view.*;

	[SWF(width = 465, height = 465, backgroundColor = 0x000000, frameRate = 45)]
	
   
   public class Cube3D extends BasicView {

   	private var rot:Number=0;
   	private var oldX:Number=0;
   	private var targetRot:Number=0;
   	private var isMouseDown:Boolean=false;
   	
			   	public function Cube3D(){
			   		
			   		var material:WireframeMaterial=new WireframeMaterial(0x2299ff);
			   		var materials:MaterialsList=new MaterialsList({all:material});
			   		var cube:Cube=new Cube(materials,70,70,70,5,5,5);
			   		scene.addChild(cube);
			   		cube.rotationX=10;
			   		cube.rotationY=-30;
			   		startRendering();
			   		
			   		addEventListener(Event.ENTER_FRAME, loop);
			   		
			   		stage.addEventListener(MouseEvent.MOUSE_DOWN,downHandler);
			   		stage.addEventListener(MouseEvent.MOUSE_UP,upHandler);
			   		stage.addEventListener(MouseEvent.MOUSE_MOVE,moveHandler);
			   		
			   		   		
			   	}
			   	
			   	public function downHandler(e:MouseEvent):void{
			   		isMouseDown=true;
			   		oldX=mouseX;//マウスダウンしたx座標をsave
			   	}
			   	
			   	public function upHandler(e:MouseEvent):void{
			   		isMouseDown=false;
			   	}
			   	
			   	public function moveHandler(e:MouseEvent):void{
			   		if(isMouseDown){
			   			//動かしたポインタとsaveしておいた座標の差分を求める
			   			var dx:Number=e.stageX-oldX;
			   			//差分を目標位置の角度にする
			   			targetRot += dx;
			   			//saveしておいたx座標を現在の座標に更新
			   			oldX = e.stageX;
			   		}
			   	}
			   	
			   	public function loop(e:Event):void{
			   		// イージングの公式を用いて滑らかにする			
			   		// 値 += (目標の角度 - 現在の角度) * 減速値
			   		rot += (targetRot-rot) * 0.03;
			   		camera.x=200*Math.sin(rot * Math.PI/180);
			   		camera.z=200*Math.cos(rot * Math.PI/180);
			   	}
   	
   	
		}
}