/**
 * Copyright Extra ( http://wonderfl.net/user/Extra )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pTJB
 */

// forked from daijimachine's Dobuemon Tunnel
/**
* Dobuemon Tunnel
* 
* AAway3D4.0の開発が絶賛進んでるけど、
* FlashPlayer10対応のAway3D3.6を一足遅れていじってみた。
* 
* 日本有数の心霊スポット、その名はドブえもんトンネル。
* ずーーーっと見てると気分を悪くする場合がありますので
* くれぐれもご注意ください。
* 当方では責任を負いかねます。
* 
* @author Masayuki Daijima (ARCHETYP Inc.)
* http://www.daijima.jp/
* http://twitter.com/daijimachine
*/

package  
{
    import away3d.cameras.Camera3D;
    import away3d.containers.Scene3D;
    import away3d.containers.View3D;
    import away3d.core.base.Vertex;
    import away3d.core.filter.FogFilter;
    import away3d.core.render.BasicRenderer;
    import away3d.materials.ColorMaterial;
    import away3d.materials.TransformBitmapMaterial;
    import away3d.primitives.Cylinder;
    import com.bit101.components.ProgressBar;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Loader;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageQuality;
    import flash.display.StageScaleMode;
    import flash.system.Security;
    import flash.events.Event;
    import flash.events.ProgressEvent;
    import flash.geom.Matrix3D;
    import flash.geom.Vector3D;
    import flash.net.URLRequest;
    import org.libspark.betweenas3.BetweenAS3;
    import org.libspark.betweenas3.easing.Quad;
    import org.libspark.betweenas3.tweens.ITween;
    
    [SWF(backgroundColor = "#000000", frameRate = "50", width = "465", height = "465")]
    
    public class Document extends Sprite 
    {
        private const IMG_URL:String = "http://adobeflash.altervista.org/rotatetrans.png";
        
        private const D2R:Number = Math.PI / 180;
        
        private var _loadPercent:Number = 0;
        private var _dobuemon:Loader;
        
        private var _scene:Scene3D;
        private var _camera:Camera3D;
        private var _view:View3D;
        private var _cylinder:Cylinder;
        private var _cylinder2:Cylinder;
        private var _bitmapMaterial:TransformBitmapMaterial;
        
        private var _weights:Array;
        private var _angle:int;
        private var _mtx1:Matrix3D;
        private var _mtx2:Matrix3D;
        private var _vec:Vector3D;
        
        public function Document() 
        { 
            Security.loadPolicyFile("http://adobeflash.altervista.org/crossdomain.xml");
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.quality = StageQuality.LOW;
            
            loadDobuemon();
        }
        
        private function loadDobuemon():void
        {
            _dobuemon = new Loader();
            var req:URLRequest = new URLRequest(IMG_URL);
            _dobuemon.contentLoaderInfo.addEventListener(ProgressEvent.PROGRESS, loadProgress);
            _dobuemon.load(req);
            
            setProgressBar();

        }
        private function loadProgress(event:ProgressEvent):void
        {
            _loadPercent = event.target.bytesLoaded / event.target.bytesTotal;
        }        
        
        private function setProgressBar():void
        {
            var p_bar:ProgressBar = new ProgressBar(this, 182, 232);
            addEventListener(Event.ENTER_FRAME, function(event:Event):void 
            {
                p_bar.value += (_loadPercent - p_bar.value) * .5;
                
                if (p_bar.value > .99) {
                    p_bar.value = 1;
                    event.target.removeEventListener(event.type, arguments.callee);
                    
                    var _tw:ITween = BetweenAS3.serial(
                        BetweenAS3.to(p_bar, { alpha:0 }, .3, Quad.easeOut), 
                        BetweenAS3.removeFromParent(p_bar)
                    );
                    _tw.onComplete = setWorld;
                    _tw.play();
                }
            });
        }
        
        private function setWorld():void
        {
            _dobuemon.contentLoaderInfo.removeEventListener(ProgressEvent.PROGRESS, loadProgress);
            
            _mtx1 = new Matrix3D();
            _mtx2 = new Matrix3D();
            _vec = new Vector3D();
            _weights = [];
            _angle = 0;
            
            _scene = new Scene3D();
            _camera = new Camera3D();
            _camera.y = -500;
            _camera.x = 0;
            _camera.z = 0;
            _camera.focus = 25;
            _camera.zoom = 25;
            _camera.rotationX = 90;
            
            var filter:FogFilter = new FogFilter( { material:new ColorMaterial(0), minZ:100, maxZ:1500 } );
            
            _view = new View3D( { camera: _camera, scene: _scene, stats: false, x: stage.stageWidth >> 1, y: stage.stageHeight >> 1 } );
            _view.renderer = new BasicRenderer(filter);
            addChild(_view);
            
            var bmpd:BitmapData = Bitmap(_dobuemon.content).bitmapData;
            _bitmapMaterial = new TransformBitmapMaterial(bmpd, { repeat:true, scaleX:.1, scaleY:.1 } );
            
            var radius:int = 120;
            var segment:int = 10;
            var h:int = 1000;
            
            _cylinder = new Cylinder( { material:_bitmapMaterial, radius:radius, segmentsW:segment, segmentsH:segment, height:h, openEnded:true } );
            _cylinder2 = new Cylinder( { material:_bitmapMaterial, radius:radius, segmentsW:segment, segmentsH:segment, height:h, openEnded:true } );
            _cylinder.bothsides = true;
            _scene.addChild(_cylinder);
            
            var weight:Number, i:int;
            for each(var v:Vertex in _cylinder.vertices) {
                var row:int = i / segment;
                weight = row * 0.000625;
                _weights.push(weight);
                i++;
            }
            
            onStageResize();
            stage.addEventListener(Event.RESIZE, onStageResize);
            addEventListener(Event.ENTER_FRAME, update);
        }
        
        private function update(event:Event):void 
        {
            _bitmapMaterial.offsetY++;
            _cylinder.rotationY += 0.5;
            _angle++;
            
            var rad:Number = _angle * D2R;
            var updateNum:Number = Math.cos(rad) * 0.00045;
            
            var i:int = 0;
            while(i < _cylinder2.vertices.length) {
                var v1:Vertex = _cylinder.vertices[i];
                var v2:Vertex = _cylinder2.vertices[i];
                
                _mtx1.identity();
                _mtx1.prependRotation(updateNum, new Vector3D(0, 0, 1));
                _mtx2.prependTranslation(updateNum, 0, 0);
                _mtx1.prepend(_mtx2);
                _vec = _mtx1.transformVector(v2.position);
                
                v2.x = _vec.x;
                v2.y = _vec.y;
                v2.z = _vec.z;
                
                var weightedV:Vertex = Vertex.weighted(v1, v2, 1 - _weights[i], _weights[i]);
                
                v1.x = weightedV.x;
                v1.y = weightedV.y;
                v1.z = weightedV.z;
                
                i++;
            }
            
            _view.render();
        }
        
        private function onStageResize(event:Event = null):void 
        {
            _view.x = stage.stageWidth >> 1;
            _view.y = stage.stageHeight >> 1;
        }
    }
}