/**
 * Copyright hacker_xaotp5zq ( http://wonderfl.net/user/hacker_xaotp5zq )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pSpK
 */

// forked from kihon's スキャンライン - シードフィル
package
{
	import flash.display.Sprite;
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.geom.Point;
	import flash.geom.Rectangle;
	import jp.progression.commands.Func;
	import jp.progression.commands.lists.SerialList;
	import jp.progression.commands.Wait;
	
	public class Main extends Sprite
	{
		private var bd:BitmapData;
		private var list:SerialList = new SerialList();
		private var wait:Number = 60 / 1000.0;
		
		public function Main()
		{
			bd = new BitmapData(30, 30, false, 0xFFFFFF);
			init();
			
			var bitmap:Bitmap = new Bitmap(bd);
			bitmap.scaleX = bitmap.scaleY = 465 / 30;
			addChild(bitmap);
			
			fill(15, 15, 0xED1A3D);
			init();
			list.execute();
		}
		
		private function init():void
		{
			bd.fillRect(bd.rect, 0xFFFFFF);
			for (var i:int = 0; i < 10; i++)
			{
				bd.setPixel(i, i, 0x0);
			}
			
			for (i = 3; i < 10; i++)
			{
				bd.setPixel(10, i, 0x0);
			}
			
			for (i = 10; i < 28; i++)
			{
				bd.setPixel(i, 3, 0x0);
			}
			
			for (i = 3; i < 28; i++)
			{
				bd.setPixel(28, i, 0x0);
			}
			
			for (i = 10; i < 28; i++)
			{
				bd.setPixel(i, 28, 0x0);
			}
			
			for (i = 17; i < 28; i++)
			{
				bd.setPixel(10, i, 0x0);
			}
		}
		
		private function fill(x:int, y:int, fillColor:int):void
		{
			if (bd.getPixel(x, y) == fillColor) return;
			
			var color:int = bd.getPixel(x, y);
			var buffer:Array = new Array();
			buffer.push(new Point(x, y));
			
			while (buffer.length)
			{
				var point:Point = buffer.shift();
				if (bd.getPixel(point.x, point.y) == fillColor) continue;
				
				for (var leftX:int = point.x; 0 <= leftX; leftX--)
				{
					if (bd.getPixel(leftX - 1, point.y) != color) break;
				}
				
				for (var rightX:int = point.x; rightX < bd.width; rightX++)
				{
					if (bd.getPixel(rightX + 1, point.y) != color) break;
				}
				
				bd.fillRect(new Rectangle(leftX, point.y, rightX - leftX + 1, 1), fillColor);
				list.addCommand(new Func(function(leftX:int, rightX:int, y:int):void { bd.fillRect(new Rectangle(leftX, y, rightX - leftX + 1, 1), fillColor); }, [leftX, rightX, point.y]));
				list.addCommand(new Wait(wait));
				
				if (point.y + 1 < bd.height) 	scanLine(leftX, rightX, point.y + 1, color, buffer);
				if (0 <= point.y - 1) 		scanLine(leftX, rightX, point.y - 1, color, buffer);
			}
		}
		
		private function scanLine(leftX:int, rightX:int, y:int, color:int, buffer:Array):void
		{
			while (leftX <= rightX)
			{
				for (; leftX <= rightX; leftX++)
				{
					if (bd.getPixel(leftX, y) == color) break;
				}
				
				if (rightX < leftX) break;
				
				for (; leftX <= rightX; leftX++)
				{
					if (bd.getPixel(leftX, y) != color) break;
				}
				buffer.push(new Point(leftX - 1, y));
			}
		}
	}
}