/**
 * Copyright siouxcitizen ( http://wonderfl.net/user/siouxcitizen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pSmS
 */

// forked from siouxcitizen's 前回ソースから散るサクラっぽいの目指してみましたがイマイチ。。。
//
//前回ソースから散るサクラをハート型に変更してみました
//
//以下コードとサイトを参考にさせていただきました
//はーと
//http://wonderfl.net/c/qY4L
//以下のWebサイトを参考にしました。
//http://www.mathcurve.com/courbes2d/ornementales/ornementales.shtml
//
package {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.geom.Matrix;
    import flash.filters.GlowFilter;

    import org.papervision3d.view.Viewport3D;
    import org.papervision3d.scenes.Scene3D;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.objects.primitives.Plane;
    import org.papervision3d.cameras.Camera3D;
    import org.papervision3d.materials.ColorMaterial;
    import org.papervision3d.materials.BitmapMaterial;
    import org.papervision3d.render.BasicRenderEngine;
    [SWF(width="500", height="500", frameRate="60", backgroundColor="#66CCFF")]
 
    public class MoviePlane extends Sprite
    {
        private var container : Sprite;
        private var viewport  : Viewport3D;
        private var scene     : Scene3D;
        private var camera    : Camera3D;
        private var material  : BitmapMaterial;
        private var planeObj  : Plane; 
        private var renderer  : BasicRenderEngine;

        private var pixelArr        :Array  = [];     // パーティクルを格納する配列
        private const PIXEL_NUM : int = 5;     // 縦・横のピクセル数
        private const PLANE_SIZE : int = 200;//Planeオブジェクト1辺の長さ
        private const PLANE_SEGMENT   : int = 1;  //面の分割数
        private const PLANE_MARGIN  :int    = 30;     // パーティクルの余白
        private var tempPlaneName : String = "";

        private var filterList : Array;
        //MoviePlaneクラスのコンストラクタ
        public function MoviePlane():void
        {          
            //ビューポート生成
            viewport = new Viewport3D(500, 500, false, true);
            viewport.opaqueBackground = 0x333333;

            addChild(viewport);

            //シーン生成
            scene = new Scene3D();

            //レンダリングエンジン生成
            renderer = new BasicRenderEngine();

            //テクスチャ用画像を作成
            var textureOnPlane : HeartSakura = new HeartSakura();

            //bitmapDataを用意する
            var bitmapData:BitmapData = new BitmapData(320, 320, true, 0x00000000); // 透明なBitmapDataを用意
            var matrix:Matrix = new Matrix();   // 表示位置はMatrixで指定する
            matrix.translate(0, 0);   // (0, 0)の位置に描画する設定にする
            bitmapData.draw(textureOnPlane, matrix);    // spriteをbitmapDataに描画する

            //フィルターの準備
            filterList = new Array();
            var glowFilter : GlowFilter = new GlowFilter(0xFFFFFF, 1, 32, 32, 2, 1, false, false); 
            filterList.push(glowFilter);

            //マテリアル設定
            material = new BitmapMaterial(bitmapData, false);
            material.doubleSided = true;

            pixelArr = [];
            for (var i:int = 0; i < PIXEL_NUM; i++) {
                pixelArr[i] = [];
                for (var j:int = 0; j < PIXEL_NUM; j++ ) {
                    // Planeインスタンスを作成
                    var o:Plane = new Plane(material, PLANE_SIZE, PLANE_SIZE, PLANE_SEGMENT, PLANE_SEGMENT);
                    o.useOwnContainer = true; //フィルター使用のために設定
                    o.filters = filterList; //フィルター使用のために設定
                    scene.addChild(o);
                    pixelArr[i][j] = o;
                    
                    // 座標
                    o.x = Math.random()*(PIXEL_NUM*PLANE_SIZE);
                    o.y = Math.random()*5000;
                    o.z = Math.random()*(PIXEL_NUM*PLANE_SIZE);
                }
            }

            //カメラ設定
            camera = new Camera3D();
            camera.x = PLANE_SIZE * (PIXEL_NUM / 2);
            camera.y = 1000;
            camera.z = -PLANE_SIZE;
            camera.focus = 50;
            camera.zoom = 1;
 
            //フレーム毎の処理用リスナを設定
            stage.addEventListener(Event.ENTER_FRAME, _enterframe);
        }

        //フレーム毎の処理
        private function _enterframe(e:Event):void{
            for (var i:int = 0; i < PIXEL_NUM; i++) {
                for (var j:int = 0; j < PIXEL_NUM; j++ ) {
                    var p:DisplayObject3D = pixelArr[i][j];
                    if (p.y > 0) {
                        p.rotationX += Math.random() * 10; 
                        p.rotationY += Math.random() * 10;
                        //p.y -= 10;
                        //p.y -= Math.random() * 10; 
                        p.y -= (Math.random() * 20 + 1) - (180 - (p.rotationX % 180)) * .008;
                    } else {
                        p.x = Math.random()*(PIXEL_NUM*PLANE_SIZE);
                        p.y = Math.random()*5000;
                        p.z = Math.random()*(PIXEL_NUM*PLANE_SIZE);
                    }
                }
            }
            renderer.renderScene(scene, camera, viewport);
        }
    }
}

import flash.display.Sprite;
class HeartSakura extends Sprite {
    public function HeartSakura() {
        graphics.lineStyle(5,0xffaaff);
        graphics.beginFill(0xff99ff,1);
        //graphics.moveTo(232,250);
        graphics.moveTo(200,230);            
        for(var i:int=1 ; i<180 ; i++) {
            var theta:Number = i*Math.PI/180;
            var tan:Number = Math.abs(Math.tan(theta));
            var r:Number = 150*Math.pow(tan, 1/tan);
            var x:Number =  Math.cos(theta)*r;
            var y:Number = -Math.sin(theta)*r;
            //graphics.lineTo(232+x, 250+y);
            graphics.lineTo(200+x, 230+y);
        }
    }

}