/**
 * Copyright sakef ( http://wonderfl.net/user/sakef )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pSVE
 */

/*
    Papervision3Dが利用できるようになったと聞いて。
    とりあえず、テスト投稿です。
    前作ったエフェクト練習のやつ。
*/

package
{
    import flash.display.BlendMode;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.filters.BlurFilter;
    import flash.geom.ColorTransform;
    import org.papervision3d.cameras.Camera3D;
    import org.papervision3d.core.effects.BitmapColorEffect;
    import org.papervision3d.core.effects.BitmapLayerEffect;
    import org.papervision3d.core.effects.utils.BitmapClearMode;
    import org.papervision3d.core.effects.utils.BitmapDrawCommand;
    import org.papervision3d.materials.ColorMaterial;
    import org.papervision3d.materials.special.ParticleMaterial;
    import org.papervision3d.materials.utils.MaterialsList;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.objects.primitives.Cube;
    import org.papervision3d.objects.special.ParticleField;
    import org.papervision3d.render.BasicRenderEngine;
    import org.papervision3d.scenes.Scene3D;
    import org.papervision3d.view.Viewport3D;
    import org.papervision3d.view.layer.BitmapEffectLayer;

    [SWF(width="465", height="465", backgroundColor="0x000000", frameRate="40")]
    public class Main extends Sprite
    {
        private var viewport:Viewport3D;
        private var scene:Scene3D;
        private var camera:Camera3D;
        private var renderer:BasicRenderEngine;
        private var rootNode:DisplayObject3D;
        private var bfx:BitmapEffectLayer;
        private var cube:Cube;
        private var valx:Number=0;
        private var valy:Number=0;

        public function Main()
        {
            viewport=new Viewport3D(0, 0, true, true);
            scene=new Scene3D();
            camera=new Camera3D();
            renderer=new BasicRenderEngine();
            rootNode=scene.addChild(new DisplayObject3D("rootNode"));
            addEventListener(Event.ENTER_FRAME, onFrame);

            addChild(viewport);
            camera.zoom=30;
            camera.focus=200;
            camera.target=DisplayObject3D.ZERO;

            bfx=new BitmapEffectLayer(viewport, stage.stageWidth, stage.stageHeight, true, 0, BitmapClearMode.CLEAR_PRE);
            bfx.addEffect(new BitmapLayerEffect(new BlurFilter(2, 2, 1)));
            bfx.addEffect(new BitmapColorEffect(0.99, 0.98, 0.98, 0.98));
            bfx.drawCommand=new BitmapDrawCommand(null, new ColorTransform(1, 0.2, 0.1, 0.45), BlendMode.ADD);
            bfx.drawLayer.blendMode=BlendMode.OVERLAY;
            viewport.containerSprite.addLayer(bfx);

            var materials:MaterialsList=new MaterialsList({all:new ColorMaterial(0xffffff, 0.7, true)});
            cube=new Cube(materials, 30, 30, 30, 4, 4, 4);
            rootNode.addChild(cube);

            bfx.addDisplayObject3D(cube);

            var particle:ParticleMaterial=new ParticleMaterial(0xffffff, 1, ParticleMaterial.SHAPE_CIRCLE);
            var particles:ParticleField=new ParticleField(particle, 1000, 0.3, 500, 500, 500);
            scene.addChild(particles);
        }

        public function onFrame(e:Event):void
        {
            valx+=mouseX / 150;
            valy+=mouseY / 150;

            cube.rotationX=valx;
            cube.rotationY=valy;

            renderer.renderScene(scene, camera, viewport);
        }
    }
}


