/**
 * Copyright zier ( http://wonderfl.net/user/zier )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pSFW
 */

package {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    
    [SWF(width = 400, height = 400, frameRate = 30)]
    public class FlashTest extends Sprite {
        private function createRectangle(c: uint, x: Number, y: Number, w: Number, h: Number): Sprite {
            var result: Sprite = new DraggableSprite();
            with (result.graphics) {
                beginFill(c)
                drawRect(- w / 2, - h / 2, w, h)
                endFill()
            }
            
            result.x = x
            result.y = y
            return result
        }
        
        public function FlashTest() {
            var rect1: Sprite = createRectangle(0x00A0FF, 100, 100, 50, 50)
            var rect2: Sprite = createRectangle(0xA0FF00, 300, 200, 100, 20)
            var rect3: Sprite = createRectangle(0xFFA000, 100, 300, 70, 40)
            
            addChild(rect1)
            addChild(rect2)
            addChild(rect3)
            
            rect1.rotation += 45
            rect2.rotation += 30
            rect3.rotation += 20
            
            addChild(new LinkTest(rect1, rect2))
            addChild(new LinkTest(rect3, rect2))
        }
    }
}

import flash.display.Sprite;
import flash.events.Event;
import flash.events.EventDispatcher;
import flash.events.MouseEvent;

// 掴める Sprite
class DraggableSprite extends Sprite {
    public static const DRAGGING: String = "dragging"
    public static const COMPLETE: String = "complete"
    public static const REFRESH: String = "refresh"
    
    function DraggableSprite() {
        this.addEventListener(MouseEvent.MOUSE_DOWN, function(): void {
            stage.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove)
            stage.addEventListener(MouseEvent.MOUSE_UP, onMouseUp)
        });
    }
    
    private function onMouseMove(e: MouseEvent): void {
        this.x = e.stageX
        this.y = e.stageY
        dispatchEvent(new Event(DRAGGING));
        dispatchEvent(new Event(REFRESH));
    }
    
    private function onMouseUp(e: MouseEvent): void {
        this.stage.removeEventListener(MouseEvent.MOUSE_MOVE, onMouseMove)
        this.stage.removeEventListener(MouseEvent.MOUSE_UP, onMouseUp)
        dispatchEvent(new Event(COMPLETE));
        dispatchEvent(new Event(REFRESH));
    }
}


class LinkTest extends Sprite {
    private var tail: Sprite = null;
    private var head: Sprite = null;
    
    function LinkTest(aTail: Sprite, aHead: Sprite) {
        link(aTail, aHead)
        onRefresh()
    }
    
    public function link(aTail: Sprite, aHead: Sprite): void {
        unlink()
        tail = aTail
        head = aHead
        if (null != tail) tail.addEventListener(DraggableSprite.REFRESH, onRefresh)
        if (null != head) head.addEventListener(DraggableSprite.REFRESH, onRefresh)
    }

    public function unlink(): void {
        if (null != tail) tail.removeEventListener(DraggableSprite.REFRESH, onRefresh)
        if (null != head) head.removeEventListener(DraggableSprite.REFRESH, onRefresh)
        tail = null
        head = null
    }
    
    public function onRefresh(e: Event = null): void {
        graphics.clear()
        graphics.lineStyle(1, 0)
        graphics.moveTo(tail.x, tail.y)
        graphics.lineTo(head.x, head.y)
    }
}
