/**
 * Copyright producerism ( http://wonderfl.net/user/producerism )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pSE1
 */

package  
{
	import flash.display.Sprite;
	
	/**
	 * ...
	 * @author T@IDEAS
	 * Main class of the entire project.  This is the file that is actually compiled to SWF.
	 */
	[SWF(width="800", height="600", backgroundColor="#cccccc", frameRate="30")]
	public class TomAS3Gotchi extends Sprite
	{
		private var _tom:Tom;
		
		public function TomAS3Gotchi() 
		{
			
			//This is all the initialization you need in your main class
            inittrace(stage);
			
			_tom = new Tom();
			trace(_tom.health);
			trace(_tom.mood);
			
			// feed Tom some food
			_tom.eat(new Food("apple", 500));
			_tom.eat(new Food("cheeseburger", 3000));
			
			// this will trigger an error
			// NOTE: this doesn't throw an
			// error in wonderfl
			_tom.weight = 100;
		}
		
	}
	
}
class Tom 
	{		
		// Constants and Defaults
		private static const DEFAULT_WEIGHT	:uint 	= 200;
		private static const DEFAULT_AGE	:uint 	= 25;
		private static const DEFAULT_MOOD	:String = "Happy";
		private static const DEFAULT_HEALTH	:String = "Healthy";
		
		// Weight and Age are integers
		private var _weight	:Number;
		private var _age	:uint;
		
		// hunger, thirst and boredom will be rated from 0-10
		private var _hunger	:uint;
		private var _thirst	:uint;
		private var _boredom:uint;
		
		// health and mood will be represented by strings
		private var _health	:String;
		private var _mood	:String;
		
		public function Tom() 
		{
			// constructor function
			trace("Hi, I'm Tom!");
			
			// set defaults
			_weight = DEFAULT_WEIGHT;
			_age = DEFAULT_AGE;
			_mood = DEFAULT_MOOD;
			_health = DEFAULT_HEALTH;
			
			// set hunger, thirst and boredom to 0
			_hunger = _thirst = _boredom = 0;
		}
		
		// example setter function
		public function set weight(value:Number):void 
		{
			// we shouldn't allow the weight variable to be changed
			// unless it's through the eat() or drink() functions
			throw new Error("Hey, no cheating your diet!");
		}
		
		public function get weight():Number {
			// when returning weight, round to 1 decimal
			// this way "weight" getter function will return 201.5
			// while private variable _weight will still be accurate
			return Math.round(_weight * 10) / 10;
		}
		
		// public functions
		public function eat($food:Food):void
		{
			_weight += $food.calories / Food.CALORIES_IN_A_POUND;
			trace("After eating that " + $food.name + ", Tom now weighs " + weight);
		}
		
		// getter functions for private variables
		public function get health():String { return _health; }
		public function get mood():String 	{ return _mood; }
		public function get hunger():uint { return _hunger; }
		public function get thirst():uint { return _thirst; }
		public function get boredom():uint { return _boredom; }
		public function get age():uint { return _age; }		
		
	}
	
class Food
	{
		
		public var calories:uint;
		public var name:String;
		
		public static const CALORIES_IN_A_POUND:uint = 3500;
		
		public function Food($name:String, $calories:uint) 
		{
			name = $name;
			calories = $calories;
		}
		
}

/////  WONDERFL TRACE /////

import flash.display.Sprite;
import flash.display.Stage;
import flash.text.TextField;
import flash.text.TextFormat;


function inittrace(s:Stage):void
{
    WTrace.initTrace(s);
}

//global trace function
var trace:Function;

//wtreace class
class WTrace
{
        private static var FONT:String = "Fixedsys";
        private static var SIZE:Number = 12;
        private static var TextFields:Array = [];
        private static var trace_stage:Stage;
        
        public static function initTrace(stg:Stage):void
        {
            trace_stage = stg;
            trace = wtrace;
        }
        
        private static function scrollup():void
        {
            // maximum number of lines: 100
            if (TextFields.length > 100) 
            {
                var removeme:TextField = TextFields.shift();
                trace_stage.removeChild(removeme);
                removeme = null;
            }
            for(var x:Number=0;x<TextFields.length;x++)
            {
                (TextFields[x] as TextField).y -= SIZE*1.2;
            }
        }
    
        public static function wtrace(... args):void
        {
        
            var s:String="";
            var tracefield:TextField;
            
            for (var i:int;i < args.length;i++)
            {
                // imitating flash:
                // putting a space between the parameters
                if (i != 0) s+=" ";
                s+=args[i].toString();
            }
            

            tracefield= new TextField();
            tracefield.autoSize = "left";
            tracefield.text = s;
            tracefield.y = trace_stage.stageHeight - 20;

            var tf:TextFormat = new TextFormat(FONT, SIZE);
            tracefield.setTextFormat(tf);
            trace_stage.addChild(tracefield);
            scrollup();                      
            TextFields.push(tracefield);
            
        }
}