/**
 * Copyright XELF ( http://wonderfl.net/user/XELF )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pRuw
 */

package {
    import flash.display.Sprite;
    import flash.events.*;
    import flash.display.*;
    import flash.geom.*;
    import flash.utils.*;
    import flash.text.*;
    import flash.filters.*;
    [SWF(width=465, height=465, frameRate=60, backgroundColor=0xFFFFFF)]
    public class FlashTest extends Sprite {
        private var time:Number = 20;
        private var data:BitmapData = new BitmapData(32, 32, true, 0xFFFFFFFF);
        private var bits:ByteArray;
        private var bitmap:Bitmap;
        private var text:TextField = new TextField();
        public function FlashTest() {
            //stage.quality = "low";
            stage.addEventListener(Event.ENTER_FRAME, Update);
            bitmap = new Bitmap(data);
            bitmap.scaleX = 465 / 32.0;
            bitmap.scaleY = 0.25;
            bitmap.x = 0;
            bitmap.y = 400;
            addChild(bitmap);
            var filter:ConvolutionFilter = new ConvolutionFilter(3, 4);
            filter.matrix = [
                1, 1, 1,
                1,-7, 1,
                1, 1, 1];
            filter.divisor = 1.0 / 7;
            filters = [new BlurFilter(2, 2), new DropShadowFilter(8, 45, 0x402010, 255, 12, 12, 1.1)];
            var format:TextFormat = new TextFormat("Arial", 80);
            format.align = "center";
            format.color = 0x90FF20;
            text.defaultTextFormat = format;
            text.autoSize = "left";
            text.width = 465;
            text.wordWrap = true;
            text.text = "ABCDEFG";
            text.antiAliasType = "advanced";
            text.y = 50;
            addChild(text);
        }
        public function Update(e:Event):void {
            time += 0.04;
            graphics.clear();
            var a:Number = time * 0.03;
            var c:Number = Math.cos(a) * 40;
            var s:Number = Math.sin(a) * 40;
            for (var j:int = 0; j < 13; j++) {
                for (var i:int = 0; i < 13; i++) {
                    var r:int = (i * 20 + int(time)) & 0xff;
                    var g:int = (j * 20 - int(time)) & 0xff;
                    var b:int = (0xffff - r - b) & 0xff;
                    graphics.lineStyle(20, (r << 16) + (g << 8) + b, 0.5);
                    var x:int = (440 * 4 + i * c + j * s) % 440;
                    var y:int = (440 * 4 + j * c - i * s) % 440;
                    graphics.moveTo(x, y - ((time + i + j) % 20));
                    graphics.lineTo(x, y);
                    graphics.lineTo(x + 20, y);
                    graphics.lineTo(x +20, y - ((time - i - j) % 20));
                }
            }
            
            //data.draw(stage, new Matrix(1, 0, 0, 1, 0), new ColorTransform(0, 1, 0, 0, 0, 0, 0, 1),
            //    BlendMode.NORMAL, new Rectangle(0, 0, 32, 32), false);
            //data.draw(stage, new Matrix(1, 0, 0, 1, 0), new ColorTransform(0, 1, 0, 0, 0, 0, 0, 1),
            //    BlendMode.ADD, new Rectangle(0, 1, 32, 32), false);
            //bits = data.getPixels(new Rectangle(0, 0, 32, 32));
            
            text.text = new Date().toString();
        }
    }
}
