/**
 * Copyright Merd ( http://wonderfl.net/user/Merd )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pREp
 */

// forked from takuya1021's forked from: Fractal Tree
// forked from RobotCaleb's Fractal Tree
package
{
    import flash.display.Sprite;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    
    import com.bit101.components.*;
    

    [SWF(width="400", height="400", backgroundColor="#111111")]
    public class Fractal extends Sprite
    {
        private var maxSteps:Number = 5;
        private var angleLeft:Number = Math.PI/180*20;
        private var angleRight:Number = Math.PI/180*50;
        private var lengthMult:Number = 0.7;
        
        private var myUIPanel:Panel;
        private var myMaxStepsSlider:HUISlider;
        private var myAngleLeftSlider:HUISlider;
        private var myAngleRightSlider:HUISlider;
        
        public function Fractal()
        {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            
            //myUIPanel = new Panel();
            myMaxStepsSlider = new HUISlider(this,10,10,"STEPS", updateValues);
            
            myMaxStepsSlider.tick = 1;
            myMaxStepsSlider.minimum = 1;
            myMaxStepsSlider.maximum = 10;
            myMaxStepsSlider.value = maxSteps;
            
            myAngleLeftSlider = new HUISlider(this,10,30,"ANGLE L", updateValues);
            myAngleLeftSlider.minimum = 0;
            myAngleLeftSlider.maximum = 10;
            myAngleLeftSlider.value = angleLeft;
            
            myAngleRightSlider = new HUISlider(this,10,50,"ANGLE L", updateValues);
            myAngleRightSlider.minimum = 0;
            myAngleRightSlider.maximum = 10;
            myAngleRightSlider.value = angleRight;
            
            DrawFractal();
        }
        
        public function updateValues(e:Event):void
        {
            maxSteps = myMaxStepsSlider.value;
            angleLeft = myAngleLeftSlider.value;
            angleRight = myAngleRightSlider.value;
            
            DrawFractal();
        }

        
        public function DrawFractal():void
        {
            graphics.clear();
            
            var angle:Number = Math.PI / 180 * 90;
            DrawPiece(angle, 200, 400, 100, 0);
        }
        
        public function DrawPiece(angle:Number, x:Number, y:Number, length:Number, count:Number):void
        {
            if (count < maxSteps)
            {
                var newLength:Number = length * lengthMult;
                var newX:Number = x - Math.cos(angle) * length;
                var newY:Number = y - Math.sin(angle) * length;
                
                graphics.lineStyle(2, 0xFFFF0000);
                graphics.moveTo(x, y);
                graphics.lineTo(newX, newY);
                
                DrawPiece(angle + angleRight, newX, newY, newLength, count + 1);
                DrawPiece(angle - angleLeft, newX, newY, newLength, count + 1);
            }
        }
    }
}