/**
 * Copyright tktr90755 ( http://wonderfl.net/user/tktr90755 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pQzm
 */

//参考文献:http://moringo.moo.jp/wordpress/?p=128
//FULL SCREEN にできます
package  
{
	import flash.display.Sprite;
	import flash.display.StageScaleMode;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.events.TimerEvent;
	import flash.utils.Timer;
	public class Index extends Sprite
	{
		private var antContainer:Sprite;
		private var addButton:Sprite;
		
		public function Index() 
		{
			initial();
		}
		
		private function initial():void
		{
			stage.scaleMode = StageScaleMode.NO_SCALE;
			
			antContainer = new Sprite();
			stage.addChild(antContainer);
			
			addButton = new Button("add");
			addButton.x = 15;
			addButton.y = addButton.height + 5;
			addButton.addEventListener(MouseEvent.CLICK, addButtonClickHandler);
			stage.addChild(addButton);
			
			addButtonClickHandler();
			
			stage.addEventListener(Event.RESIZE, resizeHandler);
			stage.dispatchEvent (new Event(Event.RESIZE));
		}
		
		private function addButtonClickHandler(e:MouseEvent = null):void
		{
			addButton.removeEventListener(MouseEvent.MOUSE_DOWN, addButtonClickHandler);
			var timer:Timer = new Timer(10, 50);
			timer.addEventListener(TimerEvent.TIMER, function(e:TimerEvent):void { var ant:Sprite = new Ant(stage); antContainer.addChild(ant); } );
			timer.addEventListener(TimerEvent.TIMER_COMPLETE, function(e:TimerEvent):void { addButton.addEventListener(MouseEvent.MOUSE_DOWN, addButtonClickHandler); } );
			timer.start();
		}
		
		private function resizeHandler(e:Event):void 
		{
			if (antContainer != null)
			{
				antContainer.x = -((stage.stageWidth - 465) / 2);
				antContainer.y = -((stage.stageHeight - 465) / 2);
			}
			if (addButton != null)
			{
				addButton.x = -((stage.stageWidth - 465) / 2) + 15;
				addButton.y = -((stage.stageHeight - 465) / 2) + addButton.height + 5;
			}
		}
	}

}

import flash.display.DisplayObjectContainer;
import flash.display.Shape;
import flash.display.Sprite;
import flash.events.Event;
import flash.events.MouseEvent;
class Ant extends Sprite
{
	private var container:DisplayObjectContainer;
	private var ant:Sprite;
	private var speed:Number = 3;
	private var runing:Number = NaN;
	
	public function Ant(_container:DisplayObjectContainer)
	{
		container = _container;
		drawAnt();
		moveAnt();
	}
	
	//アリの見た目がしょぼいです・・
	private function drawAnt():void
	{
		ant = new Sprite();
		ant.scaleX=
		ant.scaleY = 0.3;
		this.addChild( ant );
		
		var hip:Shape = new Shape();
		hip.graphics.beginFill(0x000000, 1);
		hip.graphics.drawEllipse( -23, -9, 19, 18 );
		hip.graphics.endFill();
		ant.addChild( hip );
		
		var head:Shape = new Shape();
		head.graphics.beginFill(0x000000, 1);
		head.graphics.drawEllipse( 9, -9, 19, 18 );
		head.graphics.endFill();
		ant.addChild( head );
		
		var body:Shape = new Shape();
		body.graphics.beginFill(0x000000, 1);
		body.graphics.drawEllipse( -14, -10, 28, 20 );
		body.graphics.endFill();
		ant.addChild( body );
		
		var reg:Shape = new Shape();
		reg.graphics.lineStyle (2, 0x000000, 1);
		reg.graphics.moveTo (10, 0);
		reg.graphics.lineTo (15, 15);
		reg.graphics.lineTo (30, 20);
		reg.graphics.moveTo (10, 0);
		reg.graphics.lineTo (15, -15);
		reg.graphics.lineTo (30, -20);
		reg.graphics.moveTo (0, 0);
		reg.graphics.lineTo (0, 15);
		reg.graphics.lineTo ( -10, 20);
		reg.graphics.moveTo (0, 0);
		reg.graphics.lineTo (0, -15);
		reg.graphics.lineTo ( -10, -20);
		reg.graphics.moveTo ( -10, 0);
		reg.graphics.lineTo ( -15, 15);
		reg.graphics.lineTo ( -30, 20);
		reg.graphics.moveTo ( -10, 0);
		reg.graphics.lineTo ( -15, -15);
		reg.graphics.lineTo ( -30, -20);
		ant.addChild(reg);
	}
	
	private function moveAnt():void
	{
		ant.addEventListener(Event.ENTER_FRAME,enterFrameHandler);
		ant.addEventListener(MouseEvent.ROLL_OVER,rollOverHandler);
		ant.buttonMode = true;
	}


	private function rollOverHandler(e:MouseEvent):void
	{
		e.target.removeEventListener(MouseEvent.MOUSE_DOWN,rollOverHandler);
		e.target.buttonMode = false;
		speed = 6;
		runing = 0;
	}
	
	private function enterFrameHandler(e:Event):void
	{
		var moving:Number = 10
		
		var startRotation:Number =ant.rotation * Math.PI / 180
		
		var targetX:Number =0
		var targetY:Number =0
		
		var rand:Number = Math.random() * 1/ moving * Math.PI
		if(Math.random() > 0.5) rand *= -1
		var randomX:Number = Math.cos( rand ) * speed;
		var randomY:Number = Math.sin( rand ) * speed;
		
		targetX = randomX * Math.cos(startRotation) - randomY * Math.sin(startRotation)
		targetY = randomX * Math.sin(startRotation) + randomY * Math.cos(startRotation)
		
		var rad:Number = Math.atan2(targetX, targetY)
		ant.rotation = -rad * 180 /Math.PI +90 
		
		ant.x += targetX
		ant.y += targetY
		
		if (ant.x > container.stage.stageWidth) { ant.x = -40 };
		if (ant.x < -40) { ant.x = container.stage.stageWidth };
		if (ant.y > container.stage.stageHeight) { ant.y = -40 };
		if (ant.y < -40) { ant.y = container.stage.stageHeight };
		
		if(!isNaN(runing))
		{
			if(runing++>=100)
			{
				runing = NaN;
				speed = 2;
				e.target.addEventListener(MouseEvent.ROLL_OVER,rollOverHandler);
			}
		}
	}
}

import flash.text.TextField;
import flash.text.TextFormat;
class Button extends Sprite
{
	public function Button(id:String)
	{
		this.graphics.beginFill(0xFFFFFF, 1);
		this.graphics.lineStyle (1, 0x000000, 1);
		this.graphics.drawRect( -10, -20, 40, 20);
		
		var textFormat:TextFormat = new TextFormat();
		textFormat.align = "center";
		var name_txt:TextField = new TextField();
		name_txt.text = id;
		name_txt.width = 40;
		name_txt.height = 20;
		name_txt.x = -10;
		name_txt.y = -20;
		name_txt.selectable = false;
		name_txt.setTextFormat(textFormat);
		this.addChild(name_txt);
	}
}