/**
 * Copyright _katsuren ( http://wonderfl.net/user/_katsuren )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pQft
 */

// forked from _katsuren's EventDispach と Callback のテスト
package {
    import flash.events.Event;
    import flash.display.Sprite;
    import flash.text.TextField;
    import flash.events.EventDispatcher;

    public class FlashTest extends Sprite {
        public static const TEST_COUNT:int = 1000000;
        
        private var _tf:TextField = new TextField();
        private var _dispatcher:EventDispatcher;
        private var _callback:Callback;
        private var _callback2:Callback2;
        private var _callback2a:Callback2A;
        private var _callback2b:Callback2B;
        private var _callback2c:Callback2;
        private var _callback3:Callback3;
        private var _callback4:Callback4;
        private var _callback5:Callback5;
        
        private var _count:int = 0;
        
        public function FlashTest() {
            _tf.x = 0;
            _tf.y = 0;
            _tf.width = 150;
            _tf.height = 200;
            addChild(_tf);
            
            _dispatcher = new EventDispatcher();
            _dispatcher.addEventListener("test", onEvent);
            
            _callback = new Callback(onCallback);
            
            _callback2 = new Callback2();
            _callback2.addCallback("test", onCallback);
            
            _callback2a = new Callback2A();
            _callback2a.addCallback("test", onCallback);
            
            _callback2b = new Callback2B();
            _callback2b.addCallback("test", onCallback);
            
            _callback2c = new Callback2B();
            _callback2c.addCallback("test", onCallback);
            
            _callback3 = new Callback3();
            _callback3.addCallback("test", onCallback);
            
            _callback4 = new Callback4();
            _callback4.addCallback("test", onCallback);
            
            _callback5 = new Callback5();
            _callback5.addCallback("test", onCallback);
         
            stage.frameRate = 1;
            stage.addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        public function onEnterFrame(e:Event):void {
            if (_count == 0)
                testEventDispatcher();
            else if (_count == 1)
                testEventDispatcher2();
            else if (_count == 2)
                testCallback();
            else if (_count == 3)
                testCallback2();
            else if (_count == 4)
                testCallback3();
            else if (_count == 5)
                testCallback4();
            else if (_count == 6)
                testCallback5();
            else if (_count == 7)
                testCallback6();
            else if (_count == 8)
                testCallback7();
            else if (_count == 9)
                testCallback2a();
            else if (_count == 10)
                testCallback2b();
            else if (_count == 11)
                testCallback2c();
            _count++;
        }
        
        public function testEventDispatcher():void {
            var start:Number = new Date().getTime();
            for (var i:int=0; i<TEST_COUNT; i++) {
                _dispatcher.dispatchEvent(new Event("test"));
            }
            var end:Number = new Date().getTime();
            var time:String = (end-start).toString();
            appendText("Event takes : " + time + "ms");
        }
        public function onEvent(e:Event):void {}
        
        public function testEventDispatcher2():void {
            var e:Event = new Event("test");
            var start:Number = new Date().getTime();
            for (var i:int=0; i<TEST_COUNT; i++) {
                _dispatcher.dispatchEvent(e);
            }
            var end:Number = new Date().getTime();
            var time:String = (end-start).toString();
            appendText("Event2 takes : " + time + "ms");
        }
        
        public function testCallback():void {
            var start:Number = new Date().getTime();
            for (var i:int=0; i<TEST_COUNT; i++) {
                _callback.call();
            }
            var end:Number = new Date().getTime();
            var time:String = (end-start).toString();
            appendText("Callback takes : " + time + "ms");
        }
        public function onCallback():void {}
        
        public function testCallback2():void {
            var start:Number = new Date().getTime();
            for (var i:int=0; i<TEST_COUNT; i++) {
                _callback2.call("test");
            }
            var end:Number = new Date().getTime();
            var time:String = (end-start).toString();
            appendText("Callback2 takes : " + time + "ms");
        }
        
        public function testCallback2a():void {
            var start:Number = new Date().getTime();
            for (var i:int=0; i<TEST_COUNT; i++) {
                _callback2a.call("test");
            }
            var end:Number = new Date().getTime();
            var time:String = (end-start).toString();
            appendText("Callback2a takes : " + time + "ms");
        }
        
        public function testCallback2b():void {
            var start:Number = new Date().getTime();
            for (var i:int=0; i<TEST_COUNT; i++) {
                _callback2b.call("test");
            }
            var end:Number = new Date().getTime();
            var time:String = (end-start).toString();
            appendText("Callback2b takes : " + time + "ms");
        }
        
        public function testCallback2c():void {
            var start:Number = new Date().getTime();
            for (var i:int=0; i<TEST_COUNT; i++) {
                _callback2c.call("test");
            }
            var end:Number = new Date().getTime();
            var time:String = (end-start).toString();
            appendText("Callback2c takes : " + time + "ms");
        }
        
        public function testCallback3():void {
            var start:Number = new Date().getTime();
            for (var i:int=0; i<TEST_COUNT; i++) {
                _callback3.call("test");
            }
            var end:Number = new Date().getTime();
            var time:String = (end-start).toString();
            appendText("Callback3 takes : " + time + "ms");
        }
        
        public function testCallback4():void {
            var start:Number = new Date().getTime();
            for (var i:int=0; i<TEST_COUNT; i++) {
                _callback4.call(new Event("test"));
            }
            var end:Number = new Date().getTime();
            var time:String = (end-start).toString();
            appendText("Callback4 takes : " + time + "ms");
        }
        
        public function testCallback5():void {
            var start:Number = new Date().getTime();
            var e:Event = new Event("test");
            for (var i:int=0; i<TEST_COUNT; i++) {
                _callback4.call(e);
            }
            var end:Number = new Date().getTime();
            var time:String = (end-start).toString();
            appendText("Callback5 takes : " + time + "ms");
        }
        
        public function testCallback6():void {
            var start:Number = new Date().getTime();
            for (var i:int=0; i<TEST_COUNT; i++) {
                _callback5.call(new CallbackObject("test"));
            }
            var end:Number = new Date().getTime();
            var time:String = (end-start).toString();
            appendText("Callback6 takes : " + time + "ms");
        }
        
        public function testCallback7():void {
            var start:Number = new Date().getTime();
            var obj:CallbackObject = new CallbackObject("test");
            for (var i:int=0; i<TEST_COUNT; i++) {
                _callback5.call(obj);
            }
            var end:Number = new Date().getTime();
            var time:String = (end-start).toString();
            appendText("Callback7 takes : " + time + "ms");
        }
        
        public function appendText(str:String):void {
            _tf.appendText(str+"\n");
        }
    }
}
import flash.events.Event;

class Callback {
    private var _func:Function = null;
    public function Callback(func:Function):void {
        _func = func;
    }
    public function call() :void { _func(); }
}

class Callback2 {
    private var _map:Object = {};
    public function Callback2() {}
    public function addCallback(type:String, func:Function):Boolean {
        if (_map[type] == undefined)
            _map[type] = new Vector.<Function>();
        _map[type].push(func);
        return true;
    }
    public function removeCallback(type:String, func:Function):Boolean {
        try {
            var list:Vector.<Function> = _map[type] as Vector.<Function>;
            var length:uint = list.length;
        }catch(err:Error){ return false; }
        for (var i:int=0; i<length; i++) {
            if (list[i] == func) {
                list.splice(i, 1);
                return true;
            }
        }
        return false;
    }
    public function call(type:String):void {
        try {
            var list:Vector.<Function> = _map[type] as Vector.<Function>;
            var length:uint = list.length;
        }catch(err:Error){}
        for (var i:int=0; i<length; i++) {
            list[i]();
        }
    }
    public function hasCallback(type:String):Boolean {
        try {
            var list:Vector.<Function> = _map[type] as Vector.<Function>;
            var length:uint = list.length;
        }catch(err:Error) { return false; }
        if (length>0)
            return true;
        return false;
    }
    public function willTrigger(type:String):Boolean {
        return hasCallback(type);
    }
}


interface ICallback {
    function addCallback(type:String, func:Function):Boolean;
    function removeCallback(type:String, func:Function):Boolean;
    function hasCallback(type:String):Boolean;
    function willTrigger(type:String):Boolean;
    function call(type:String):void;
}

class Callback3 implements ICallback {
    private var _map:Object = {};
    public function Callback3() {}
    public function addCallback(type:String, func:Function):Boolean {
        if (_map[type] == undefined )
            _map[type] = new Vector.<Function>();
        _map[type].push(func);
        return true;
    }
    
    public function removeCallback(type:String, func:Function):Boolean {
        try {
            var list:Vector.<Function> = _map[type];
            var length:uint = list.length;
        }catch(err:Error){ return false; }
        for (var i:int=0; i<length; i++) {
            if (list[i] == func) {
                list.splice(i, 1);
                return true;
            }
        }
        return false;
    }
    
    public function call(type:String):void {
        try {
            var list:Vector.<Function> = _map[type];
            var length:uint = list.length;
        }catch(err:Error) {}
        for (var i:int=0; i<length; i++) {
            list[i]();
        }
    }
    
    public function hasCallback(type:String):Boolean {
        try {
            var list:Vector.<Function> = _map[type];
            var length:uint = list.length;
        }catch(err:Error) { return false; }
        if (length>0)
            return true;
        return false;
    }
    
    public function willTrigger(type:String):Boolean {
        return hasCallback(type);
    }
}


interface ICallback2 {
    function addCallback(type:String, func:Function):Boolean;
    function removeCallback(type:String, func:Function):Boolean;
    function hasCallback(type:String):Boolean;
    function willTrigger(type:String):Boolean;
    function call(event:Event):void;
}

class Callback4 implements ICallback2 {
    private var _map:Object = {};
    public function Callback4() {}
    public function addCallback(type:String, func:Function):Boolean {
        if (_map[type] == undefined )
            _map[type] = new Vector.<Function>();
        _map[type].push(func);
        return true;
    }
    
    public function removeCallback(type:String, func:Function):Boolean {
        try {
            var list:Vector.<Function> = _map[type];
            var length:uint = list.length;
        }catch(err:Error){ return false; }
        for (var i:int=0; i<length; i++) {
            if (list[i] == func) {
                list.splice(i, 1);
                return true;
            }
        }
        return false;
    }
    
    public function call(e:Event):void {
        try {
            var type:String = e.type;
            var list:Vector.<Function> = _map[type];
            var length:uint = list.length;
        }catch(err:Error) {}
        for (var i:int=0; i<length; i++) {
            list[i]();
        }
    }
    
    public function hasCallback(type:String):Boolean {
        try {
            var list:Vector.<Function> = _map[type];
            var length:uint = list.length;
        }catch(err:Error) { return false; }
        if (length>0)
            return true;
        return false;
    }
    
    public function willTrigger(type:String):Boolean {
        return hasCallback(type);
    }
    
}



interface ICallback3 {
    function addCallback(type:String, func:Function):Boolean;
    function removeCallback(type:String, func:Function):Boolean;
    function hasCallback(type:String):Boolean;
    function willTrigger(type:String):Boolean;
    function call(obj:CallbackObject):void;
}

class CallbackObject {
    public var type:String;
    public function CallbackObject(type:String) {
        this.type = type;
    }
}

class Callback5 implements ICallback3 {
    private var _map:Object = {};
    public function Callback5() {}
    public function addCallback(type:String, func:Function):Boolean {
        if (_map[type] == undefined )
            _map[type] = new Vector.<Function>();
        _map[type].push(func);
        return true;
    }
    
    public function removeCallback(type:String, func:Function):Boolean {
        try {
            var list:Vector.<Function> = _map[type];
            var length:uint = list.length;
        }catch(err:Error){ return false; }
        for (var i:int=0; i<length; i++) {
            if (list[i] == func) {
                list.splice(i, 1);
                return true;
            }
        }
        return false;
    }
    
    public function call(obj:CallbackObject):void {
        try {
            var type:String = obj.type;
            var list:Vector.<Function> = _map[type];
            var length:uint = list.length;
        }catch(err:Error) {}
        for (var i:int=0; i<length; i++) {
            list[i]();
        }
    }
    
    public function hasCallback(type:String):Boolean {
        try {
            var list:Vector.<Function> = _map[type];
            var length:uint = list.length;
        }catch(err:Error) { return false; }
        if (length>0)
            return true;
        return false;
    }
    
    public function willTrigger(type:String):Boolean {
        return hasCallback(type);
    } 
}


class Callback2A extends Callback2 {
    public function Callback2A () { super(); }
}



class Callback2B extends Callback2 {
    private var _map:Object = {};
    public function Callback2B() { super(); }
    override public function addCallback(type:String, func:Function):Boolean {
        if (_map[type] == undefined)
            _map[type] = new Vector.<Function>();
        _map[type].push(func);
        return true;
    }
    override public function removeCallback(type:String, func:Function):Boolean {
        try {
            var list:Vector.<Function> = _map[type] as Vector.<Function>;
            var length:uint = list.length;
        }catch(err:Error){ return false; }
        for (var i:int=0; i<length; i++) {
            if (list[i] == func) {
                list.splice(i, 1);
                return true;
            }
        }
        return false;
    }
    override public function call(type:String):void {
        try {
            var list:Vector.<Function> = _map[type] as Vector.<Function>;
            var length:uint = list.length;
        }catch(err:Error){}
        for (var i:int=0; i<length; i++) {
            list[i]();
        }
    }
    override public function hasCallback(type:String):Boolean {
        try {
            var list:Vector.<Function> = _map[type] as Vector.<Function>;
            var length:uint = list.length;
        }catch(err:Error) { return false; }
        if (length>0)
            return true;
        return false;
    }
    override public function willTrigger(type:String):Boolean {
        return hasCallback(type);
    }
}


















































