/**
 * Copyright hacker_33kw012m ( http://wonderfl.net/user/hacker_33kw012m )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pQaU
 */

// forked from sw_lucchini's forked from: ランダムテキストに座布団つけてみた
// forked from sake's ランダムテキストのサンプル
/*
    よく見るランダムテキストの練習。
    UNIQLO CALENDAR（http://www.uniqlo.com/calendar/）だとこんな感じ？
    テキトウなコメント付き。
*/

package
{
    import flash.display.Sprite;

    [SWF(width="465", height="465", backgroundColor="0xffffff", frameRate="60")]
    public class Main extends Sprite
    {

        public function Main()
        {
            var i:int = 1
            
            var rand1:RandomText=new RandomText("Wonderfl build flash online.");
            addChild(rand1);
            rand1.x = 20;
            rand1.y = 24 * i++;
            
            var rand2:RandomText=new RandomText("ActionScript3.0 and Papervision3D and Tweener.");
            addChild(rand2);
            rand2.x = 20;
            rand2.y = 24 * i++;
            
            var rand3:RandomText=new RandomText("Progression and Box2DFlashAS3 and Tweensy.");
            addChild(rand3);
            rand3.x = 20;
            rand3.y = 24 * i++;

            var rand4:RandomText=new RandomText("Flex and Mete and yui.");
            addChild(rand4);
            rand4.x = 20;
            rand4.y = 24 * i++;

            var rand5:RandomText=new RandomText("ロールオーバーに座布団つけてみました");
            addChild(rand5);
            rand5.x = 20;
            rand5.y = 24 * i++;

            var rand6:RandomText=new RandomText("座布団つけるとちょっといい感じ");
            addChild(rand6);
            rand6.x = 20;
            rand6.y = 24 * i++;

            var rand7:RandomText=new RandomText("メニューバーの演出とかに使えそう");
            addChild(rand7);
            rand7.x = 20;
            rand7.y = 24 * i++;
        }
    }
}

import flash.display.Sprite;
import flash.events.Event;
import flash.events.TimerEvent;
import flash.text.TextField;
import flash.text.TextFieldAutoSize;
import flash.text.TextFormat;
import flash.utils.Timer;
import flash.events.MouseEvent;
import caurina.transitions.*

class RandomText extends Sprite
{
    //ランダムに表示するテキスト
    private var RandSource:String = "0123456789/*-+<>?!=%ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    //渡されてくる文字列
    private var MainString:String;
    //MainStringのlength
    private var Length:int;
    //カウント
    private var ReplaceCount:int;
    //Timer
    private var ReplaceTimer:Timer;
    //出てこなかった
    //private var RandomTimer:Timer;
    //テキストフィールド
    public var MainTextField:TextField;
    //座布団用
    private var bg:Sprite = new Sprite();
    //判定
    private var check:Boolean = false;

    public function RandomText(main_string:String)
    {
        //引数をMainStringに代入
        MainString = main_string;
        //文字数をLengthに代入
        Length = MainString.length;
        //textFieldの作成
        MainTextField = new TextField();
        //textFieldの見た目
        MainTextField.defaultTextFormat = new TextFormat(null, 17, 0x000000);
        //textFieldのテキストとして渡された文字列を入れる。
        MainTextField.text = MainString;
        //左揃え
        MainTextField.autoSize = TextFieldAutoSize.LEFT;
        //mouseが文字に乗っかったとき
        MainTextField.addEventListener(MouseEvent.MOUSE_OVER, onMouseOver);
        //mouseが文字から離れたとき
        MainTextField.addEventListener(MouseEvent.MOUSE_OUT, onMouseOut);
        //文字選択が可能かどうか
        MainTextField.selectable = false;
        //addChildする。
        addChild(MainTextField);
        //タイマーの設定。0.001秒
        ReplaceTimer = new Timer(10);
        //タイマーイベント
        ReplaceTimer.addEventListener(TimerEvent.TIMER, onReplaceTimer);
        
        //座布団用の記述
        //paddingとは肩パッドのことである。
        var padding:int = 3;
        //灰色
        bg.graphics.beginFill(0x444444);
        //四角形。左、上は-3ずらして余白を与えている。幅は、左ずらした3と右に余白を持たせるための3で*2がされている。高さも同じ。
        bg.graphics.drawRect( -padding, -padding, MainTextField.textWidth  + padding * 2, MainTextField.textHeight + padding * 2);
        //横の長さを0にする。
        //bg.scaleX = 0;
        //透明度を0にする。
        bg.alpha = 0;
        //一番下に座布団を敷く
        addChildAt(bg, 0);
        //背景を表示するかしないか
        addEventListener(Event.ENTER_FRAME, onEnterFrame);
    }
    
    private function onMouseOver(e:MouseEvent):void
    {
        check = true;
        MainTextField.textColor = 0xFFFFFF;
        //タイマーが実行中ならとめる
        if (ReplaceTimer.running) ReplaceTimer.stop();
        //カウントを0にする。
        ReplaceCount = 0;
        //タイマーを実行する。
        ReplaceTimer.start();
    }

    private function onMouseOut(e:MouseEvent):void
    {
        check = false;
        MainTextField.textColor = 0x000000;
        if (ReplaceTimer.running) ReplaceTimer.stop();
        MainTextField.text = MainString;
        //マウスから離れたら座布団が縮まりながら消える。
        //Tweener.addTween(bg, { scaleX:0, alpha:0, time:1.25, transition:"easeInCubic" } );
    }

    private function onReplaceTimer(e:TimerEvent):void
    {
        //文字を一時的に空にする。
        MainTextField.text = "";
        var i:int = 0;
        //ReplaceCountの値を超えるまで、MainStringの先頭からi番目の文字をテキストフィールドに追加。
        for (i = 0; i < ReplaceCount; i++) MainTextField.appendText(MainString.charAt(i));
        //文字数からReplaceCountの値を引いた数を超えるまで、RandSourceで指定したランダム文字を次文字に追加する。
        for (i = 0; i < Length - ReplaceCount; i++) MainTextField.appendText(RandSource.charAt(Math.floor(Math.random() * (RandSource.length - 1))));
        //表示しきったらタイマーストップ。
        if (ReplaceCount == Length) ReplaceTimer.stop();
        //カウントアップ。
        ReplaceCount++;
    }
    
    private function onEnterFrame(e:Event):void
    {
        if (check) bg.alpha = 1;
        else bg.alpha = 0;
    }
}